
<?php $__env->startSection('title','Delievered Orders'); ?>
<?php $__env->startSection('order','active show-sub'); ?>
<?php $__env->startSection('delievered','active'); ?>
<?php $__env->startSection('content'); ?>
<nav class="breadcrumb sl-breadcrumb">
  <a class="breadcrumb-item" href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a>
  <span class="breadcrumb-item active">Delievered Orders</span>
</nav>

<div class="sl-pagebody">
    <div class="row row-sm">
        <div class="col-md-12">
            <div class="card pd-10 pd-sm-20">
                <h6 class="card-body-title">Delievered Orders</h6>
                <table class="table responsive" id="order-table">
                    <thead>
                        <tr>
                             <th class="wd-5p">SN</th>
                            <th class="wd-15p">Delievery Date</th>
                            <th class="wd-10p">Invoice</th>
                            <th class="wd-15p">Transaction ID</th>
                            <th class="wd-15p">Amount</th>
                            <th class="wd-5p">Status</th>
                            <th class="wd-20p">Action</th>
                        </tr>
                    </thead>
                     <?php
                        $i = 1;
                    ?>

                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            
                        <tr>
                            <td class="wd-5p"><?php echo e($i++); ?></td>
                            <td class="wd-15p"><?php echo e(Carbon\Carbon::parse($order->delivered_date)->format('d-M-Y')); ?></td>
                            <td class="wd-10p"><?php echo e($order->invoice_no); ?></td>
                            <td class="wd-15p"><?php echo e($order->transaction_id); ?></td>
                            <td class="wd-15p">
                                <?php if($order->currency==='usd'): ?>
                                <?php echo e($order->amount*85); ?>

                                <?php else: ?>
                                <?php echo e($order->amount); ?>

                                <?php endif; ?>
                            </td>
                            <td class="wd-5p"><span class="badge badge-primary"><?php echo e($order->status); ?> </span></td>
                            </td>
                            <td class="wd-20p">
                                <a href="<?php echo e(route('admin.order.detail',['order_id'=>$order->id])); ?>" class="btn btn-success" title="View Product"><i class="fa fa-eye"></i></a>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <script type="text/javascript">
        
        $('#order-table').DataTable({
            responsive: true,
            language: {
            searchPlaceholder: 'Search...',
            sSearch: '',
            lengthMenu: '_MENU_ items/page',
            }
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin-layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/epeccomb/steelbazar.com/resources/views/admin/order/delievered.blade.php ENDPATH**/ ?>