
<?php $__env->startSection('title','Categories'); ?>
<?php $__env->startSection('category','active show-sub'); ?>
<?php $__env->startSection('all-category','active'); ?>
<?php $__env->startSection('content'); ?>
<nav class="breadcrumb sl-breadcrumb">
  <a class="breadcrumb-item" href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a>
  <span class="breadcrumb-item active">Category</span>
</nav>

<div class="sl-pagebody">
    <div class="row row-sm">
        <div class="col-md-8">
            <div class="card pd-10 pd-sm-20">
                <h6 class="card-body-title">All Categories</h6>
                <div class="table-wrapper">
                    <table class="table display responsive" id="brand-table">
                        <thead>
                            <tr>
                                <th>SI</th>
                                <th>Category Name</th>
                                <th>Position</th>
                                <th>Category Icon</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                                $start = 0;
                            ?>
                            <?php $__empty_1 = true; $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>   
                                <tr>
                                    <td><?php echo e(++$start); ?></td>
                                    <td><?php echo e($category->category_name_en); ?></td>
                                    <td><?php echo e($category->category_name_bn); ?></td>
                                    <td><img src="<?php echo e(asset($category->category_icon)); ?>" style="width:100px;" /></td>
                                    <td>
                                        <a href="<?php echo e(url('admin/category/edit/'.$category->id)); ?>" class="btn btn-primary" title="Edit Brand">Edit</a>
                                        <a href="<?php echo e(url('admin/category/delete/'.$category->id)); ?>" class="btn btn-danger" id="delete" title="Delete Brand">Delete</a>
                                    </td>
                                </tr> 
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="5">No Data Found</td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card pd-10 pd-sm-20">
                <h6 class="card-body-title">Add New Category</h6>
                <form action="<?php echo e(route('admin.category.store')); ?>" class="form-layout" method="POST" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?> 
                    <div class="form-group">
                        <label class="form-control-label">Category Name: <span class="tx-danger">*</span></label>
                        <input class="form-control" type="text" name="category_name_en" value="<?php echo e(old('category_name_en')); ?>" placeholder="Enter Category Name" required>
                        <?php $__errorArgs = ['category_name_en'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="text-danger"><?php echo e($message); ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="form-group">
                        <label class="form-control-label">Position: <span class="tx-danger">*</span></label>
                        <input class="form-control" type="text" name="category_name_bn" value="<?php echo e(old('category_name_bn')); ?>" placeholder="Enter Category Position" required>
                        <?php $__errorArgs = ['category_name_bn'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="text-danger">This Position Already Taken.</span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    
                    
                    <div class="form-group">
                        <label class="form-control-label">Category Icon: <span class="tx-danger">*</span></label>
                        <input class="form-control-file" type="file" name="category_icon" value="<?php echo e(old('category_icon')); ?>" required>
                        <?php $__errorArgs = ['category_icon'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="text-danger"><?php echo e($message); ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="form-group">
                        <input class="" type="checkbox" name="show_on_navbar" id="show-navbar" />
                        <label class="form-control-label" for="show-navbar">Show On Navbar</label>
                        
                        <?php $__errorArgs = ['show_on_navbar'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="text-danger"><?php echo e($message); ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="form-layout-footer">
                        <button class="btn btn-info mg-r-5">Save</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <script type="text/javascript">
        $('#brand-table').DataTable({
            responsive: true,
            language: {
            searchPlaceholder: 'Search...',
            sSearch: '',
            lengthMenu: '_MENU_ items/page',
            }
        });
            $(document).on('click','#delete',function(e){
                e.preventDefault();
                let link=$(this).attr('href');
                Swal.fire({
                    title:"Are your sure want to Delete This!",
                    text:'Once deleted, you will not be able to recover',
                    icon:'warning',
                    showDenyButton: true,
                    showCancelButton: true,
                    confirmButtonText: 'Delete',
                    denyButtonText: `Don't Delete`,
                }).then((willDelete)=>{
                    if (willDelete.isConfirmed) {
                        window.location.href=link;
                    }else{
                        Swal.fire('Your Category is safe','', 'info')
                    }
                })
            });
        <?php if(session()->has('success')): ?>
            Swal.fire({
                icon:'success',
                text:"<?php echo e(session('success')); ?>"
            })
        <?php endif; ?>
        <?php if(session()->has('error')): ?>
            Swal.fire({
                icon:'error',
                text:"<?php echo e(session('error')); ?>"
            })
        <?php endif; ?>
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin-layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/epeccomb/steelbazar.com/resources/views/admin/category/index.blade.php ENDPATH**/ ?>