
<?php $__env->startSection('title', 'All Products'); ?>
<?php $__env->startSection('product', 'active show-sub'); ?>
<?php $__env->startSection('all', 'active'); ?>
<?php $__env->startSection('content'); ?>
    <nav class="breadcrumb sl-breadcrumb">
        <a class="breadcrumb-item" href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a>
        <span class="breadcrumb-item active">All Products</span>
    </nav>

    <div class="sl-pagebody">
        <div class="row row-sm">
            <div class="col-md-12">
                <div class="card pd-10 pd-sm-20">
                    <h6 class="card-body-title">Search Product</h6>
                    <form method="POST" action="<?php echo e(route('admin.product.search')); ?>">
                        <?php echo csrf_field(); ?>
                        <div class="row">
                            <div class="col-md-10">
                                <div class="form-group">
                                    <input class="form-control" type="text" name="search" placeholder="Search Keyword" required>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="form-group">
                                    <input class="btn btn-outline-success" value="Search" type="submit">
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        <div class="row row-sm">
            <div class="col-md-12">
                <div class="card pd-10 pd-sm-20">
                    <h6 class="card-body-title">All Products</h6>
                    <table class="table responsive" id="product-table">
                        <thead>
                            <tr>
                                <th class="wd-5p">SI</th>
                                <th class="wd-15p">Name</th>
                                <th class="wd-5p">Price</th>
                                <th class="wd-5p">Discount</th>
                                <th class="wd-15p">Discount Price</th>
                                <th class="wd-15p">Thumbnail</th>
                                <th class="wd-15p">Thumbnail Size</th>
                                <th class="wd-5p">Status</th>
                                <th class="wd-25p">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                                $start = 0;
                            ?>
                            <?php $__empty_1 = true; $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr class="table-row">
                                    <td class="wd-5p"><?php echo e(++$start); ?></td>
                                    <td class="wd-15p"><?php echo e($product->product_name_en); ?></td>
                                    <td class="wd-10p"><?php echo e($product->selling_price); ?></td>
                                    <td class="wd-5p">
                                        <?php if($product->discount != null): ?>
                                            <span class="badge badge-primary"><?php echo e($product->discount); ?> <?php echo e($product->discount_type=='flat' ? "TK" : '%'); ?></span>
                                        <?php else: ?>
                                            <span class="badge badge-warning">No discount</span>
                                        <?php endif; ?>
                                    </td>
                                    <td class="wd-10p">
                                        
                                        <?php if($product->discount_price != null): ?>
                                            <span class="badge badge-primary"><?php echo e($product->discount_price); ?> </span>
                                        <?php else: ?>
                                            <span class="badge badge-warning">No discount</span>
                                        <?php endif; ?>
                                    </td>
                                    <td class="wd-15p">
                                        <div style="width: 100px;">
                                            <img src="<?php echo e(asset($product->product_thumbnail)); ?>" style="width: 100%;"
                                                alt="<?php echo e($product->product_name_en); ?>">
                                        </div>
                                    </td>
                                    <td class="wd-15p">
                                        <?php echo e(intval($product?->thumbnail_size)/1024); ?> KB
                                    </td>
                                    <td class="wd-5p">
                                        <?php if($product->status == 1): ?>
                                            <span class="badge badge-success">Active</span>
                                        <?php else: ?>
                                            <span class="badge badge-danger">Inactive</span>
                                        <?php endif; ?>
                                    </td>
                                    <td class="wd-10p">
                                        <div class="dropdown">
                                            <button class="btn btn-outline-success dropdown-toggle" type="button" id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                <i class="fa fa-ellipsis-v" aria-hidden="true"></i>
                                            </button>
                                            <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                                <li class="dropdown-item" >
                                                    <a href="<?php echo e(route('product.edit', ['id' => $product->id])); ?>" class="btn btn-success"
                                                    title="Edit Product"><i class="fa fa-edit"></i></a>
                                                </li>
                                                <li class="dropdown-item" >
                                                    <a href="<?php echo e(route('prouct.edit.image', ['id' => $product->id])); ?>"
                                                    class="btn btn-pink" title="Edit Product Imges"><i class="fa fa-image"></i></a>
                                                </li>
                                                <li class="dropdown-item" >
                                                    <a target="_blank" href="<?php echo e(route('product.detail', ['id' => $product->id, 'slug' => $product->product_slug_en])); ?>" class="btn btn-primary" title="View Product">
                                                        <i class="fa fa-eye"></i></a>
                                                </li>
                                                <li class="dropdown-item" >
                                                    <a href="<?php echo e(route('product.delete', ['id' => $product->id])); ?>" class="btn btn-danger"
                                                    id="delete" title="Delete Product"><i class="fa fa-trash"></i></a>
                                            
                                                </li>
                                                <?php if($product->status == 1): ?>
                                                <li class="dropdown-item" >
                                                        <a href="<?php echo e(route('product.inactive', ['id' => $product->id])); ?>"
                                                    class="btn btn-danger" title="Inactive Product"><i
                                                        class="fa fa-arrow-down"></i></a>
                                            
                                                </li>
                                                <?php else: ?>
                                                <li class="dropdown-item" >
                                                    <a href="<?php echo e(route('product.active', ['id' => $product->id])); ?>"
                                                    class="btn btn-success"title="Active Product"><i
                                                        class="fa fa-arrow-up"></i></a>
                                            
                                                </li>
                                                <?php endif; ?>
                                            <!--<a href="<?php echo e(route('prouct.edit.image', ['id' => $product->id])); ?>"-->
                                            <!--    class="btn btn-pink" title="Edit Product Imges"><i class="fa fa-image"></i></a>-->
                                            <!--<a href="" class="btn btn-primary" title="View Product"><i-->
                                            <!--        class="fa fa-eye"></i></a>-->
                                            <!--<a href="<?php echo e(route('product.delete', ['id' => $product->id])); ?>" class="btn btn-danger"-->
                                            <!--    id="delete" title="Delete Product"><i class="fa fa-trash"></i></a>-->
                                            <!--<?php if($product->status == 1): ?>-->
                                            <!--    <a href="<?php echo e(route('product.inactive', ['id' => $product->id])); ?>"-->
                                            <!--        class="btn btn-danger" title="Inactive Product"><i-->
                                            <!--            class="fa fa-arrow-down"></i></a>-->
                                            <!--<?php else: ?>-->
                                            <!--    <a href="<?php echo e(route('product.active', ['id' => $product->id])); ?>"-->
                                            <!--        class="btn btn-success"title="Active Product"><i-->
                                            <!--            class="fa fa-arrow-up"></i></a>-->
                                            <!--<?php endif; ?>-->
                                          </ul>
                                        </div>
                                        <!--<div class="action">-->
                                        <!--    <button type="button" class="btn btn-outline-success action-toggler"><i class="fa fa-ellipsis-v" aria-hidden="true"></i></button>-->
                                        <!--    <div class="action-items">-->
                                        <!--        <a href="<?php echo e(route('product.edit', ['id' => $product->id])); ?>" class="btn btn-success"-->
                                        <!--    title="Edit Product"><i class="fa fa-edit"></i></a>-->
                                        <!--    <a href="<?php echo e(route('prouct.edit.image', ['id' => $product->id])); ?>"-->
                                        <!--        class="btn btn-pink" title="Edit Product Imges"><i class="fa fa-image"></i></a>-->
                                        <!--    <a href="" class="btn btn-primary" title="View Product"><i-->
                                        <!--            class="fa fa-eye"></i></a>-->
                                        <!--    <a href="<?php echo e(route('product.delete', ['id' => $product->id])); ?>" class="btn btn-danger"-->
                                        <!--        id="delete" title="Delete Product"><i class="fa fa-trash"></i></a>-->
                                        <!--    <?php if($product->status == 1): ?>-->
                                        <!--        <a href="<?php echo e(route('product.inactive', ['id' => $product->id])); ?>"-->
                                        <!--            class="btn btn-danger" title="Inactive Product"><i-->
                                        <!--                class="fa fa-arrow-down"></i></a>-->
                                        <!--    <?php else: ?>-->
                                        <!--        <a href="<?php echo e(route('product.active', ['id' => $product->id])); ?>"-->
                                        <!--            class="btn btn-success"title="Active Product"><i-->
                                        <!--                class="fa fa-arrow-up"></i></a>-->
                                        <!--    <?php endif; ?>-->
                                        <!--    </div>-->
                                        <!--</div>-->
                                        
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <?php endif; ?>
                        </tbody>
                    </table>
                    <nav aria-label="Page navigation example">
                        <ul class="pagination justify-content-end">
                            <?php echo e($products->links()); ?>

                        </ul>
                    </nav>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <script type="text/javascript">
        $(document).ready(function() {

            $('select[name="category_id"]').on('change', function() {
                let categoryId = $(this).val();
                if (categoryId) {
                    $.ajax({
                        url: "/admin/sub/sub-category/filter/" + categoryId,
                        type: "GET",
                        dataType: "json",
                        success: function(data) {
                            console.log(data)
                            let d = $('select[name="subcategory_id"]').empty();
                            $.each(data, function(key, value) {
                                $('select[name="subcategory_id"]').append(
                                    '<option value="' + value.id + '">' + value
                                    .subcategory_name_en + '</option>'
                                );
                            })
                        },
                        error: function() {
                            console.log('No Data Found')
                        }
                    });
                }
            });
        });
        // $('#product-table').DataTable({
        //     responsive: true,
        //     language: {
        //         searchPlaceholder: 'Search...',
        //         sSearch: '',
        //         lengthMenu: '_MENU_ items/page',
        //     }
        // });
        $(document).on('click', '#delete', function(e) {
            e.preventDefault();
            let link = $(this).attr('href');
            Swal.fire({
                title: "Are your sure want to Delete This!",
                text: 'Once deleted, you will not be able to recover',
                icon: 'warning',
                showDenyButton: true,
                showCancelButton: true,
                confirmButtonText: 'Delete',
                denyButtonText: `Don't Delete`,
            }).then((willDelete) => {
                if (willDelete.isConfirmed) {
                    window.location.href = link;
                } else {
                    Swal.fire('Product is safe', '', 'info')
                }
            })
        });
        <?php if(session()->has('success')): ?>
            Swal.fire({
                icon: 'success',
                text: "<?php echo e(session('success')); ?>"
            })
        <?php endif; ?>
        <?php if(session()->has('error')): ?>
            Swal.fire({
                icon: 'error',
                text: "<?php echo e(session('error')); ?>"
            })
        <?php endif; ?>
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin-layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/steellbaazaar/public_html/resources/views/admin/product/index.blade.php ENDPATH**/ ?>