
<?php $__env->startSection('title','State | Shipping Area'); ?>
<?php $__env->startSection('shipping-area','active show-sub'); ?>
<?php $__env->startSection('state','active'); ?>
<?php $__env->startSection('content'); ?>
<nav class="breadcrumb sl-breadcrumb">
  <a class="breadcrumb-item" href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a>
  <span class="breadcrumb-item active">State</span>
</nav>

<div class="sl-pagebody">
    <div class="row row-sm">
        <div class="col-md-8">
            <div class="card pd-10 pd-sm-20">
                <h6 class="card-body-title">All States</h6>
                <div class="table-wrapper">
                    <table class="table display responsive nowrap" id="brand-table">
                        <thead>
                            <tr>
                                <th>SI</th>
                                <th>Divison Name</th>
                                <th>District Name</th>
                                <th>State Name</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                                $start = 0;
                            ?>
                            <?php $__empty_1 = true; $__currentLoopData = $states; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $state): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>   
                                <tr>
                                    <td><?php echo e(++$start); ?></td>
                                    <td><?php echo e($state->division->name); ?></td>
                                    <td><?php echo e($state->district->name); ?></td>
                                    <td><?php echo e($state->name); ?></td>
                                    <td>
                                        <a href="<?php echo e(route('shipping.state.edit',['id'=>$state->id])); ?>" class="btn btn-primary" title="Edit Division">Edit</a>
                                        <a href="<?php echo e(route('shipping.state.delete',['id'=>$state->id])); ?>" class="btn btn-danger" id="delete" title="Delete Division">Delete</a>
                                    </td>
                                </tr> 
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="5">No Data Found</td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card pd-10 pd-sm-20">
                <h6 class="card-body-title">Add New State</h6>
                <form action="<?php echo e(route('shipping.state.store')); ?>" class="form-layout" method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="form-group">
                        <label class="form-control-label">Select Division: <span class="tx-danger">*</span></label>
                        <select class="form-control select2 select2-show-search" name="division_id" id="division" data-placeholder="Choose one">
                            <option>Choose Division</option>
                            <?php $__currentLoopData = $divisions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $division): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($division->id); ?>"><?php echo e($division->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <?php $__errorArgs = ['division_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="text-danger"><?php echo e($message); ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="form-group">
                        <label class="form-control-label">Select District: <span class="tx-danger">*</span></label>
                        <select class="form-control select2 select2-show-search" name="district_id" id="district" data-placeholder="Choose one">
                            
                        </select>
                        <?php $__errorArgs = ['district_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="text-danger"><?php echo e($message); ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="form-group">
                        <label class="form-control-label">State Name: <span class="tx-danger">*</span></label>
                        <input class="form-control" type="text" name="name" value="<?php echo e(old('name')); ?>" placeholder="Enter State Name" required>
                        <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="text-danger"><?php echo e($message); ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="form-layout-footer">
                        <button class="btn btn-info mg-r-5">Save</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
<script src="<?php echo e(asset('assets/backend/js/axios.min.js')); ?>" type="text/javascript"></script>
    <script type="text/javascript">
        $('#division').on('change',function () {
            let id=$(this).val();
            console.log(id);
            axios.get("<?php echo e(url('/admin/district/get')); ?>/"+id)
            .then(function (response) {
                if (response.status===200) {
                    $('#district').empty();
                    let districts=response.data;
                    $.each(districts,function (i,district) {
                        $('#district').append(
                            '<option value="'+district.id+'">'+district.name+'</option>'
                        )
                    })
                }
            }).catch(function (error) {
                
            })
        })
        $('#brand-table').DataTable({
            responsive: true,
            language: {
            searchPlaceholder: 'Search...',
            sSearch: '',
            lengthMenu: '_MENU_ items/page',
            }
        });
            $(document).on('click','#delete',function(e){
                e.preventDefault();
                let link=$(this).attr('href');
                Swal.fire({
                    title:"Are your sure want to Delete This!",
                    text:'Once deleted, you will not be able to recover',
                    icon:'warning',
                    showDenyButton: true,
                    showCancelButton: true,
                    confirmButtonText: 'Delete',
                    denyButtonText: `Don't Delete`,
                }).then((willDelete)=>{
                    if (willDelete.isConfirmed) {
                        window.location.href=link;
                    }else{
                        Swal.fire('Your Category is safe','', 'info')
                    }
                })
            });
        <?php if(session()->has('success')): ?>
            Swal.fire({
                icon:'success',
                text:"<?php echo e(session('success')); ?>"
            })
        <?php endif; ?>
        <?php if(session()->has('error')): ?>
            Swal.fire({
                icon:'error',
                text:"<?php echo e(session('error')); ?>"
            })
        <?php endif; ?>
        
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin-layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/steellbaazaar/public_html/resources/views/admin/shipping-area/state/index.blade.php ENDPATH**/ ?>