
<?php $__env->startSection('title','Order Details'); ?>
<?php $__env->startSection('order','active show-sub'); ?>
<?php $__env->startSection('content'); ?>
<nav class="breadcrumb sl-breadcrumb">
  <a class="breadcrumb-item" href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a>
  <span class="breadcrumb-item active">Order Details</span>
</nav>

<div class="sl-pagebody">
    <div class="row row-sm">
        <div class="col-md-12">
            <div class="card pd-10 pd-sm-20">
                <div class="row">
                    <div class="col-md-6">
                        <div class="user-info">
                            <h3 class="bg-primary" style="border-radius: 5px; color:#fff; font-size:20px;font-weight:400;padding:20px;">User Information</h3>
                            <table class="table responsive">
                                <tr>
                                    <td colspan="2" class="userImageForOrder">
                                        <img src="<?php echo e(asset($order?->user?->image)); ?>">
                                    </td>
                                </tr>
                                <tr>
                                    <td>User Name:</td>
                                    <td><?php echo e($order?->user?->name); ?></td>
                                </tr>
                                <tr>
                                    <td>User Email:</td>
                                    <td><?php echo e($order?->user?->email); ?></td>
                                </tr>
                                <tr>
                                    <td>User Phone:</td>
                                    <td><?php echo e($order?->user?->phone); ?></td>
                                </tr>
                            </table>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="shpping-info">
                            <h3 class="bg-primary" style="color:#fff; font-size:20px;font-weight:400;padding:20px;border-radius: 5px;">Shipping Information</h3> 
                            <table class="table responsive">
                                <tr>
                                    <td>Shipping Name:</td>
                                    <td><?php echo e($order->name); ?></td>
                                </tr>
                                <tr>
                                    <td>Shipping Email:</td>
                                    <td><?php echo e($order->email); ?></td>
                                </tr>
                                <tr>
                                    <td>Shipping Phone:</td>
                                    <td><?php echo e($order->phone); ?></td>
                                </tr>
                                <tr>
                                    <td>Shipping Address:</td>
                                    <td><?php echo e($order?->division?->name); ?>,<?php echo e($order?->district?->name); ?>,<?php echo e($order->state->name); ?> - <?php echo e($order->address1); ?></td>
                                </tr>
                                <tr>
                                    <td>Post Code:</td>
                                    <td><?php echo e($order?->post_code); ?></td>
                                </tr>
                                <tr>
                                    <td>Invoice NO:</td>
                                    <td><span class="badge badge-success"><?php echo e($order?->invoice_no); ?></span></td>
                                </tr>
                                <tr>
                                    <td>Order Date:</td>
                                    <td><?php echo e($order->order_date); ?></td>
                                </tr>
                                <tr>
                                    <td>Transaction ID</td>
                                    <td><?php echo e($order->transaction_id); ?></td>
                                </tr>
                                <tr>
                                    <td>Payment Method</td>
                                    <td><?php echo e($order->payment_method); ?></td>
                                </tr>
                                <tr>
                                    <td>Payment Type</td>
                                    <td><?php echo e($order->payment_type); ?></td>
                                </tr>
                                <tr>
                                    <td>Amount</td>
                                    <td style="text-transform: uppercase;"><?php echo e($order->amount); ?>(<?php echo e($order->currency); ?>)</td>
                                </tr>
                                <tr>
                                    <td colspan="2">
                                        <?php if($order->status=='confirmed'): ?>
                                            <a href="<?php echo e(route('admin.order.processing',['order_id'=>$order->id])); ?>" class="btn btn-success btn-block" id="processing">
                                                Processing
                                            </a>
                                        <?php elseif($order->status=='processing'): ?>
                                            <a href="<?php echo e(route('admin.order.ship',['order_id'=>$order->id])); ?>" class="btn btn-success btn-block" id="shipped">
                                                Shipped
                                            </a>
                                        <?php elseif($order->status=='shipped'): ?>
                                            <a href="<?php echo e(route('admin.order.pick',['order_id'=>$order->id])); ?>" class="btn btn-success btn-block" id="picked">
                                                Picked
                                            </a>
                                        <?php elseif($order->status=='picked'): ?>
                                            <a href="<?php echo e(route('admin.order.deliever',['order_id'=>$order->id])); ?>" class="btn btn-success btn-block" id="delivered">
                                                Delievered
                                            </a>
                                        <?php else: ?>
                                            <a href="<?php echo e(route('admin.order.confirm',['order_id'=>$order->id])); ?>" class="btn btn-success btn-block" id="confirm">
                                                Confirm
                                            </a>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                            </table>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <table class="table responsive">
                            <thead>
                                <tr>
                                    <th>Product Name</th>
                                    <th>Product Image</th>
                                    <th>Product Size</th>
                                    <th>Product Color</th>
                                    <th>Product Quantity</th>
                                    <th>Thickness</th>
                                    <th>Unit</th>
                                    <th>Unit Price</th>
                                    <th>Total Price</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $orderItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $orderItem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($orderItem?->product?->product_name_en); ?></td>
                                        <td style="width: 200px;">
                                            <img src="<?php echo e(asset($orderItem?->product?->product_thumbnail)); ?>" style="width:100%;">
                                        </td>
                                        <td>
                                            
                                            <?php echo e($orderItem?->size); ?>

                                            
                                        </td>
                                        <td>
                                           
                                            <?php echo e($orderItem?->color); ?>

                                        </td>
                                        <td>
                                            <?php echo e($orderItem->qty); ?>

                                        </td>
                                        <td>
                                            <?php echo e($orderItem->thickness); ?>

                                        </td>
                                        <td>
                                            <?php echo e($orderItem?->unit); ?>

                                        </td>
                                         <td>
                                            <?php echo e($orderItem?->price); ?>

                                        </td> 
                                        <td>
                                            <?php echo e($orderItem?->price * $orderItem->qty); ?>

                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <script type="text/javascript">
        
        $('#order-table').DataTable({
            responsive: true,
            language: {
            searchPlaceholder: 'Search...',
            sSearch: '',
            lengthMenu: '_MENU_ items/page',
            }
        });
        //Confirm Order
        $(document).on('click','#confirm',function(e){
            e.preventDefault();
            let link=$(this).attr('href');
            Swal.fire({
                title:"Are your sure want to Confirm This Order!",
                text:'Once Confirmed, you will not be able to recover',
                icon:'warning',
                showDenyButton: true,
                showCancelButton: true,
                confirmButtonText: 'Confirm',
                denyButtonText: `Don't Confirm`,
                }).then((willDelete)=>{
                if (willDelete.isConfirmed) {
                    window.location.href=link;
                }else{
                    Swal.fire('Product is Pending','', 'info')
                }
            })
        });
        //Confirm Processing
        $(document).on('click','#processing',function(e){
            e.preventDefault();
            let link=$(this).attr('href');
            Swal.fire({
                title:"Are your sure This Order is Processing!",
                text:'Once Processing, you will not be able to recover',
                icon:'warning',
                showDenyButton: true,
                showCancelButton: true,
                confirmButtonText: 'Processing',
                denyButtonText: `Don't Processing`,
                }).then((willDelete)=>{
                if (willDelete.isConfirmed) {
                    window.location.href=link;
                }else{
                    Swal.fire('Product is Confirmed','', 'info')
                }
            })
        });
        //Confirm Shipped
        $(document).on('click','#shipped',function(e){
            e.preventDefault();
            let link=$(this).attr('href');
            Swal.fire({
                title:"This order is ready to Shipped!",
                text:'Once Shipped, you will not be able to recover',
                icon:'warning',
                showDenyButton: true,
                showCancelButton: true,
                confirmButtonText: 'Shipped',
                denyButtonText: `Don't Shipped`,
                }).then((willDelete)=>{
                if (willDelete.isConfirmed) {
                    window.location.href=link;
                }else{
                    Swal.fire('Product is Processing','', 'info')
                }
            })
        });
        //Confirm Picked
        $(document).on('click','#picked',function(e){
            e.preventDefault();
            let link=$(this).attr('href');
            Swal.fire({
                title:"This order is ready to Picked!",
                text:'Once Picked, you will not be able to recover',
                icon:'warning',
                showDenyButton: true,
                showCancelButton: true,
                confirmButtonText: 'Picked',
                denyButtonText: `Don't Picked`,
                }).then((willDelete)=>{
                if (willDelete.isConfirmed) {
                    window.location.href=link;
                }else{
                    Swal.fire('Product is Shipped','', 'info')
                }
            })
        });
        //Confirm Delievered
        $(document).on('click','#delievered',function(e){
            e.preventDefault();
            let link=$(this).attr('href');
            Swal.fire({
                title:"This order is ready to Delievered!",
                text:'Once Delievered, you will not be able to recover',
                icon:'warning',
                showDenyButton: true,
                showCancelButton: true,
                confirmButtonText: 'Delievered',
                denyButtonText: `Don't Delievered`,
                }).then((willDelete)=>{
                if (willDelete.isConfirmed) {
                    window.location.href=link;
                }else{
                    Swal.fire('Product is Shipped','', 'info')
                }
            })
        });
        <?php if(session()->has('success')): ?>
            Swal.fire({
                icon:'success',
                text:"<?php echo e(session('success')); ?>"
            })
        <?php endif; ?>
        <?php if(session()->has('error')): ?>
            Swal.fire({
                icon:'error',
                text:"<?php echo e(session('error')); ?>"
            })
        <?php endif; ?>
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin-layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/steellbaazaar/public_html/resources/views/admin/order/order-detail.blade.php ENDPATH**/ ?>