<?php
use Gloudemans\Shoppingcart\Facades\Cart;
?>
<header class="header-style-1">
    <!-- ===== TOP MENU ============ -->
    <div id="mobile-header" style="display: none;">
        <div class="header-top-row">
            <div class="toggler">
                <button type="button" class="toggler-btn" id="toggler-btn" onclick="showNav()">
                    <i class="icon fa fa-align-justify fa-fw"></i>
                </button>
                    <div class="mobile-nav">
                        <div class="head"> <span> Categories</span>
                            <button type="button" class="close-btn" id="close-btn" onclick="hideNav()">
                                <i class="icon fa fa-times fa-fw"></i>
                            </button>
                        </div>
    
                        <?php if ($__env->exists('components.navbar.main-nav')) echo $__env->make('components.navbar.main-nav', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                
                
            </div>
            <div class="search-box">
                <div class="search-area">
                    <form action="<?php echo e(route('product.search')); ?>" method="GET">
                        
                        <div class="control-group">
                            <input class="search-field" name="search" placeholder="Search here..." />
                            <button class="search-button" type="submit"></button>
                        </div>
                    </form>
                </div><!-- /.search-area -->
            </div>
            <div class="indicator">
                <button type="button" class="indicator-btn" onclick="openProfile()">
                    <i class="fa fa-ellipsis-v" aria-hidden="true"></i>
                </button>
                <div class="mobile-topbar-nav social">
                    <button type="button" class="topbar-close-btn" onclick="closeProfile()">
                        <i class="icon fa fa-times fa-fw"></i>
                    </button>
                    <ul>
                        <?php if(auth()->guard()->check()): ?>
                            <?php if ($__env->exists('components.mobile.profile')) echo $__env->make('components.mobile.profile', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <?php else: ?>
                            <li>
                                <a href="#"><i class="icon fa fa-info"></i>
                                    Please Login to see your profile
                                </a>
                            </li>
                        <?php endif; ?>
                        <li>
                            <a href="<?php echo e(route('user.wishlist.view')); ?>"><i class="icon fa fa-heart"></i>
                                Wishlist
                            </a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('user.cart.index')); ?>"><i class="icon fa fa-shopping-cart"></i>
                                My Cart
                            </a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('user.checkout')); ?>" id="checkout"><i class="icon fa fa-check"></i>

                                CheckOut

                            </a>
                        </li>
                        <?php if(auth()->guard()->check()): ?>
                            <li>
                                <a href="<?php echo e(route('user.dashboard')); ?>" target="_blank"><i class="icon fa fa-user"></i>
                                    My Account
                                </a>
                            </li>
                        <?php else: ?>
                            <li>
                                <a href="<?php echo e(route('login')); ?>"><i class="icon fa fa-lock"></i>

                                    Login
                                </a>
                            </li>
                            <li>
                                <a href="<?php echo e(route('register')); ?>">
                                    <i class="icon fa fa-lock"></i>

                                    Register
                                </a>
                            </li>
                        <?php endif; ?>
                    </ul>
                    <div class="logo">
                        <a href="<?php echo e(url('/')); ?>">
                            <img src="<?php echo e(asset($setting->logo)); ?>" alt="">
                        </a>
                    </div>
                    <ul class="link social-links text-center">
                        <li class="fb pull-left">
                            <a target="_blank" rel="nofollow" href="<?php echo e($setting->facebook); ?>" title="Facebook">
                                
                            </a>
                        </li>
                        <li class="tw pull-left">
                            <a target="_blank" rel="nofollow" href="<?php echo e($setting->twitter); ?>"
                            title="Twitter">
                                
                            </a>
                        </li>
                    
                        <li class="whatsapp pull-left">
                            <a target="_blank" rel="nofollow" href="<?php echo e($setting->whatsapp); ?>"
                            title="PInterest">
                            </a>
                        </li>
                        <li class="linkedin pull-left">
                            <a target="_blank" rel="nofollow"
                            href="<?php echo e($setting->linkedin); ?>" title="Linkedin">
                                
                            </a>
                        </li>
                        <li class="youtube pull-left">
                            <a target="_blank" rel="nofollow"
                            href="<?php echo e($setting->youtube); ?>" title="Youtube">
                                
                            </a>
                        </li>
                    </ul>
                    <div class="mobile-copyright">
                        <span>All Right Reserved <a href="epec.com.bd">EPEC.</a></span>
                        <span>Developed & Maintain By<a href="bitscol.com">BITSCOL</a></span>
                    </div>
                </div>

            </div>
        </div>
        <div class="logo">
            <a href="<?php echo e(url('/')); ?>">
                <img src="<?php echo e(asset($setting->logo)); ?>" alt="">
            </a>
        </div><!-- /.logo -->
    </div>
    <div id="desktop-header" class="fixed">
        <div class="top-bar animate-dropdown">
            <div class="container">
                <div class="header-top-inner" id="header-top-inner">
                    <div class="cnt-account">
                        <ul class="list-unstyled">
                            <li>
                                <a href="<?php echo e(route('user.wishlist.view')); ?>"><i class="icon fa fa-heart"></i>
                                    Wishlist
                                </a>
                            </li>
                            <li>
                                <a href="<?php echo e(route('user.cart.index')); ?>"><i class="icon fa fa-shopping-cart"></i>
                                    My Cart
                                </a>
                            </li>
                            <li>
                                <a href="<?php echo e(route('user.checkout')); ?>" id="checkout"><i class="icon fa fa-check"></i>
                                    CheckOut
                                </a>
                            </li>
                            <?php if(auth()->guard()->check()): ?>
                                <li>
                                    <a href="<?php echo e(route('user.dashboard')); ?>" target="_blank"><i class="icon fa fa-user"></i>
                                        My Account
                                    </a>
                                </li>
                            <?php else: ?>
                                <li>
                                    <a href="<?php echo e(route('login')); ?>"><i class="icon fa fa-lock"></i>
                                        Login
                                    </a>
                                </li>
                                <li>
                                    <a href="<?php echo e(route('register')); ?>"><i class="icon fa fa-lock"></i>
                                        Register
                                    </a>
                                </li>
                            <?php endif; ?>
                        </ul>
                    </div><!-- /.cnt-account -->

                    <div class="cnt-block">
                        
                    </div><!-- /.cnt-cart -->
                    <div class="clearfix"></div>
                </div><!-- /.header-top-inner -->
            </div><!-- /.container -->
        </div><!-- /.header-top -->
        <!-- ===================== TOP MENU : END ==================== -->
        <div class="main-header">
            <div class="container">
                
                <div class="row" id="main-header">
                    <div class="col-xs-12 col-sm-12 col-md-2 logo-holder">
                        <!-- ==================== LOGO ================= -->
                        <div class="logo">
                            <a href="<?php echo e(url('/')); ?>">
                                <img src="<?php echo e(asset($setting->logo)); ?>" alt="">
                            </a>
                        </div><!-- /.logo -->
                        <!-- ======== LOGO : END ===== -->
                    </div><!-- /.logo-holder -->

                    <div class="col-xs-12 col-sm-12 col-md-7 top-search-holder">
                        <!-- /.contact-row -->
                        <!-- ================ SEARCH AREA ===================== -->
                        <div class="search-area">
                            <form action="<?php echo e(route('product.search')); ?>" method="GET">
                                
                                <div class="control-group">
                                    <input class="search-field" name="search" placeholder="Search here..." />
                                    <button class="search-button" type="submit"></button>
                                </div>
                            </form>
                        </div><!-- /.search-area -->
                        <!-- =========== SEARCH AREA : END ============= -->
                    </div><!-- /.top-search-holder -->

                    <div class="col-xs-12 col-sm-12 col-md-3 animate-dropdown top-cart-row">
                        <!-- ==== SHOPPING CART DROPDOWN ======= -->

                        <div class="dropdown dropdown-cart">
                            <a href="#" class="dropdown-toggle lnk-cart" data-toggle="dropdown">
                                <div class="items-cart-inner">
                                    <div class="basket">
                                        <i class="glyphicon glyphicon-shopping-cart"></i>
                                    </div>
                                    <div class="basket-item-count"><span class="count" id="count"> <?php echo e(Cart::content()->count()); ?></span></div>
                                    <div class="total-price-basket">
                                        <span class="lbl">cart - </span>
                                        <span class="total-price">
                                            <span class="sign">৳</span><span class="value total"
                                                id="total"><?php echo e(Cart::total()); ?></span>
                                        </span>
                                    </div>


                                </div>
                            </a>
                            <ul class="dropdown-menu">
                                <li id="mini-cart-list">
                                    <div class="cart-item product-summary" id="mini-cart">
                                        <?php $__empty_1 = true; $__currentLoopData = Cart::content(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <div class="row">
                    						<div class="col-xs-4">
                    							<div class="image">
                    								<img src="<?php echo e(asset($item?->options['image'] ?? '')); ?>" alt="">
                    							</div>
                    						</div>
                    						<div class="col-xs-7">
                    							
                    							<h3 class="name"><?php echo e($item->name); ?></h3>
                    							<div class="price">৳ <?php echo e($item->price); ?></div>
                    						</div>
                    						<div class="col-xs-1 action">
                    							
                    							<a  href="<?php echo e(route('cart.remove',$item->rowId)); ?>"><i class="fa fa-trash"></i></a>
                    						</div>
                    					</div>
                    					<hr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                            No Item Found
                                        <?php endif; ?>
                                    </div><!-- /.cart-item -->
                                    <div class="clearfix"></div>

                                    <div class="clearfix cart-total">
                                        <div class="pull-right">

                                            <span class="text">Sub Total :</span><span class='price total'>৳ <?php echo e(Cart::total()); ?></span>

                                        </div>
                                        <div class="clearfix"></div>

                                        <a href="<?php echo e(route('user.cart.index')); ?>"
                                            class="btn btn-upper btn-primary btn-block m-t-20">My Cart</a>
                                    </div><!-- /.cart-total-->


                                </li>
                            </ul><!-- /.dropdown-menu-->
                        </div><!-- /.dropdown-cart -->

                        <!-- ======= SHOPPING CART DROPDOWN : END======= -->
                    </div><!-- /.top-cart-row -->
                </div><!-- /.row -->

            </div><!-- /.container -->

        </div><!-- /.main-header -->

        <!-- ===================== NAVBAR ===================== -->
        <div class="header-nav animate-dropdown">
            <div class="container">
                <div class="yamm navbar navbar-default" role="navigation">
                    <div class="navbar-header">
                        <button data-target="#mc-horizontal-menu-collapse" data-toggle="collapse"
                            class="navbar-toggle collapsed" type="button">
                            <span class="sr-only">Toggle navigation</span>
                            <span class="icon-bar"></span>
                            <span class="icon-bar"></span>
                            <span class="icon-bar"></span>
                        </button>
                    </div>
                    <div class="nav-bg-class">
                        <div class="navbar-collapse collapse" id="mc-horizontal-menu-collapse">
                            <div class="nav-outer">
                                <ul class="nav navbar-nav">
                                    <li class="<?php echo $__env->yieldContent('home'); ?> yamm-fw">
                                        <a href="<?php echo e(url('/')); ?>" 
                                            class="dropdown-toggle">Home</a>

                                    </li>
                                    
                                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if($category->show_on_navbar==1): ?>
                                        <li class="dropdown yamm mega-menu <?php echo $__env->yieldContent($category->category_name_en); ?>">
                                            <?php
                                                $hasSubCategory = \App\Models\SubCategory::where('category_id', $category->id)->count();
                                            ?>
                                            <a href="<?php echo e(route('product.parent.category',['id'=>$category->id,'slug'=>$category->category_slug_en])); ?>" data-hover="<?php echo e($hasSubCategory > 0 ? 'dropdown' : ''); ?>" class="dropdown-toggle"
                                                data-toggle="<?php echo e($hasSubCategory > 0 ? 'dropdown' : ''); ?>">
                                                <?php echo e($category->category_name_en); ?>

                                            </a>
                                            <ul class="dropdown-menu container">
                    
                                                <li>
                                                    <div class="yamm-content ">
                                                        <div class="row">
                                                            <?php $__currentLoopData = $subCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subCategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <?php if($category->id == $subCategory->category_id): ?>
                                                                    <div class="col-xs-12 col-sm-6 col-md-2 col-menu">
                                                                        <h2 class="title">
                                                                            
                                                                            <a
                                                                                href="<?php echo e(route('product.category', ['id' => $subCategory->id, 'slug' => $subCategory->subcategory_slug_en])); ?>">
                                                                                <?php echo e($subCategory->subcategory_name_en); ?>

                                                                                
                                                                            </a>
                                                                        </h2>
                                                                        <ul class="links">
                                                                            <?php $__currentLoopData = $subSubCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subSubCategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                                <?php if($subCategory->id == $subSubCategory->subcategory_id): ?>
                                                                                    <li>
                                                                                        <a href="<?php echo e(route('product.subSubCategory', ['id' => $subSubCategory->id, 'slug' => $subSubCategory->subsubcategory_slug_en])); ?>"><?php echo e($subSubCategory->subsubcategory_name_en); ?></a>
                                                                                    </li>
                                                                                <?php endif; ?>
                                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                        </ul>
                                                                    </div><!-- /.col -->
                                                                <?php endif; ?>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </div>
                                                    </div>

                                                </li>
                                            </ul>

                                        </li>
                                    <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    
                                </ul><!-- /.navbar-nav -->
                                <div class="clearfix"></div>
                            </div><!-- /.nav-outer -->
                        </div><!-- /.navbar-collapse -->


                    </div><!-- /.nav-bg-class -->
                </div><!-- /.navbar-default -->
            </div><!-- /.container-class -->

        </div><!-- /.header-nav -->
    </div>

    <!-- ======== NAVBAR : END ============== -->

</header>
<?php /**PATH /home/epeccomb/steelbazar.com/resources/views/frontend/inc/header.blade.php ENDPATH**/ ?>