
<?php $__env->startSection('title', 'User Profile'); ?>
<?php $__env->startSection('content'); ?>
    <div class="body-content">
        <div class="container user-dashboard">
            <div class="row">
                <?php echo $__env->make('user.inc.sideNav', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <div class="col-sm-7" style="margin-top: 30px;">
                    <div class="tracking-from" style="background: #fff;padding:30px;">
                        <form action="<?php echo e(route('user.order.track')); ?>" method="POST" class="form">
                            <?php echo csrf_field(); ?>
                            <div class="form-group">
                                <label for="">Order Invoice NO</label>
                                <input type="text" id="invocie-no" name="invoice_no" placeholder="Enter Order Invoice NO"
                                    class="form-control">
                            </div>
                            <div class="form-group">
                                <button class="btn btn-success" type="submit">Track</button>
                            </div>
                        </form>
                    </div>
                    <?php if($order): ?>
                        <div class="shopping-cart">
                            <h3>Last order</h3>
                            <div class="shopping-cart-table ">
                                <div class="table-responsive order-table">
                                    <table class="table table-responsive">
                                        <thead>
                                            <tr>
                                                <th>Order Date</th>
                                                <th>Amount (TK)</th>
                                                <th>Invoice NO</th>
                                                <th>Status</th>
                                                <th>Action</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr>
                                                <td><?php echo e($order->order_date); ?></td>
                                                <td><?php echo e($order->amount); ?></td>
                                                <td><?php echo e($order->invoice_no); ?></td>
                                                <td><span class="badge" style="background: #318bc0;color:#fff;">
                                                        <?php echo e($order->status); ?></span></td>
                                                <td>
                                                    <a href="<?php echo e(route('user.order.product', ['order_id' => $order->id])); ?>"
                                                        class="btn btn-success" style="margin:5px 0;"><i class="fa fa-eye">
                                                            View</i></a>
                                                    <a href="<?php echo e(route('user.order.invoice', ['order_id' => $order->id])); ?>"
                                                        class="btn btn-danger"><i class="fa fa-download"> Invoice</i></a>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
                <div class="col-sm-2" style="margin-top: 30px;">

                    <div class="profile-image">
                        <img src="<?php echo e(asset($user->image)); ?>" alt="<?php echo e($user->name); ?>" style="width: 150px;">
                    </div>

                    <div class="profile-ingo">
                        <h4>Name : <?php echo e($user->name); ?></h4>
                        <p>Email : <?php echo e($user->email); ?></p>
                        <p>Phone : <?php echo e($user->phone); ?></p>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <script type="text/javascript">
        <?php if(session()->has('success')): ?>
            Swal.fire({
                icon: 'success',
                text: "<?php echo e(session('success')); ?>"
            })
        <?php endif; ?>
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.frontend-layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/epeccomb/steelbazar.com/resources/views/user/home.blade.php ENDPATH**/ ?>