
<?php $__env->startSection('title','Sub Categories'); ?>
<?php $__env->startSection('category','active show-sub'); ?>
<?php $__env->startSection('all-subsubcategory','active'); ?>
<?php $__env->startSection('content'); ?>
<nav class="breadcrumb sl-breadcrumb">
  <a class="breadcrumb-item" href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a>
  <span class="breadcrumb-item active">Sub Category</span>
</nav>

<div class="sl-pagebody">
    <div class="row row-sm">
        <div class="col-md-8">
            <div class="card pd-10 pd-sm-20">
                <h6 class="card-body-title">All Sub Sub Categories</h6>
                <div class="table-wrapper">
                    <table class="table display responsive nowrap" id="brand-table">
                        <thead>
                            <tr>
                                <th>SI</th>
                                <th>Sub Sub Category</th>
                                <th>Position</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                                $start = 0;
                            ?>
                            <?php $__empty_1 = true; $__currentLoopData = $subSubCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subSubCategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>   
                                <tr>
                                    <td><?php echo e(++$start); ?></td>
                                    <td><?php echo e($subSubCategory?->subsubcategory_name_en); ?></td>
                                    <td><?php echo e($subSubCategory?->position); ?></td>
                                    <td>
                                        <a href="<?php echo e(route('admin.subSubCategory.edit',['id'=>$subSubCategory->id])); ?>" class="btn btn-primary" title="Edit Brand">Edit</a>
                                        <form action="<?php echo e(route('admin.subSubCategory.delete',['id'=>$subSubCategory->id])); ?>" method="GET" style="display: inline-block;" id="delete">
                                            <?php echo csrf_field(); ?>
                                            <button class="btn btn-danger">Delete</button>
                                        </form>
                                    </td>
                                </tr> 
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="5">No Data Found</td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card pd-10 pd-sm-20">
                <h6 class="card-body-title">Add New Sub Category</h6>
                <form action="<?php echo e(route('admin.subSubCategory.store')); ?>" class="form-layout" method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="form-group">
                        <label class="form-control-label">Parent Category: <span class="tx-danger">*</span></label>
                        <select class="form-control select2 select2-show-search" name="category_id" data-placeholder="Choose one" required>
                            <option label="Choose one"></option>
                            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($category->id); ?>" name="category_id" ><?php echo e($category->category_name_en); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <?php $__errorArgs = ['parent_category'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="text-danger"><?php echo e($message); ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="form-group">
                        <label class="form-control-label">Sub Category: <span class="tx-danger">*</span></label>
                        <select class="form-control select2 select2-show-search" name="subcategory_id" data-placeholder="Choose one" required>
                            <option label="Choose one"></option>

                        </select>
                        <?php $__errorArgs = ['parent_category'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="text-danger"><?php echo e($message); ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="form-group">
                        <label class="form-control-label">Sub Sub Category: <span class="tx-danger">*</span></label>
                        <input class="form-control" type="text" name="subsubcategory_name_en" value="<?php echo e(old('subsubcategory_name_en')); ?>" placeholder="Sub Sub Category" required>
                        <?php $__errorArgs = ['subsubcategory_name_en'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="text-danger"><?php echo e($message); ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="form-group">
                        <label class="form-control-label">Position: <span class="tx-danger">*</span></label>
                        <input class="form-control" type="text" name="position" value="<?php echo e(old('position')); ?>" placeholder="Enter Sub Sub Category Position" required>
                        <?php $__errorArgs = ['position'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="text-danger"><?php echo e($message); ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    
                    <div class="form-layout-footer">
                        <button class="btn btn-info mg-r-5">Save</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
<script src="<?php echo e(asset('assets/backend/js/axios.min.js')); ?>" type="text/javascript"></script>
    <script type="text/javascript">
        $(document).ready(function(){
            'use strict';

            $('.select2').select2({
            minimumResultsForSearch: Infinity
            });

            // Select2 by showing the search
            $('.select2-show-search').select2({
            minimumResultsForSearch: ''
            });

            // Select2 with tagging support
            $('.select2-tag').select2({
            tags: true,
            tokenSeparators: [',', ' ']
            });
            $('select[name="category_id"]').on('change',function(){
                let categoryId=$(this).val();
                if (categoryId) {
                    $.ajax({
                        url:"/admin/sub/sub-category/filter/"+categoryId,
                        type:"GET",
                        dataType:"json",
                        success:function(data){
                            let d=$('select[name="subcategory_id"]').empty();
                            $.each(data,function(key,value){
                                $('select[name="subcategory_id"]').append(
                                    '<option value="'+value.id+'">'+value.subcategory_name_en+'</option>'
                                );
                            })
                        },
                        error:function(){
                            console.log('No Data Found')
                        }
                    });
                }
            });
        });
        $('#brand-table').DataTable({
            responsive: true,
            language: {
            searchPlaceholder: 'Search...',
            sSearch: '',
            lengthMenu: '_MENU_ items/page',
            }
        });
        $(document).on('click','#delete',function(e){
                e.preventDefault();
                let link=$(this).attr('action');
                Swal.fire({
                    title:"Are your sure want to Delete This!",
                    text:'Once deleted, you will not be able to recover',
                    icon:'warning',
                    showDenyButton: true,
                    showCancelButton: true,
                    confirmButtonText: 'Delete',
                    denyButtonText: `Don't Delete`,
                }).then((willDelete)=>{
                    if (willDelete.isConfirmed) {
                        window.location.href=link;
                    }else{
                        Swal.fire('Your Category is safe','', 'info')
                    }
                })
            });
        <?php if(session()->has('success')): ?>
            Swal.fire({
                icon:'success',
                text:"<?php echo e(session('success')); ?>"
            })
        <?php endif; ?>
        <?php if(session()->has('error')): ?>
            Swal.fire({
                icon:'error',
                text:"<?php echo e(session('error')); ?>"
            })
        <?php endif; ?>
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin-layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/epeccomb/steelbazar.com/resources/views/admin/sub-sub-category/index.blade.php ENDPATH**/ ?>