
<?php $__env->startSection('title','All User'); ?>
<?php $__env->startSection('user','active'); ?>
<?php $__env->startSection('content'); ?>
<nav class="breadcrumb sl-breadcrumb">
  <a class="breadcrumb-item" href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a>
  <span class="breadcrumb-item active">All User</span>
</nav>

<div class="sl-pagebody">
    <div class="row row-sm">
        <div class="col-md-12">
            <div class="card pd-10 pd-sm-20">
                <h6 class="card-body-title">All User</h6>
                <div class="table-wrapper">
                    <table class="table display responsive nowrap" id="brand-table">
                        <thead>
                            <tr>
                                <th>SI</th>
                                <th>User Name</th>
                                <th>User Email</th>
                                <th>User Phone</th>
                                <th>Online</th>
                                <th>Status</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                                $start=0;
                            ?>
                            <?php $__empty_1 = true; $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e(++$start); ?></td>
                                    <td><?php echo e($user->name); ?></td>
                                    <td><?php echo e($user->email); ?></td>
                                    <td><?php echo e($user->phone); ?></td>
                                    <td>
                                        <?php if($user->userOnline()): ?>
                                            <span class="badge badge-success">
                                                Active
                                            </span>
                                        <?php else: ?>
                                            <span class="badge badge-danger">
                                                <?php echo e(Carbon\Carbon::parse($user->last_seen)->diffForHumans()); ?>

                                            </span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if($user->is_suspend===0): ?>
                                            <span class="badge badge-success">
                                                Unsuspend
                                            </span>
                                        <?php else: ?>
                                            <span class="badge badge-danger">
                                                Suspend
                                            </span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if($user->is_suspend===0): ?>
                                            <a href="<?php echo e(route('admin.user.suspend',['id'=>$user->id])); ?>" class="btn btn-danger" id="suspend" title="Suspend User"><i class="fa fa-arrow-down"></i></a>
                                        <?php else: ?>
                                            <a href="<?php echo e(route('admin.user.continue',['id'=>$user->id])); ?>" class="btn btn-success" id="unsuspend" title="Unsuspend User"><i class="fa fa-arrow-up"></i></a>
                                            <a href="<?php echo e(route('admin.user.destroy',['id'=>$user->id])); ?>"  title="Delete User" class="btn btn-danger" id="delete"><i class="fa fa-trash"></i></a>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
<script src="<?php echo e(asset('assets/backend/js/axios.min.js')); ?>" type="text/javascript"></script>
    <script type="text/javascript">
        
        $('#brand-table').DataTable({
            responsive: true,
            language: {
            searchPlaceholder: 'Search...',
            sSearch: '',
            lengthMenu: '_MENU_ items/page',
            }
        });
        $(document).on('click','#delete',function(e){
            e.preventDefault();
            let link=$(this).attr('href');
            Swal.fire({
                title:"Do you want Delete this user!!",
                text:'Once deleted, you will not be able to recover',
                icon:'warning',
                showDenyButton: true,
                showCancelButton: true,
                confirmButtonText: 'Delete',
                denyButtonText: `Don't Delete`,
            }).then((willDelete)=>{
                if (willDelete.isConfirmed) {
                    window.location.href=link;
                }else{
                    Swal.fire('This User is safe','', 'info')
                }
            })    
        });
        $(document).on('click','#suspend',function(e){
            e.preventDefault();
            let link=$(this).attr('href');
            Swal.fire({
                title:"Do you want Suspend this user!!",
                text:'Once suspend, you will be able to recover',
                icon:'warning',
                showDenyButton: true,
                showCancelButton: true,
                confirmButtonText: 'Suspend',
                denyButtonText: `Don't Suspend`,
            }).then((willDelete)=>{
                if (willDelete.isConfirmed) {
                    window.location.href=link;
                }else{
                    Swal.fire('This User is Unsuspend','', 'info')
                }
            })    
        });
        $(document).on('click','#unsuspend',function(e){
            e.preventDefault();
            let link=$(this).attr('href');
            Swal.fire({
                title:"Do you want Continue this user!!",
                text:'This User is suspended',
                icon:'warning',
                showDenyButton: true,
                showCancelButton: true,
                confirmButtonText: 'Continue',
                denyButtonText: `Don't Continue`,
            }).then((willDelete)=>{
                if (willDelete.isConfirmed) {
                    window.location.href=link;
                }else{
                    Swal.fire('This User is Suspend','', 'info')
                }
            })    
        });
        <?php if(session()->has('success')): ?>
            Swal.fire({
                icon:'success',
                text:"<?php echo e(session('success')); ?>"
            })
        <?php endif; ?>
        <?php if(session()->has('error')): ?>
            Swal.fire({
                icon:'error',
                text:"<?php echo e(session('error')); ?>"
            })
        <?php endif; ?>
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin-layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/epeccomb/steelbazar.com/resources/views/admin/user/index.blade.php ENDPATH**/ ?>