
<?php $__env->startSection('title', 'All Quotes'); ?>
<?php $__env->startSection('quote', 'active'); ?>
<?php $__env->startSection('content'); ?>
    <nav class="breadcrumb sl-breadcrumb">
        <a class="breadcrumb-item" href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a>
        <span class="breadcrumb-item active">Quotes</span>
    </nav>

    <div class="sl-pagebody">
        <div class="row row-sm">
            <div class="col-12">
                <div class="card pd-10 pd-sm-20">
                    <h6 class="card-body-title">All Quote</h6>
                    <div class="table-wrapper">
                        <table class="table display responsive nowrap" id="brand-table">
                            <thead>
                                <tr>
                                    <th>SI</th>
                                    <th>Name</th>
                                    <th>Phone Number</th>
                                    <th>Product Name</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                    $start = 0;
                                ?>
                                <?php $__empty_1 = true; $__currentLoopData = $quotes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $quote): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td><?php echo e(++$start); ?></td>
                                        <td><?php echo e($quote->name); ?></td>
                                        <td><?php echo e($quote->phone); ?></td>
                                        <td><?php echo e($quote->product->product_name_en); ?></td>

                                        <td>
                                            <a href="<?php echo e(route('admin.quote.show', $quote->id)); ?>" class="btn btn-success"
                                                title="Edit Brand">View</a>
                                            <a href="<?php echo e(route('admin.shipping.cost.edit', $quote->id)); ?>"
                                                class="btn btn-primary" title="Edit Brand">Edit</a>
                                            <a href="<?php echo e(route('admin.quote.invoice', $quote->id)); ?>" class="btn btn-warning"
                                                id="invoice" title="Invoice">Invoice</a>
                                            <a href="<?php echo e(route('admin.quote.destroy', $quote->id)); ?>" class="btn btn-danger"
                                                id="delete" title="Delete Brand">Delete</a>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <script type="text/javascript">
        $('#brand-table').DataTable({
            responsive: true,
            language: {
                searchPlaceholder: 'Search...',
                sSearch: '',
                lengthMenu: '_MENU_ items/page',
            }
        });
        $(document).on('click', '#delete', function(e) {
            e.preventDefault();
            let link = $(this).attr('href');
            Swal.fire({
                title: "Are your sure want to Delete !",
                text: 'Once deleted, you will not be able to recover',
                icon: 'warning',
                showDenyButton: true,
                showCancelButton: true,
                confirmButtonText: 'Delete',
                denyButtonText: `Don't Delete`,
            }).then((willDelete) => {
                if (willDelete.isConfirmed) {
                    window.location.href = link;
                } else {
                    Swal.fire('Quote is safe', '', 'info')
                }
            })
        });
        <?php if(session()->has('success')): ?>
            Swal.fire({
                icon: 'success',
                text: "<?php echo e(session('success')); ?>"
            })
        <?php endif; ?>
        <?php if(session()->has('error')): ?>
            Swal.fire({
                icon: 'error',
                text: "<?php echo e(session('error')); ?>"
            })
        <?php endif; ?>
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin-layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/steellbaazaar/public_html/resources/views/admin/quote/index.blade.php ENDPATH**/ ?>