
<?php $__env->startSection('title', 'Shipping Costs'); ?>
<?php $__env->startSection('cost', 'active'); ?>
<?php $__env->startSection('content'); ?>
    <nav class="breadcrumb sl-breadcrumb">
        <a class="breadcrumb-item" href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a>
        <span class="breadcrumb-item active">Shipping Cost</span>
    </nav>

    <div class="sl-pagebody">
        <div class="row row-sm">
            <div class="col-md-8">
                <div class="card pd-10 pd-sm-20">
                    <h6 class="card-body-title">Shipping Costs</h6>
                    <div class="table-wrapper">
                        <table class="table display responsive nowrap" id="brand-table">
                            <thead>
                                <tr>
                                    <th>SI</th>
                                    <th>Area Name</th>
                                    <th>Cost(TK)</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                    $start = 0;
                                ?>
                                <?php $__empty_1 = true; $__currentLoopData = $shippingAreas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $shippingArea): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td><?php echo e(++$start); ?></td>
                                        <td><?php echo e($shippingArea->area_name); ?></td>
                                        <td><?php echo e($shippingArea->cost); ?></td>

                                        <td>
                                            <a href="<?php echo e(route('admin.shipping.cost.edit', $shippingArea->id)); ?>"
                                                class="btn btn-primary" title="Edit Brand">Edit</a>
                                            <a href="<?php echo e(route('admin.shipping.cost.delete', $shippingArea->id)); ?>"
                                                class="btn btn-danger" id="delete" title="Delete Brand">Delete</a>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="card pd-10 pd-sm-20">
                    <h6 class="card-body-title">Add New Shipping Area</h6>
                    <form action="<?php echo e(route('admin.shipping.cost.store')); ?>" class="form-layout" method="POST">
                        <?php echo csrf_field(); ?>
                        <div class="form-group">
                            <label class="form-control-label">Area Name: <span class="tx-danger">*</span></label>
                            <input class="form-control" type="text" name="area_name" value="<?php echo e(old('area_name')); ?>"
                                placeholder="Enter Area Name" required>
                            <?php $__errorArgs = ['area_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="text-danger"><?php echo e($message); ?></span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="form-group">
                            <label class="form-control-label">Shipping Cost: <span class="tx-danger">*</span></label>
                            <input class="form-control" type="number" name="cost" value="<?php echo e(old('cost')); ?>"
                                placeholder="Enter Shipping Cost" required>
                            <?php $__errorArgs = ['cost'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="text-danger"><?php echo e($message); ?></span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="form-layout-footer">
                            <button class="btn btn-info mg-r-5">Save</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <script type="text/javascript">
        $('#brand-table').DataTable({
            responsive: true,
            language: {
                searchPlaceholder: 'Search...',
                sSearch: '',
                lengthMenu: '_MENU_ items/page',
            }
        });
        $(document).on('click', '#delete', function(e) {
            e.preventDefault();
            let link = $(this).attr('href');
            Swal.fire({
                title: "Are your sure want to Delete !",
                text: 'Once deleted, you will not be able to recover',
                icon: 'warning',
                showDenyButton: true,
                showCancelButton: true,
                confirmButtonText: 'Delete',
                denyButtonText: `Don't Delete`,
            }).then((willDelete) => {
                if (willDelete.isConfirmed) {
                    window.location.href = link;
                } else {
                    Swal.fire('Your Brand is safe', '', 'info')
                }
            })
        });
        <?php if(session()->has('success')): ?>
            Swal.fire({
                icon: 'success',
                text: "<?php echo e(session('success')); ?>"
            })
        <?php endif; ?>
        <?php if(session()->has('error')): ?>
            Swal.fire({
                icon: 'error',
                text: "<?php echo e(session('error')); ?>"
            })
        <?php endif; ?>
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin-layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/epeccomb/steelbazar.com/resources/views/admin/shipping-cost/index.blade.php ENDPATH**/ ?>