
<?php $__env->startSection('title','Slider'); ?>
<?php $__env->startSection('slider','active show-sub'); ?>
<?php $__env->startSection('all-slides','active'); ?>
<?php $__env->startSection('content'); ?>
<nav class="breadcrumb sl-breadcrumb">
  <a class="breadcrumb-item" href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a>
  <span class="breadcrumb-item active">Slider</span>
</nav>

<div class="sl-pagebody slider-page">
    <div class="row row-sm">
        <div class="col-md-12">
            <div class="card pd-10 pd-sm-20">
                <h6 class="card-body-title">All Slides</h6>
                <div class="table-wrapper">
                    <table class="table display responsive" id="slider-table">
                        <thead>
                            <tr>
                                <th class="wd-5p">SI</th>
                                <th class="wd-15p">Title</th>
                                <th class="wd-15p">Sub Title</th>
                                <th class="wd-20p">Image</th>
                                <th class="wd-20p">Description</th>
                                <th class="wd-5p">Status</th>
                                <th class="wd-15p">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                                $start = 0;
                            ?>
                            <?php $__empty_1 = true; $__currentLoopData = $slides; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $slide): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>   
                                <tr>
                                    <td class="wd-5p"><?php echo e(++$start); ?></td>
                                    <td class="wd-15p"><?php echo e($slide->title_en); ?></td>
                                    <td class="wd-15p"><?php echo e($slide->sub_title_en); ?></td>
                                    <td class="wd-15p">
                                        <div class="brand-image">
                                            <img src="<?php echo e(asset($slide->image)); ?>" style="width: 100%;" alt="<?php echo e($slide->title_en); ?>">
                                        </div>
                                    </td>
                                    <td class="wd-20p"><?php echo e($slide->description_en); ?></td>
                                    <td class="wd-5p">
                                        <?php if($slide->status==1): ?>
                                            <span class="badge badge-success">Active</span>
                                        <?php else: ?>
                                            <span class="badge badge-danger">Inactive</span>
                                        <?php endif; ?>
                                    </td>
                                    <td class="wd-20p">
                                        <a href="<?php echo e(route('slider.edit',$slide->id)); ?>" class="btn btn-success" title="Slider Edit"><i class="fa fa-edit"></i></a>
                                        <form action="<?php echo e(route('slider.delete',$slide->id)); ?>" method="POST" id="delete-form">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('delete'); ?>
                                            <button type="submit" class="btn btn-danger" title="Slider Delete"><i class="fa fa-trash"></i></button>
                                        </form>
                                        <?php if($slide->status==1): ?>
                                            <a href="<?php echo e(route('slider.inactive',['id'=>$slide->id])); ?>" class="btn btn-danger" title="Slider Inactive"><i class="fa fa-arrow-down"></i></a>
                                        <?php else: ?>
                                        <a href="<?php echo e(route('slider.active',['id'=>$slide->id])); ?>" class="btn btn-success" title="Slider Active"><i class="fa fa-arrow-up"></i></a>
                                        <?php endif; ?>
                                    </td>
                                </tr> 
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="6">No Data Found</td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <script type="text/javascript">
        $('#slider-table').DataTable({
            responsive: true,
            language: {
            searchPlaceholder: 'Search...',
            sSearch: '',
            lengthMenu: '_MENU_ items/page',
            }
        });
        $(document).on('click','#delete-form',function(e){
            e.preventDefault();
            let link=$(this).attr('action');
            Swal.fire({
                title:"Are your sure want to Delete !",
                text:'Once deleted, you will not be able to recover',
                icon:'warning',
                showDenyButton: true,
                showCancelButton: true,
                confirmButtonText: 'Delete',
                denyButtonText: `Don't Delete`,
            }).then((willDelete)=>{
                if (willDelete.isConfirmed) {
                    window.location.href=link;
                }else{
                    Swal.fire('This Slide is safe','', 'info')
                }
            })
        });
        <?php if(session()->has('success')): ?>
            Swal.fire({
                icon:'success',
                text:"<?php echo e(session('success')); ?>"
            })
        <?php endif; ?>
        <?php if(session()->has('error')): ?>
            Swal.fire({
                icon:'error',
                text:"<?php echo e(session('error')); ?>"
            })
        <?php endif; ?>
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin-layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/epeccomb/steelbazar.com/resources/views/admin/slider/index.blade.php ENDPATH**/ ?>