
<?php $__env->startSection('title', 'Deals'); ?>
<?php $__env->startSection('deal', 'active'); ?>
<?php $__env->startSection('content'); ?>
    <nav class="breadcrumb sl-breadcrumb">
        <a class="breadcrumb-item" href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a>
        <span class="breadcrumb-item active">Deals</span>
    </nav>

    <div class="sl-pagebody">
        <div class="row row-sm">
            <div class="col-md-12">
                <div class="card pd-10 pd-sm-20">
                    <div class="row mb-2">
                        <div class="col-md-6">
                            <h6 class="card-body-title">All Deal</h6>
                        </div>
                        <div class="col-md-6 text-right">
                            <a href="<?php echo e(route('admin.deal.create')); ?>" class="btn btn-primary">Add New</a>
                        </div>
                    </div>
                    <div class="table-wrapper">
                        <table class="table display responsive nowrap" id="brand-table">
                            <thead>
                                <tr>
                                    <th class="wd-10p">SI</th>
                                    <th class="wd-15p">Deal Name</th>
                                    <th class="wd-15p">Start Date</th>
                                    <th class="wd-15p">End Date</th>
                                    <th class="wd-15p">Expiration</th>
                                    <th class="wd-10p">Status</th>
                                    <th class="wd-40p">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                    $start = 0;
                                ?>
                                <?php $__empty_1 = true; $__currentLoopData = $deals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $deal): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td><?php echo e(++$start); ?></td>
                                        <td><?php echo e($deal->deal_name); ?></td>
                                        <td>
                                            <?php echo e(Carbon\Carbon::parse($deal->start_date)->format('D d-m-Y')); ?>

                                        </td>
                                        <td>
                                            <?php echo e(Carbon\Carbon::parse($deal->end_date)->format('D d-m-Y')); ?>

                                        </td>
                                        <td>
                                            <?php if(Carbon\Carbon::parse($deal->end_date) > Carbon\Carbon::now()): ?>
                                                <span class="badge badge-primary">Not Expired</span>
                                            <?php else: ?>
                                                <span class="badge badge-primary">Expired</span>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <?php if($deal->status == 'active'): ?>
                                                <span class="badge badge-success">Active</span>
                                            <?php else: ?>
                                                <span class="badge badge-danger">Deactive</span>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <a href="<?php echo e(route('admin.deal.edit', $deal->id)); ?>" class="btn btn-primary"
                                                title="Edit DEAL">Edit</a>
                                            <a href="<?php echo e(route('admin.deal.delete', $deal->id)); ?>" class="btn btn-danger"
                                                id="delete" title="Delete Deal">Delete</a>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="6">No Data Found</td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <script type="text/javascript">
        $('#brand-table').DataTable({
            responsive: true,
            language: {
                searchPlaceholder: 'Search...',
                sSearch: '',
                lengthMenu: '_MENU_ items/page',
            }
        });
        $(document).on('click', '#delete', function(e) {
            e.preventDefault();
            let link = $(this).attr('href');
            Swal.fire({
                title: "Are your sure want to Delete !",
                text: 'Once deleted, you will not be able to recover',
                icon: 'warning',
                showDenyButton: true,
                showCancelButton: true,
                confirmButtonText: 'Delete',
                denyButtonText: `Don't Delete`,
            }).then((willDelete) => {
                if (willDelete.isConfirmed) {
                    window.location.href = link;
                } else {
                    Swal.fire('Your Deal is safe', '', 'info')
                }
            })
        });
        <?php if(session()->has('success')): ?>
            Swal.fire({
                icon: 'success',
                text: "<?php echo e(session('success')); ?>"
            })
        <?php endif; ?>
        <?php if(session()->has('error')): ?>
            Swal.fire({
                icon: 'error',
                text: "<?php echo e(session('error')); ?>"
            })
        <?php endif; ?>
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin-layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/epeccomb/steelbazar.com/resources/views/admin/deal/index.blade.php ENDPATH**/ ?>