
<?php $__env->startSection('title','Admin'); ?>
<?php $__env->startSection('admins','active show-sub'); ?>
<?php $__env->startSection('all-admins','active'); ?>
<?php $__env->startSection('content'); ?>
<nav class="breadcrumb sl-breadcrumb">
  <a class="breadcrumb-item" href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a>
  <span class="breadcrumb-item active">Admin</span>
</nav>

<div class="sl-pagebody slider-page">
    <div class="row row-sm">
        <div class="col-md-12">
            <div class="card pd-10 pd-sm-20">
                <h6 class="card-body-title">All Admins</h6>
                <div class="table-wrapper">
                    <table class="table display responsive" id="role-table">
                        <thead>
                            <tr>
                                <th class="wd-5p">SI</th>
                                <th class="wd-20p">Name</th>
                                <th class="wd-20p">Email</th>
                                <th class="wd-20p">Phone</th>
                                <th class="wd-20p">Role</th>
                                <th class="wd-15p">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                                $start = 0;
                            ?>
                            <?php $__empty_1 = true; $__currentLoopData = $admins; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $admin): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>   
                                <tr>
                                    <td class="wd-5p"><?php echo e(++$start); ?></td>
                                    <td class="wd-20p"><?php echo e($admin->name); ?></td>
                                    <td class="wd-20p"><?php echo e($admin->email); ?></td>
                                    <td class="wd-20p"><?php echo e($admin->phone); ?></td>
                                    <td class="wd-20p"><?php echo e($admin->adminRole->name); ?></td>
                                    
                                    <td class="wd-15p">
                                        
                                        <a href="<?php echo e(route('admins.edit',$admin->id)); ?>" class="btn btn-success" title="Role Edit"><i class="fa fa-edit"></i></a>
                                        <form action="<?php echo e(route('admins.delete',$admin->id)); ?>" method="POST" id="delete-form">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('get'); ?>
                                            <button type="submit" class="btn btn-danger" title="Role Delete"><i class="fa fa-trash"></i></button>
                                        </form>
                                            
                                        
                                        
                                    </td>
                                </tr> 
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="6">No Data Found</td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <script type="text/javascript">
        $('#role-table').DataTable({
            responsive: true,
            language: {
            searchPlaceholder: 'Search...',
            sSearch: '',
            lengthMenu: '_MENU_ items/page',
            }
        });
        $(document).on('click','#delete-form',function(e){
            e.preventDefault();
            let link=$(this).attr('action');
            Swal.fire({
                title:"Are your sure want to Delete !",
                text:'Once deleted, you will not be able to recover',
                icon:'warning',
                showDenyButton: true,
                showCancelButton: true,
                confirmButtonText: 'Delete',
                denyButtonText: `Don't Delete`,
            }).then((willDelete)=>{
                if (willDelete.isConfirmed) {
                    window.location.href=link;
                }else{
                    Swal.fire('This Role is safe','', 'info')
                }
            })
        });
        <?php if(session()->has('success')): ?>
            Swal.fire({
                icon:'success',
                text:"<?php echo e(session('success')); ?>"
            })
        <?php endif; ?>
        <?php if(session()->has('error')): ?>
            Swal.fire({
                icon:'error',
                text:"<?php echo e(session('error')); ?>"
            })
        <?php endif; ?>
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin-layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/steellbaazaar/public_html/resources/views/admin/admin/index.blade.php ENDPATH**/ ?>