
<?php $__env->startSection('title', 'Checkout Page'); ?>
<?php $__env->startSection('content'); ?>

    <div class="breadcrumb">
        <div class="container">
            <div class="breadcrumb-inner">
                <ul class="list-inline list-unstyled">
                    <li><a href="<?php echo e(url('/')); ?>">Home</a></li>
                    <li class='active'>Checkout</li>
                </ul>
            </div><!-- /.breadcrumb-inner -->
        </div><!-- /.container -->
    </div><!-- /.breadcrumb -->

    <div class="body-content">
        <div class="container">
            <div class="checkout-box">
                <form class="register-form" action="<?php echo e(route('buy.shipping.store')); ?>" role="form" method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="row">
                        <div class="col-md-8">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="shipping-area">
                                        <h4 class="checkout-subtitle">Shipping Area</h4>
                                        <?php if($errors->any()): ?>
                                            <div class="alert alert-danger">
                                                <ul>
                                                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <li><?php echo e($error); ?></li>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </ul>
                                            </div>
                                        <?php endif; ?>
                                        <?php if($shippingAddress): ?>
                                            <div class="row">
                                                <?php $__currentLoopData = $shippingAddress; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $address): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <div class="col-md-6 col-sm-6">
                                                        <div>

                                                            <label for="address-<?php echo e($address->id); ?>" class="address-item">
                                                                <input type="radio" name="address_id"
                                                                    id="address-<?php echo e($address->id); ?>" class="address-input"
                                                                    value="<?php echo e($address->id); ?>">
                                                                <span><?php echo e($address->name); ?>,
                                                                    <?php echo e($address->address_1); ?></span>

                                                            </label>
                                                        </div>
                                                    </div>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <div class="col-md-6 col-sm-6">
                                                    <div class="address-item add-address">

                                                        <h5> <i class="fa fa-plus"></i> Add New Shipping Address</h5>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endif; ?>
                                        <div class="new-shipping-address <?php echo e($shippingAddress ? 'd-none' : ''); ?>">
                                            <div class="row">
                                                <div class="col-md-6 col-12">
                                                    <div class="form-group">
                                                        <label class="info-title" for="name">Name
                                                            <span class="text-danger">*</span></label>
                                                        <input type="text"
                                                            class="form-control unicase-form-control text-input"
                                                            name="name" id="name" value="<?php echo e(old('name')); ?>"
                                                            placeholder="Enter Your Full Name">
                                                    </div>

                                                </div>
                                                <div class="col-md-6 col-12">
                                                    <div class="form-group">
                                                        <label class="info-title" for="phone">Select Division
                                                            <span class="text-danger">*</span></label>
                                                        <select name="division_id"
                                                            class="form-control select2 select2-show-search unicase-form-control"
                                                            id="division"  value="<?php echo e(old('division_id')); ?>">
                                                            <option value="">Choose One Division</option>
                                                        </select>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-md-6 col-12">
                                                    <div class="form-group">
                                                        <label class="info-title" for="email">Email Address
                                                            <span class="text-danger">*</span>
                                                        </label>
                                                        <input type="email" name="email"
                                                            class="form-control unicase-form-control text-input"  value="<?php echo e(old('email')); ?>"
                                                            id="email" placeholder="Enter Email Address">
                                                    </div>

                                                </div>
                                                <div class="col-md-6 col-12">

                                                    <div class="form-group">
                                                        <label class="info-title" for="phone">Select District
                                                            <span class="text-danger">*</span></label>
                                                        <select name="district_id"
                                                            class="form-control select2 select2-show-search unicase-form-control"
                                                            id="district"  value="<?php echo e(old('district_id')); ?>">
                                                        </select>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-md-6 col-12">
                                                    <div class="form-group">
                                                        <label class="info-title" for="phone">Phone Number
                                                            <span class="text-danger">*</span>
                                                        </label>
                                                        <input type="text" name="phone" value="<?php echo e(old('phone')); ?>"
                                                            class="form-control unicase-form-control text-input"
                                                            id="phone" placeholder="Enter Your Phone Number">
                                                    </div>

                                                </div>

                                                <div class="col-md-6 col-12">
                                                    <div class="form-group">
                                                        <label class="info-title" for="phone">Select Thana
                                                            <span class="text-danger">*</span></label>
                                                        <select name="state_id"  value="<?php echo e(old('state_id')); ?>"
                                                            class="form-control select2 select2-show-search unicase-form-control"
                                                            id="state">
                                                        </select>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-md-6 col-12">
                                                    <div class="form-group">
                                                        <label class="info-title" for="address1">Address 1
                                                            (House/Road/Holding)
                                                            <span class="text-danger">*</span></label>
                                                        <input type="text"  value="<?php echo e(old('address1')); ?>"
                                                            class="form-control unicase-form-control text-input"
                                                            name="address1" id="address1"
                                                            placeholder="Enter Your Address 1">
                                                    </div>

                                                </div>
                                                <div class="col-md-6 col-12">
                                                    <div class="form-group">
                                                        <label class="info-title" for="post-code">Post Code
                                                           
                                                        </label>
                                                        <input type="text" value="<?php echo e(old('post_code')); ?>"
                                                            class="form-control unicase-form-control text-input"
                                                            name="post_code" id="post-code"
                                                            placeholder="Enter Your Post Code">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-md-6 col-12">
                                                    <div class="form-group">
                                                        <label class="info-title" for="address2">Address 2
                                                            (House/Road/Holding)
                                                        </label>
                                                        <input type="text" value="<?php echo e(old('address2')); ?>"
                                                            class="form-control unicase-form-control text-input"
                                                            name="address2" id="address2"
                                                            placeholder="Enter Your Address 2">
                                                    </div>
                                                </div>
                                                <div class="col-md-6 col-12">

                                                    <!--<div class="form-group">-->
                                                    <!--    <label class="info-title" for="phone">Shipping Cost-->
                                                    <!--        <span class="text-danger">*</span></label>-->
                                                    <!--    <select name="shipping_cost"-->
                                                    <!--        class="form-control unicase-form-control" id="shipping-cost">-->
                                                    <!--        <option value="">Select Shipping Cost</option>-->
                                                    <!--        <?php $__currentLoopData = $costs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cost): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>-->
                                                    <!--            <option value="<?php echo e($cost->cost); ?>">-->
                                                    <!--                <?php echo e($cost->area_name); ?>-<?php echo e($cost->cost); ?></option>-->
                                                    <!--        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>-->

                                                    <!--    </select>-->
                                                    <!--</div>-->
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-md-12">
                                                    <div class="form-group">
                                                        <label for="phone">Notes </label>
                                                        <textarea name="notes" id="phone" class="form-control unicase-form-control"></textarea>
                                                    </div>
                                                    <div class="form-group">
                                                        <label for="save-address">
                                                            <input type="checkbox" name="save_address" id="save-address" value="<?php echo e(old('save_address')); ?>">
                                                            Save This Address
                                                        </label>
                                                    </div>


                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-12" style="margin-top:40px">
                                                <div class="shopping-cart-table ">
                                                    <div class="table-responsive">
                                                        <table class="table">
                                                            <thead>
                                                                <tr>
                                                                    <th class="cart-product-name item">Product Name</th>
                                                                    <th class="cart-description item text-center" >Image</th>
                                                                    <th class="cart-qty item text-center">Quantity</th>
                                                                    <th class="cart-sub-total item text-center">Price</th>
                                                                    <th class="cart-total last-item text-center">Subtotal</th>
                                                                </tr>
                                                            </thead><!-- /thead -->
                                                            
                                                            <tbody class="buy-item">
                                                                <tr>
                                                                    <td class="cart-product-name-info">
                                                                        <h4 class="cart-product-description"><a
                                                                                href="detail.html"><?php echo e($product->product_name_en); ?></a></h4>
                                                                        <div class="cart-product-info">
                                                                            <span class="product-color">COLOR:
                                                                                <span style="text-transform:capitalize"><?php echo e($color); ?>

                                                                                </span>
                                                                            </span>
                                                                        </div>
                                                                    </td>
                                                                    <td class="cart-image">
                                                                        <a class="entry-thumbnail" href="">
                                                                            <img src="<?php echo e(asset($product->product_thumbnail)); ?>" style="width: 100px" alt="<?php echo e($product->product_name_en); ?>">
                                                                        </a>
                                                                    </td>
                            
                                                                    <td class="cart-product-quantity">
                                                                        <div stye="display:flex;">
                                                                            <?php echo e($qty); ?>

                                                                        </div>
                                                                    </td>
                                                                    <td class="cart-product-sub-total"><span class="cart-sub-total-price">৳
                                                                            <?php echo e($price); ?></span>
                                                                    </td>
                                                                    <td class="cart-product-grand-total">
                                                                        <span class="cart-grand-total-price">
                                                                            ৳<?php echo e($price * $qty); ?></span>
                                                                    </td>
                                                                </tr>
                                                            </tbody><!-- /tbody -->
                                                        </table><!-- /table -->
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-12">
                                                <div class="form-group" style="padding: 0 15px;">
                                                    <button type="submit" class="btn btn-success">Proceed To
                                                        Checkout</button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="row">

                                <div class="col-md-12">
                                    <!-- checkout-progress-sidebar -->
                                    <div class="checkout-progress-sidebar ">
                                        <div class="panel-group">
                                            <div class="panel panel-default">
                                                <div class="panel-heading">
                                                    <h4 class="unicase-checkout-title">Choose Your Payment Method</h4>
                                                </div>
                                                <div class="payment-methods">
                                                    <ul>
                                                        <li>
                                                            <input type="radio" name="payment_method" id="stripe" value="stripe" disabled>
                                                            <label for="stripe"><img src="<?php echo e(asset('assets/frontend/images/checkout/stripe.png')); ?>" class="img-100" /></label>
                                                        </li>

                                                        <li>
                                                            <input type="radio" name="payment_method" id="amaarpay-image" value="amaarpay" class="" disabled>
                                                            <label for="amaarpay-image"><img src="<?php echo e(asset('assets/frontend/images/checkout/bkash-rocket-nagad.jpeg')); ?>" class="img-100" /></label>
                                                        </li>
                                                        <li>
                                                            <input type="radio" name="payment_method" id="sslcommerz-hosted" value="amaarpay" disabled>
                                                            <label for="sslcommerz-hosted"><img src="<?php echo e(asset('assets/frontend/images/checkout/visa-mastercard.jpeg')); ?>" class="img-100" /></label>
                                                        </li>
                                                        <li>
                                                            <input type="radio" name="payment_method" id="cod" checked value="cod">
                                                            <label for="cod"><img src="<?php echo e(asset('assets/frontend/images/checkout/cash-on-delivery.jpeg')); ?>" class="img-100" /></label>
                                                        </li>
                                                    </ul>
                                                </div>
                                            </div>
                                        </div>
                                    </div><!-- checkout-progress-sidebar -->
                                </div>
                                <div class="col-md-12">
                                    <!-- checkout-progress-sidebar -->
                                    <div class="checkout-progress-sidebar ">
                                        <div class="panel-group">
                                            <div class="panel panel-default">
                                                <div class="panel-heading">
                                                    <h4 class="unicase-checkout-title">Your Checkout Progress</h4>
                                                </div>
                                                
                                                <div class="">
                                                    <?php if(session()->has('coupon')): ?>
                                                        <div class="cart-sub-total" style="font-size: 18px">
                                                            Subtotal<span
                                                                class="inner-left-md">৳<?php echo e($price * $qty); ?></span>
                                                        </div>
                                                        <div class="cart-grand-total" style="font-size: 20px">
                                                            Total:
                                                            <span class="inner-left-md" style="color:rgb(6, 168, 6);"
                                                                id="grand-total">৳<?php echo e($price * $qty); ?></span>
                                                        </div>
                                                    <?php else: ?>
                                                        <div class="cart-grand-total" style="font-size: 20px">
                                                            Total:<span class="inner-left-md"
                                                                style="color:rgb(6, 168, 6);"
                                                                id="grand-total">৳<?php echo e($price * $qty); ?></span>
                                                        </div>
                                                    <?php endif; ?>


                                                    <input type="hidden" id="total-amount" value="<?php echo e($total); ?>">
                                                </div>
                                            </div>
                                        </div>
                                    </div><!-- checkout-progress-sidebar -->
                                </div>
                            </div>
                        </div>
                    </div><!-- /.row -->
                </form>
            </div><!-- /.checkout-box -->

        </div><!-- /.container -->
    </div><!-- /.body-content -->

<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <script type="text/javascript">
        $(".add-address").on("click", function() {
            $(".new-shipping-address").slideToggle();
            $(".address-input").removeAttr('checked');
        });
        $(".address-input").on("click", function() {
            $(".new-shipping-address").removeAttr('style');
        });

        function getAllDivision() {
            axios.get("<?php echo e(url('/user/checkout/division')); ?>")
                .then(function(response) {
                    if (response.status === 200) {
                        $.each(response.data.divisions, function(id, division) {
                            $('#division').append(
                                '<option value="' + division.id + '">' + division.name + '</option>'
                            )
                        })
                    }
                })
                .catch(function(error) {
                    console.log(error);
                })
        }
        getAllDivision();
        $('#division').on('change', function() {
            let divisionId = $('#division').val();
            axios.get("<?php echo e(url('/user/checkout/district')); ?>/" + divisionId)
                .then(function(response) {
                    console.log(response.data.districts);
                    if (response.status === 200) {
                        $('#district').empty();
                        $('#district').append(
                            '<option value="">Choose One</option>'
                        )
                        $.each(response.data.districts, function(id, district) {
                            $('#district').append(
                                '<option value="' + district.id + '">' + district.name + '</option>'
                            )
                        })
                    }
                })
                .catch(function(error) {
                    console.log(error);
                })
        })
        $('#district').on('change', function() {
            let districtId = $('#district').val();
            axios.get("<?php echo e(url('/user/checkout/state')); ?>/" + districtId)
                .then(function(response) {
                    if (response.status === 200) {
                        $('#state').empty();
                        $('#state').append(
                            '<option value="">Choose One</option>'
                        )
                        $.each(response.data.states, function(id, state) {
                            $('#state').append(
                                '<option value="' + state.id + '">' + state.name + '</option>'
                            )
                        })
                    }
                })
                .catch(function(error) {
                    console.log(error);
                })
        })
        $('#shipping-cost').on('change', function() {
            if ($('#shipping-cost').val() == '') {
                let totalAmount = $('#total-amount').val();
                $('#grand-total').html("৳ " + totalAmount);
            } else {
                let shippingCost = $('#shipping-cost').val();
                let totalAmount = $('#total-amount').val();
                let grandTotal = parseInt(shippingCost) + parseInt(totalAmount);
                $('#grand-total').html("৳ " + grandTotal);
            }
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.frontend-layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/epeccomb/steelbazar.com/resources/views/user/buy/checkout.blade.php ENDPATH**/ ?>