
<?php $__env->startSection('title','Edit Product Images'); ?>
<?php $__env->startSection('product','active show-sub'); ?>
<?php $__env->startSection('add-new','active'); ?>
<?php $__env->startSection('content'); ?>
<nav class="breadcrumb sl-breadcrumb">
  <a class="breadcrumb-item" href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a>
  <a class="breadcrumb-item" href="<?php echo e(route('products.all')); ?>"><?php echo e(__('Products')); ?></a>
  <span class="breadcrumb-item active">Edit Image</span>
</nav>

<div class="sl-pagebody product-image-edit">
    <div class="row row-sm">
        <div class="col-md-12">
            <div class="card pd-10 pd-sm-20">
                <h6 class="card-body-title">Edit Product Images</h6>
                <form action="<?php echo e(route('product.thumbnail.update',['id'=>$product->id])); ?>" method="POST" class="form-layout" enctype="multipart/form-data">
                    <div class="row">
                        <?php echo method_field('PATCH'); ?>
                        <?php echo csrf_field(); ?>
                        <div class="col-md-4 thumbnail mt-2">
                            <h6>Old Product Thumbnail</h6>
                            <div class="image">
                                <div class="image-size">
                                    <span class="badge badge-success"><?php echo e(intval($product->thumbnail_size)/1024); ?> KB</span>
                                </div>
                                <img style="width: 100%;" src="<?php echo e(asset($product->product_thumbnail)); ?>">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label class="form-control-label">Product Thumbnail(1*1)<span class="tx-danger">*</span></label>
                                <input class="form-control" type="file" name="product_thumbnail" accept="image/*" onchange="loadFile(event)">
                                <?php $__errorArgs = ['product_thumbnail'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="text-danger"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <img style="width:80%;" id="thumbnail-preview"/>
                            <div class="form-layout-footer col-12">
                                <button class="btn btn-info text-center" type="submit">Update Thumbnail</button>
                            </div>
                        </div>
                        <div class="col-md-4">
                        </div>
                        
                    </div>
                </form>
                
                <h6 class="mt-5">Old Product Images</h6>
                <?php $__errorArgs = ['product_image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <span class="text-danger"><?php echo e($message); ?></span>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                <div class="row">
                        
                    <?php $__currentLoopData = $productImages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $productImage): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            
                        <div class="col-md-4">
                            <form action="<?php echo e(route('product.update.image',$productImage->id)); ?>" method="POST" class="form-layout" enctype="multipart/form-data">
                                <?php echo method_field('PATCH'); ?>
                                <?php echo csrf_field(); ?>
                        
                                <div class="image">
                                    <div class="image-size">
                                        <span class="badge badge-success"><?php echo e(intval($productImage->product_image_size)/1024); ?> KB</span>
                                    </div>
                                    <img style="width:80%;" class="d-block" src="<?php echo e(asset($productImage->product_image_name)); ?>">
                                </div>
                                
                                
                                <a href="<?php echo e(route('product.image.delete',['id'=>$productImage->id])); ?>" class="btn btn-danger" id="delete"><i class="fa fa-trash"></i></a>
                                <div class="form-group">
                                    <label class="form-control-label mt-3">Product Image<span class="tx-danger">*</span></label>
                                    <input class="form-control" type="file" name="product_image" id="multiple-image" multiple>
                                    
                                </div>
                                <div class="form-layout-footer col-12">
                                    <button class="btn btn-info text-center">Update Images</button>
                                </div>
                                
                            </form>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                
                </div>       
                <form action="<?php echo e(route('product.images.store',['id'=>$product->id])); ?>" method="POST" enctype="multipart/form-data" class="mt-5">
                    <?php echo csrf_field(); ?>
                    <div class="col-md-12">
                        <div class="form-group">
                            <label class="form-control-label">Add Product Images <span class="tx-danger">*</span></label>
                            
                            <input class="form-control multiple-image" type="file" name="product_multiple_image[]" value="<?php echo e(old('product_multiple_image')); ?>" id="multiple-image" multiple>
                            <?php $__errorArgs = ['product_multiple_image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="text-danger"><?php echo e($message); ?></span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="preview-all" id="preview-all"></div>
                    </div>
                    
                    <div class="form-layout-footer col-12">
                        <button class="btn btn-info text-center">Upload Images</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
<script type="text/javascript">

    //Product Thumbnail Preview
    var loadFile = function(event) {
    var reader = new FileReader();
        reader.onload = function(){
            var output = document.getElementById('thumbnail-preview');
            output.src = reader.result;
            };
        reader.readAsDataURL(event.target.files[0]);
    };
    $(document).ready(function(){

        
        // Multile Image preview
        function previewImages() {

            var $preview = $('.preview-all').empty();
            if (this.files) $.each(this.files, readAndPreview);

            function readAndPreview(i, file) {

                if (!/\.(jpe?g|png|gif|webp)$/i.test(file.name)){
                    return alert(file.name +" is not an image");
                } // else...
                
                var reader = new FileReader();

                $(reader).on("load", function() {
                    $preview.append($("<img/>", {src:this.result, width:200}));
                });

                reader.readAsDataURL(file);

            }

        }

        $('.multiple-image').on("change", previewImages);


        $(document).on('click','#delete',function(e){
            e.preventDefault();
            let link=$(this).attr('href');
            Swal.fire({
                title:"Are your sure want to Delete This!",
                    text:'Once deleted, you will not be able to recover',
                    icon:'warning',
                    showDenyButton: true,
                    showCancelButton: true,
                    confirmButtonText: 'Delete',
                    denyButtonText: `Don't Delete`,
                }).then((willDelete)=>{
                    if (willDelete.isConfirmed) {
                        window.location.href=link;
                    }else{
                    Swal.fire('Your Product Image is safe','', 'info')
                }
            })
        });
    });
    
    
    
    <?php if(session()->has('success')): ?>
            Swal.fire({
                icon:'success',
                text:"<?php echo e(session('success')); ?>"
            })
        <?php endif; ?>
    <?php if(session()->has('error')): ?>
        Swal.fire({
            icon:'error',
            text:"<?php echo e(session('error')); ?>"
        })
    <?php endif; ?>
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin-layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/steellbaazaar/public_html/resources/views/admin/product/edit-image.blade.php ENDPATH**/ ?>