
<?php $__env->startPush('meta'); ?>
    <?php echo $__env->make('components.seo.seo', [
        'title' => $singleProduct->product_name_en,
        'description' => strip_tags($singleProduct->short_desc_en),
        'keywords' => $singleProduct->short_desc_en,
        'image' => $singleProduct->product_thumbnail,
        'url' => route('product.detail', ['id' => $singleProduct->id, 'slug' => $singleProduct->product_slug_en]),
    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopPush(); ?>
<?php $__env->startPush('css'); ?>
    <link href="<?php echo e(asset('assets/backend/lib/select2/css/select2.min.css')); ?>" rel="stylesheet">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <div class="body-content outer-top-xs">
        <div class="breadcrumb">
            <div class="container">
                <div class="breadcrumb-inner">
                    <ul class="list-inline list-unstyled">
                        <li><a href="<?php echo e(route('home')); ?>">Home</a></li>
                        <li><a href="#">Products</a></li>
                        <li class='active'><?php echo e($singleProduct->product_name_en); ?>

                        </li>
                    </ul>
                </div><!-- /.breadcrumb-inner -->
            </div><!-- /.container -->
        </div><!-- /.breadcrumb -->
        <div class='container'>
            <div class='row single-product' id="row-reverse">
                <div class='col-md-3 sidebar col-12'>
                    <div class="sidebar-module-container">

                        <!-- ============= HOT DEALS =========== -->
                        <?php echo $__env->make('components.side-nav', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <?php echo $__env->make('components.deals.hot-deal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <?php echo $__env->make('components.deals.special-deal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <?php echo $__env->make('components.deals.special-offer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                    </div>
                </div><!-- /.sidebar -->
                <div class='col-md-9 col-12'>
                    <div class="detail-block">
                        <div class="row  wow fadeInUp">

                            <div class="col-xs-12 col-sm-6 col-md-6 gallery-holder">
                                <div class="product-item-holder size-big single-product-gallery small-gallery">


                                    <div >
                                        <div class="single-product-gallery-item" id="slide<?php echo e($singleProduct->id); ?>">

                                            <img class="cz-image-zoom zoom-image"
                                                alt="<?php echo e($singleProduct->product_name_en); ?>"
                                                src="<?php echo e(asset($singleProduct->product_thumbnail)); ?>"
                                                data-echo="<?php echo e(asset($singleProduct->product_thumbnail)); ?>" />

                                        </div>
                                        


                                    </div> <!-- /.single-product-slider -->


                                    <div class="single-product-gallery-thumbs gallery-thumbs">

                                        <div id="owl-single-product-thumbnails">
                                            <div class="item thumbnail-item">

                                                <img class="img-responsive thumbnail-item-img" width="85"
                                                    alt="<?php echo e($singleProduct->product_name_en); ?>"
                                                    src="<?php echo e(asset($singleProduct->product_thumbnail)); ?>"
                                                    data-echo="<?php echo e(asset($singleProduct->product_thumbnail)); ?>" />

                                            </div>
                                            <?php $__currentLoopData = $singleProduct->images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <div class="item thumbnail-item">

                                                    <img class="img-responsive thumbnail-item-img" width="85"
                                                        alt="<?php echo e($singleProduct->product_name_en); ?>"
                                                        src="<?php echo e(asset($image->product_image_name)); ?>"
                                                        data-echo="<?php echo e(asset($image->product_image_name)); ?>" />

                                                </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                        </div><!-- /#owl-single-product-thumbnails -->



                                    </div><!-- /.gallery-thumbs -->

                                </div><!-- /.single-product-gallery -->
                            </div>
                            <div class='col-sm-6 col-md-6 col-12 product-info-block'>
                                <div class="product-info">
                                    <h1 class="name">
                                        <?php echo e($singleProduct->product_name_en); ?>

                                    </h1>
                                    <div class="rating-reviews m-t-20">
                                        <div class="custom-row">
                                            <div class="custom-col-6">
                                                <?php for($i = 1; $i <= 5; $i++): ?>
                                                    <i style="color: #ffc808"
                                                        class="glyphicon glyphicon-star<?php echo e($i <= $rating ? '' : '-empty'); ?>"></i>
                                                <?php endfor; ?>
                                                <h4><?php echo e($rating); ?> out of 5</h4>
                                            </div>
                                            <div class="custom-col-6">
                                                <div class="reviews">
                                                    <a href="#" class="lnk">(<?php echo e(count($reviews)); ?> Reviews)</a>
                                                </div>
                                            </div>
                                        </div><!-- /.row -->
                                    </div><!-- /.rating-reviews -->

                                    <div class="stock-container info-container m-t-10">
                                        <div class="custom-row">
                                            <div class="custom-col-6">
                                                <div class="stock-box">
                                                    <span class="label">
                                                        Availability
                                                    </span>
                                                </div>
                                            </div>
                                            <div class="custom-col-6">
                                                <div class="stock-box">
                                                    <?php if($singleProduct->product_quantity_en != null): ?>
                                                        <span
                                                            class="value"><?php echo e(session()->get('language') == 'bangla' ? 'Availability :' : 'In Stock'); ?></span>
                                                    <?php else: ?>
                                                        <span
                                                            class="value"><?php echo e(session()->get('language') == 'bangla' ? 'Availability :' : 'Out Of Stack Stock'); ?></span>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        </div><!-- /.row -->
                                    </div><!-- /.stock-container -->

                                    <div class="description-container m-t-20">
                                        <?php echo $singleProduct->short_desc_en; ?>

                                    </div><!-- /.description-container -->

                                    <div class="price-container info-container m-t-20">
                                        <div class="custom-row">


                                            <div class="custom-col-md-8">
                                                <div class="price-box">
                                                    <?php if($singleProduct->discount_type == null || $singleProduct->discount == null): ?>
                                                        <span class="price">৳ <span class="variant-price"><?php echo e($singleProduct->selling_price); ?></span> </span>
                                                        /<span class="variant-unit"><?php echo e($singleProduct->unit); ?></span>
                                                    <?php else: ?>
                                                        <span class="price">৳ <span class="variant-price"><?php echo e($singleProduct->discount_price); ?></span></span>/<span class="variant-unit"><?php echo e($singleProduct->unit); ?></span>
                                                        <span class="price-strike" id="main-price" style="margin-left: 10px;">৳ <?php echo e($singleProduct->selling_price); ?>

                                                        </span> 
                                                    <?php endif; ?>

                                                </div>
                                            </div>
                                            <div class="custom-col-md-4">
                                                <button type="button" id="get-quote-btn" class="btn btn-warning"
                                                    data-toggle="modal" data-target="#get-quote">Get A Quate</button>
                                            </div>



                                        </div><!-- /.row -->
                                    </div><!-- /.price-container -->
                                    <div class="sharethis-inline-share-buttons"></div>
                                    <form method="POST" id="buy-form">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('POST'); ?>
                                        <input type="hidden" name="price" id="cart-main-price" value="<?php echo e($singleProduct->selling_price); ?>" />
                                        
                                        <input type="hidden" name="unit" id="cart-main-unit" value="<?php echo e($singleProduct->unit); ?>" />
                                        
                                        <div class="quantity-container info-container">
                                            <?php if($singleProduct->product_type == 1): ?>
                                                <div class="custom-row">
                                                    
                                                    <div class="custom-col-6">
                                                        <div class="form-group">
                                                            <label for="color" class="label">Select Color:</label>
                                                            <select name="color"
                                                                class=" form-control color unicase-form-control"
                                                                id="color">
                                                                <?php $__currentLoopData = $productColorEn; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $color): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                    <option value="<?php echo e($color); ?>">
                                                                        <?php echo e($color); ?>

                                                                    </option>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            </select>
                                                        </div>
                                                    </div>
                                                    <div class="custom-col-6">
                                                        <div class="form-group">
                                                            <label for="thickness" class="label">Select Thickness:</label>
                                                            <select name="thickness"
                                                                class=" form-control thickness unicase-form-control"
                                                                id="thickness" value="5">
                                                                <option value="5">
                                                                    5mm
                                                                </option>
                                                                <option value="6">
                                                                    6mm
                                                                </option>
                                                                <option value="8">
                                                                    8mm
                                                                </option>
                                                                <option value="10">
                                                                    10mm
                                                                </option>
                                                                <option value="12">
                                                                    12mm
                                                                </option>
                                                                <option value="14">
                                                                    14mm
                                                                </option>
                                                                <option value="16">
                                                                    16mm
                                                                </option>
                                                                <option value="16">
                                                                    16mm Cutting MS Plate
                                                                </option>
                                                                <option value="20">
                                                                    20mm
                                                                </option>
                                                                <option value="22">
                                                                    22mm
                                                                </option>
                                                                <option value="24">
                                                                    24mm
                                                                </option>
                                                                <option value="25">
                                                                    25mm
                                                                </option>
                                                                <option value="28">
                                                                    28mm
                                                                </option>
                                                                <option value="30">
                                                                    30mm
                                                                </option>
                                                                <option value="32">
                                                                    32mm
                                                                </option>
                                                                <option value="36">
                                                                    36mm
                                                                </option>
                                                                
                                                            </select>
                                                        </div>
                                                    </div>
                                                    <div class="custom-col-6">
                                                        <div class="form-group">
                                                            <label for="color" class="label">
                                                                Select  Unit:
                                                            </label>
                                                            <select name="unit"
                                                                class=" form-control color unicase-form-control"
                                                                id="unit" onchange="handleUnitChange(this)">
                                                                <option value="<?php echo e($singleProduct->unit); ?>"  data-price="<?php echo e($singleProduct->selling_price); ?>" data-convert-value="1">
                                                                    <?php echo e($singleProduct->unit); ?>

                                                                </option>
                                                                <?php if($singleProduct->is_price_variant): ?>
                                                                 
                                                                    <?php $__currentLoopData = $singleProduct->price_variants; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $variant): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                        <option value="<?php echo e($variant->unit); ?>" data-price="<?php echo e($variant->price); ?>" data-convert-value="<?php echo e($variant->convert_value); ?>">
                                                                            <?php echo e($variant->unit); ?>

                                                                        </option>
                                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                <?php else: ?>
                                                                    <option value="Kg">
                                                                        Kg
                                                                    </option>
                                                                    <option value="Ton">
                                                                        MT (Ton)
                                                                    </option>
                                                                <?php endif; ?>
                                                                
                                                            </select>
                                                        </div>
                                                    </div>
                                                    <div class="custom-col-6">
                                                        <div class="form-group">
                                                            <label for="size" class="label">Select Size:</label>
                                                            <select name="size"
                                                                class=" form-control size unicase-form-control"
                                                                id="size">
                                                                <?php $__currentLoopData = $productSizeEn; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $size): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                    <option value="<?php echo e($size); ?>">
                                                                        <?php echo e($size); ?>

                                                                    </option>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            </select>
                                                        </div>
                                                    </div>

                                                </div>
                                                <div class="custom-row" style="align-items: center;">
                                                    <div class="custom-col-6">
                                                        <div class="form-group">
                                                            <label for="weight" class="label">Weight:</label>
                                                            <input type="text" class="unicase-form-control" name="quantity"
                                                                placeholder="Enter Weight" id="weight">
                                                        </div>
                                                    </div>
                                                    <div class="custom-col-6">
                                                        <p id="calculateQty" class="text-center"></p>

                                                    </div>
                                                </div>
                                            <?php else: ?>
                                               
                                                <div class="custom-row">
                                                    
                                                    <div class="custom-col-6">
                                                        <div class="form-group">
                                                            <label for="color" class="label">Select Color:</label>
                                                            <select name="color"
                                                                class=" form-control color unicase-form-control"
                                                                id="color"  value ="<?php echo e($productColorEn[0]); ?>">
                                                                <?php $__currentLoopData = $productColorEn; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $color): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                    <option value="<?php echo e($color); ?>">
                                                                        <?php echo e($color); ?>

                                                                    </option>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            </select>
                                                        </div>
                                                    </div>
                                                    <div class="custom-col-6">
                                                        <label for="qty" class="label">Quantity:</label>
                                                        <input type="number" value="1" min="1"
                                                            id="qty" class="quantity unicase-form-control"
                                                            name="quantity">

                                                    </div>
                                                </div>
                                                <div class="custom-row">
                                                    
                                                    <div class="custom-col-6">
                                                        <div class="form-group">
                                                        <label for="color" class="label">
                                                                Select  Unit:
                                                        </label>
                                                        <select name="unit"
                                                                class=" form-control color unicase-form-control"
                                                                id="unit" onchange="handleUnitChange(this)" value ="<?php echo e($singleProduct->unit); ?>">
                                                            <option value="<?php echo e($singleProduct->unit); ?>"  data-price="<?php echo e($singleProduct->selling_price); ?>" data-convert-value="1">
                                                                    <?php echo e($singleProduct->unit); ?>

                                                            </option>
                                                          
                                                            <?php if($singleProduct->is_price_variant): ?> 
                                                                <?php $__currentLoopData = $singleProduct->price_variants; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $variant): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <option value="<?php echo e($variant->unit); ?>" data-price="<?php echo e($variant->price); ?>"  data-convert-value="<?php echo e($variant->convert_value); ?>">
                                                                    <?php echo e($variant->unit); ?>

                                                                </option>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> 
                                                            <?php endif; ?>
                                                        </select>
                                                    </div>
                                                    </div>
                                                    
                                                </div>
                                                <?php if($singleProduct->hide_size_weight != 1): ?>
                                                <div class="custom-row">

                                                    <div class="custom-col-6">
                                                        <div class="form-group">
                                                            <label for="size" class="label">Select Size:</label>
                                                            <select name="size"
                                                                class=" form-control size unicase-form-control"
                                                                id="size" value ="<?php echo e($productSizeEn[0]); ?>">
                                                                <?php $__currentLoopData = $productSizeEn; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $size): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                    <option value="<?php echo e($size); ?>">
                                                                        <?php echo e($size); ?>

                                                                    </option>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            </select>
                                                        </div>
                                                    </div>
                                                    <div class="custom-col-6">
                                                        <div class="form-group">
                                                            <label for="weight" class="label">Select Weigth:</label>
                                                            <select name="weight"
                                                                class=" form-control size unicase-form-control"
                                                                id="weight"  value ="<?php echo e($productWeight[0]); ?>">
                                                                <?php $__currentLoopData = $productWeight; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $weight): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                    <option value="<?php echo e($weight); ?>">
                                                                        <?php echo e($weight); ?>

                                                                    </option>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            </select>
                                                        </div>
                                                    </div>

                                                </div>
                                                <?php endif; ?>
                                            <?php endif; ?>

                                            <div class="custom-row">
                                                <div class="custom-col-6">
                                                    <input type="hidden" name="product_id" id="product-id"
                                                        class="product-id" value="<?php echo e($singleProduct->id); ?>">
                                                    <button type="submit" class="btn btn-warning" id="buy-btn">
                                                        BUY NOW
                                                    </button>
                                                </div>
                                                <div class="custom-col-6">
                                                    <input type="hidden" name="product_id" id="product-id"
                                                        class="product-id" value="<?php echo e($singleProduct->id); ?>">
                                                    <button type="submit" class="btn btn-primary" id='add-cart'>
                                                        ADD TO CART
                                                    </button>
                                                </div>


                                            </div><!-- /.row -->
                                        </div><!-- /.quantity-container -->
                                    </form>
                                </div><!-- /.product-info -->
                            </div>
                        </div>
                    </div>

                    <div class="product-tabs inner-bottom-xs  wow fadeInUp">
                        <div class="row">
                            <div class="col-sm-3">
                                <ul id="product-tabs" class="nav nav-tabs nav-tab-cell">
                                    <?php if($singleProduct->hightlight_attribute == '1'): ?>
                                        <li class="active">
                                            <a data-toggle="tab" href="#attribute"><?php echo e(__('Attribute')); ?></a>
                                        </li>
                                    <?php endif; ?>
                                    <li class="<?php echo e($singleProduct->hightlight_attribute == '1' ? '' : 'active'); ?>">
                                        <a data-toggle="tab" href="#description"> DESCRIPTION
                                        </a>
                                    </li>
                                    <li>
                                        <a data-toggle="tab" href="#review">REVIEW
                                        </a>
                                    </li>
                                    <?php if($singleProduct->hightlight_attribute != '1'): ?>
                                        <li>
                                            <a data-toggle="tab" href="#attribute"><?php echo e(__('Attribute')); ?></a>
                                        </li>
                                    <?php endif; ?>
                                </ul><!-- /.nav-tabs #product-tabs -->
                            </div>
                            <div class="col-sm-9">

                                <div class="tab-content">

                                    <div id="description"
                                        class="tab-pane in <?php echo e($singleProduct->hightlight_attribute == '1' ? '' : 'active'); ?>">
                                        <div class="product-tab">
                                            <p class="text">
                                                <?php echo $singleProduct->full_desc_en; ?>

                                            </p>
                                        </div>
                                    </div><!-- /.tab-pane -->

                                    <div id="review" class="tab-pane">
                                        <div class="product-tab">

                                            <div class="product-reviews">
                                                <h4 class="title">Customer Reviews</h4>

                                                <div class="reviews">
                                                    <?php $__currentLoopData = $reviews; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $review): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <div class="review">
                                                            <div class="review-title">
                                                                <span class="summary"><?php echo e($review->user->name); ?></span>
                                                                <span class="date"><i
                                                                        class="fa fa-calendar"></i><span><?php echo e($review->created_at->diffForHumans()); ?></span></span>
                                                            </div>
                                                            <div class="text">"<?php echo e($review->comment); ?>"</div>
                                                        </div>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </div><!-- /.reviews -->
                                            </div><!-- /.product-reviews -->

                                        </div><!-- /.product-tab -->
                                    </div><!-- /.tab-pane -->
                                    <div id="attribute"
                                        class="tab-pane <?php echo e($singleProduct->hightlight_attribute != '1' ? '' : 'active'); ?>">
                                        <div class="product-tab">

                                            <div class="product-reviews">
                                                <h4 class="title">Product Attributes</h4>

                                                <div class="table-responsive">
                                                    <table class="table attribute-table">
                                                        <?php $__currentLoopData = $singleProduct?->productAttributes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $attribute): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <tr>
                                                                <th><?php echo e($attribute?->attribute_name); ?></th>
                                                                <td><?php echo e($attribute?->attribute_value); ?></td>
                                                            </tr>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </table>

                                                </div><!-- /.reviews -->
                                            </div><!-- /.product-reviews -->

                                        </div><!-- /.product-tab -->
                                    </div><!-- /.tab-pane -->

                                    <div id="tags" class="tab-pane">
                                        <div class="product-tag">

                                            <h4 class="title">Product Tags</h4>
                                            <form role="form" class="form-inline form-cnt">
                                                <div class="form-container">

                                                    <div class="form-group">
                                                        <label for="exampleInputTag">Add Your Tags: </label>
                                                        <input type="email" id="exampleInputTag"
                                                            class="form-control txt">


                                                    </div>

                                                </div><!-- /.form-container -->
                                            </form><!-- /.form-cnt -->

                                            <form role="form" class="form-inline form-cnt">
                                                <div class="form-group">
                                                    <label>&nbsp;</label>
                                                    <span class="text col-md-offset-3">Use spaces to separate tags. Use
                                                        single quotes (') for phrases.</span>
                                                </div>
                                            </form><!-- /.form-cnt -->

                                        </div><!-- /.product-tab -->
                                    </div><!-- /.tab-pane -->

                                </div><!-- /.tab-content -->
                            </div><!-- /.col -->
                        </div><!-- /.row -->
                    </div><!-- /.product-tabs -->


                </div><!-- /.col -->
                <div class="clearfix"></div>
            </div><!-- /.row -->

        </div><!-- /.container -->
    </div><!-- /.body-content -->
    <?php $__env->startPush('modal'); ?>
        <!-- Modal -->
        <div class="modal fade" id="get-quote" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span
                                aria-hidden="true">&times;</span></button>
                        <h4 class="modal-title" id="myModalLabel"><?php echo e($singleProduct->product_name_en); ?></h4>
                    </div>
                    <div class="modal-body">
                        <form action="<?php echo e(route('quote.store')); ?>" method="post" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('POST'); ?>
                            <div class="form-group">
                                <label for="" class="input-label">Product Quantity <span class="text-danger">*</span>
                                </label>
                                <input type="hidden" name="product_id" value="<?php echo e($singleProduct->id); ?>">
                                <input type="number" class="form-control" name="qty" min="1" value="1">
                            </div>
                            <div class="form-group">
                                <label for="" class="input-label">Your Name<span class="text-danger">*</span>
                                </label>
                                <input type="text" class="form-control" name="name" placeholder="Enter Your Name">
                            </div>
                            <div class="form-group">
                                <label for="" class="input-label">Your Email</label>
                                <input type="text" class="form-control" name="email" placeholder="Enter Your Email">
                            </div>
                            <div class="form-group">
                                <label for="" class="input-label">Your Phone<span class="text-danger">*</span>
                                </label>
                                <input type="text" class="form-control" name="phone" placeholder="Enter Your Phone">
                            </div>
                            <div class="form-group">
                                <label for="" class="input-label">Company / Business Name</label>
                                <input type="text" class="form-control" name="b_name"
                                    placeholder="Enter Your Company / Business Name">
                            </div>
                            <div class="form-group">
                                <label for="" class="input-label">Your Requirements<span class="text-danger">*</span>
                                </label>
                                <textarea name="requirments" id="" class="form-control"
                                    placeholder="Input your requirements: such as Length/width/ height, application, floor area, location, budget, etc.*"
                                    rows="5"></textarea>
                            </div>
                            <div class="form-group">
                                <label for="file" class="input-label">Attach File</label>
                                <input type="file" class="form-control-file" id="file" name="file">
                            </div>
                            <div class="form-group">

                                <button class="btn btn-success" type="submit">Send</button>
                            </div>
                        </form>
                    </div>

                </div>
            </div>
        </div>
    <?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <script src="<?php echo e(asset('assets/backend/lib/select2/js/select2.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('assets/frontend/js/zoomsl.min.js')); ?>"></script>

    <script>
    
        $('.thumbnail-item-img').click(function() {
            let img = $(this).attr('src'); 
            $('.single-product-gallery-item img').attr('src', img);
        })
        function handleUnitChange(value) {
            
            var selectedUnit = value.value;
            var selectedPrice = value.options[value.selectedIndex].getAttribute('data-price');
            var selectedValue = value.options[value.selectedIndex].getAttribute('data-convert-value');
            
         
            const discount = "<?php echo e($singleProduct->discount); ?>";
            const discountType = "<?php echo e($singleProduct->discount_type); ?>";
            
            $('.variant-unit').text(selectedUnit)
            $('#cart-main-unit').val(selectedUnit)
            $('#unit').val(selectedUnit)
                
            if(discount){
              
                const discountPrice = discountType == 'flat' ? Number(selectedPrice) - (Number(discount) * Number(selectedValue)): Number(selectedPrice) - ((Number(selectedPrice) * Number(discount) )/100);
                $('#main-price').text(selectedPrice)
                $('.variant-price').text(discountPrice)
                $('#cart-main-price').val(discountPrice)
                
            }else {
                $('.variant-price').text(selectedPrice)
                $('#cart-main-price').val(selectedPrice)
            }   
             
           

        }
        $(document).ready(function() {
            
            $('#buy-btn').click(function() {
                
                let action = "<?php echo e(route('product.buy')); ?>"
                let method = "POST"
                $('#buy-form').attr('method', method);
                $('#buy-form').attr('action', action);
            })
            $('#add-cart').click(function() {
                let id = "<?php echo e($singleProduct->id); ?>";
                let action = "<?php echo e(route('product.add.cart', $singleProduct->id)); ?>"
                let method = "POST"
                $('#buy-form').attr('method', method);
                $('#buy-form').attr('action', action);
            })

            // Image Zoom in hover 
            $(".cz-image-zoom").imagezoomsl();
            // MS PLate Qty  Calculate
            $('#thickness').on('change', function() {
                $('#weight').val('')
                $('#calculateQty').html('')
            })
            $('#unit').on('change', function() {
                $('#weight').val('')
                $('#calculateQty').html('')
            })
            $('#size').on('change', function() {
                $('#weight').val('')
                $('#calculateQty').html('')
            })
            $('#weight').on('keyup', function() {
                const thickness = $('#thickness').val()
                const unit = $('#unit').val()
                const size = $('#size').val()
                const weight = $('#weight').val()
                if (thickness == '' || thickness == null) {
                    alert('Please Select Thickness')
                }
                if (unit == '' || unit == null) {
                    alert('Please Select Unit')
                }
                if (size == '' || size == null) {
                    alert('Please Select Size')
                }
                if (weight == '' || weight == null) {
                    alert('Please Enter Weight')
                }
                const arr = size.split('X')

                if (unit == "Kg") {

                    const qtyKg = (Number(weight) * 1000000000) / (Number(thickness) * 7850 * Number(
                        arr[0]) * Number(arr[1]))

                    const kgPcs = Math.trunc(qtyKg)
                    const kgFraction = qtyKg - kgPcs
                    const kgUnitDetails =
                        `Detail of Pieces <br /> ${kgPcs} Pcs + ${Math.round(Number(arr[0])*kgFraction) }mm X ${arr[1]}mm`
                    $('#calculateQty').html(kgUnitDetails)

                }if (unit == "Ton") {
                    const qtyTonne = (Number(weight) * 1000000000) / (Number(thickness) * 7.85 * Number(
                        arr[0]) * Number(arr[1]))

                    const tonnePcs = Math.trunc(qtyTonne)
                    const tonneFraction = qtyTonne - tonnePcs
                    const tonneUnitDetails =
                        `Detail of Pieces <br /> ${tonnePcs} Pcs + ${Math.round(Number(arr[0])*tonneFraction) }mm X ${arr[1]}mm`
                    $('#calculateQty').html(tonneUnitDetails)
                }



            })

            $('#thickness').select2()
            $('#color').select2({
                tags: true
            })
            $('#size').select2({
                tags: true
            })
            $('#weight').select2({
                tags: true
            })

           
            
          

        })
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.frontend-layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/steellbaazaar/public_html/resources/views/frontend/product-detail.blade.php ENDPATH**/ ?>