@extends('layouts.frontend-layout')
@section('title', 'User Profile')
@section('content')
    <div class="body-content">
        <div class="container user-dashboard">
            <div class="row">
                @include('user.inc.sideNav')
                <div class="col-sm-7" style="margin-top: 30px;">
                    <div class="tracking-from" style="background: #fff;padding:30px;">
                        <form action="{{ route('user.order.track') }}" method="POST" class="form">
                            @csrf
                            <div class="form-group">
                                <label for="">Order Invoice NO</label>
                                <input type="text" id="invocie-no" name="invoice_no" placeholder="Enter Order Invoice NO"
                                    class="form-control">
                            </div>
                            <div class="form-group">
                                <button class="btn btn-success" type="submit">Track</button>
                            </div>
                        </form>
                    </div>
                    @if ($order)
                        <div class="shopping-cart">
                            <h3>Last order</h3>
                            <div class="shopping-cart-table ">
                                <div class="table-responsive order-table">
                                    <table class="table table-responsive">
                                        <thead>
                                            <tr>
                                                <th>Order Date</th>
                                                <th>Amount (TK)</th>
                                                <th>Invoice NO</th>
                                                <th>Status</th>
                                                <th>Action</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr>
                                                <td>{{ $order->order_date }}</td>
                                                <td>{{ $order->amount }}</td>
                                                <td>{{ $order->invoice_no }}</td>
                                                <td><span class="badge" style="background: #318bc0;color:#fff;">
                                                        {{ $order->status }}</span></td>
                                                <td>
                                                    <a href="{{ route('user.order.product', ['order_id' => $order->id]) }}"
                                                        class="btn btn-success" style="margin:5px 0;"><i class="fa fa-eye">
                                                            View</i></a>
                                                    <a href="{{ route('user.order.invoice', ['order_id' => $order->id]) }}"
                                                        class="btn btn-danger"><i class="fa fa-download"> Invoice</i></a>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    @endif
                </div>
                <div class="col-sm-2" style="margin-top: 30px;">

                    <div class="profile-image">
                        <img src="{{ asset($user->image) }}" alt="{{ $user->name }}" style="width: 150px;">
                    </div>

                    <div class="profile-ingo">
                        <h4>Name : {{ $user->name }}</h4>
                        <p>Email : {{ $user->email }}</p>
                        <p>Phone : {{ $user->phone }}</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('scripts')
    <script type="text/javascript">
        @if (session()->has('success'))
            Swal.fire({
                icon: 'success',
                text: "{{ session('success') }}"
            })
        @endif
    </script>
@endsection
