@extends('layouts.frontend-layout')
@push('meta')
    @include('components.seo.seo', [
        'title' => $setting->title,
        'description' => $setting->seo_description,
        'keywords' => $setting->seo_meta,
        'image' => $setting->logo,
        'url' => route('home'),
    ])
@endpush
@section('home', 'active')
@section('content')

    <div class="body-content outer-top-xs" id="top-banner-and-menu">
        <div class="container">
            <div class="row" id="row-reverse">

                <!--  SIDEBAR  -->
                <div class="col-xs-12 col-sm-12 col-md-3 sidebar">

                    <!--  TOP NAVIGATION -->
                    @include('components.side-nav')
                    
                    @include('components.deals.hot-deal')
                    <!-- HOT DEALS: END -->


                    <!-- SPECIAL OFFER -->
                    @include('components.deals.special-offer')
                    
                    <!-- ===================== SPECIAL OFFER : END ===================== -->

                    <!-- ===================== SPECIAL DEALS ===================== -->
                    @include('components.deals.special-deal')
                    
                    <!-- ===================== SPECIAL DEALS : END ===================== -->
                    

                </div><!-- /.sidemenu-holder -->
                <!-- ===================== SIDEBAR : END ===================== -->

                <!-- ===================== CONTENT ===================== -->
                <div class="col-xs-12 col-sm-12 col-md-9 homebanner-holder">
                    <!-- ================= SECTION – HERO ================ -->

                    <div id="hero">
                        <div id="owl-main" class="owl-carousel owl-inner-nav owl-ui-sm">
                            @foreach ($slider as $slide)
                                <div class="item" style="background-image: url({{ asset($slide->image) }});">
                                    <div class="container-fluid">
                                        <div class="caption bg-color vertical-center text-left">
                                            <div class="slider-header fadeInDown-1">
                                                {{ $slide->sub_title_en }}
                                            </div>
                                            <div class="big-text fadeInDown-1">
                                                {{ $slide->title_en }}
                                            </div>

                                            <div class="excerpt fadeInDown-2 hidden-xs">

                                                <span>
                                                    {{ $slide->description_en }}
                                                </span>

                                            </div>
                                            
                                        </div><!-- /.caption -->
                                    </div><!-- /.container-fluid -->
                                </div><!-- /.item -->
                            @endforeach



                        </div><!-- /.owl-carousel -->
                    </div>

                    <!-- ================ SECTION – HERO : END ================ -->

                    
                    <!-- ===================== SCROLL TABS ===================== -->
                    <div id="product-tabs-slider" class="scroll-tabs outer-top-vs wow fadeInUp">
                        <div class="more-info-tab clearfix ">
                            <h3 class="new-product-title pull-left">
                                New Products
                            </h3>
                            <ul class="nav nav-tabs nav-tab-line pull-right" id="new-products-1">
                                <li class="active">
                                    <a data-transition-type="backSlide" href="#all" data-toggle="tab">
                                        All
                                    </a>
                                </li>
                                @foreach ($categories as $category)
                                    @if($category->show_on_navbar)
                                        <li>
                                            <a data-transition-type="backSlide" href="#category-{{ $category->id }}"
                                                data-toggle="tab">
                                                {{ $category->category_name_en }}
                                            </a>
                                        </li>
                                    @endif
                                @endforeach
                            </ul><!-- /.nav-tabs -->
                        </div>

                        <div class="tab-content outer-top-xs">
                            <div class="tab-pane in active" id="all">
                                <div class="product-slider">
                                    <div class="owl-carousel home-owl-carousel custom-carousel owl-theme" data-item="4">

                                        @foreach ($products as $product)
                                            <div class="owl-item" style="width: 170px;">
                                                <div class="item item-carousel">
                                                    <div class="products">

                                                        @include('components.product.product', [
                                                            'product' => $product,
                                                        ])

                                                    </div><!-- /.products -->
                                                </div>
                                            </div>
                                        @endforeach
                                    </div><!-- /.home-owl-carousel -->
                                </div><!-- /.product-slider -->
                            </div><!-- /.tab-pane -->
                            @foreach ($categories as $category)
                                <div class="tab-pane" id="category-{{ $category->id }}">
                                    <div class="product-slider">
                                        <div class="owl-carousel home-owl-carousel custom-carousel owl-theme">


                                            @foreach ($products as $product)
                                                @if ($product->category_id == $category->id)
                                                    <div class="owl-item" style="width: 170px;">
                                                        <div class="item item-carousel">

                                                            <div class="products">

                                                                @include('components.product.product', [
                                                                    'product' => $product,
                                                                ])
                                                            </div><!-- /.products -->

                                                        </div>
                                                    </div>
                                                @endif
                                            @endforeach

                                        </div><!-- /.home-owl-carousel -->
                                    </div><!-- /.product-slider -->
                                </div><!-- /.tab-pane -->
                            @endforeach
                        </div><!-- /.tab-content -->
                    </div><!-- /.scroll-tabs -->
                    <!-- ===================== SCROLL TABS : END ===================== -->
                    <!--All Category-->
                    <section class="section featured-product wow fadeInUp">
                        <h3 class="section-title">
                            Categories
                        </h3>
                        <div class="row">
                            @foreach ($categories as $category)
                                <div class="col-md-3 col-sm-4 col-6">
                                    <a class="category-item" href="{{route('product.parent.category',['slug'=>$category->category_slug_en,'id'=>$category->id])}}">
                                        <img src="{{asset($category->category_icon)}}" class="category-image" />
                                        <div class="category-content">
                                            <h4 class="category-name">{{$category->category_name_en}}</h4>
                                        </div>
                                    </a>
                                </div>
                            @endforeach
                        </div>
                    </section>
                        
                    <!-- ===================== FEATURED PRODUCTS ===================== -->
                    @include('components.deals.feature-offer')

                    <!-- Category Wise Product-->
                    @foreach ($categories as $category)
                        <section class="section featured-product wow fadeInUp">
                            <h3 class="section-title">
                                {{  $category->category_name_en }}
                            </h3>
                            <div class="owl-carousel home-owl-carousel custom-carousel owl-theme outer-top-xs">
                                @foreach ($products as $product)
                                    @if ($product->category_id == $category->id)
                                        <div class="item item-carousel">
                                            <div class="products">
                                                @include('components.product.product', [
                                                    'product' => $product,
                                                ])

                                            </div><!-- /.products -->
                                        </div><!-- /.item -->
                                    @endif
                                @endforeach
                            </div><!-- /.home-owl-carousel -->
                        </section><!-- /.section -->
                    @endforeach

                    <!-- Brand Wise Product Show-->

                    @foreach ($brands as $brand)
                        <section class="section featured-product wow fadeInUp">
                            <h3 class="section-title">
                                {{ session()->get('language') == 'bangla' ? $brand->brand_name_bn : $brand->brand_name_en }}
                            </h3>
                            <div class="owl-carousel home-owl-carousel custom-carousel owl-theme outer-top-xs">
                                @foreach ($products as $product)
                                    @if ($product->brand_id == $brand->id)
                                        <div class="item item-carousel">
                                            <div class="products">
                                                @include('components.product.product', [
                                                    'product' => $product,
                                                ])

                                            </div><!-- /.products -->
                                        </div><!-- /.item -->
                                    @endif
                                @endforeach
                            </div><!-- /.home-owl-carousel -->
                        </section><!-- /.section -->
                    @endforeach

                    <!-- =========== FEATURED PRODUCTS : END ========== -->

                    <!-- ============== BEST SELLER ========== -->

                    <div class="best-deal wow fadeInUp outer-bottom-xs">
                        <h3 class="section-title">Best seller</h3>
                        <div class="sidebar-widget-body outer-top-xs">
                            <div class="owl-carousel best-seller custom-carousel owl-theme outer-top-xs">
                                @forelse ($bestSells as $bestSell)
                                    <div class="item">
                                        <div class="products best-product">
                                            <div class="product">
                                                <div class="product-micro">
                                                    <div class="row product-micro-row">
                                                        <div class="col col-xs-5">
                                                            <div class="product-image">
                                                                <div class="image">
                                                                    <a href="#">
                                                                        <img src="{{ asset($bestSell->product_thumbnail) }}"
                                                                            alt="{{ $bestSell->product_name_en }}">
                                                                    </a>
                                                                </div><!-- /.image -->

                                                            </div><!-- /.product-image -->
                                                        </div><!-- /.col -->
                                                        <div class="col2 col-xs-7">
                                                            <div class="product-info">
                                                                <h3 class="name"><a
                                                                        href="#">{{ $bestSell->product_name_en }}</a>
                                                                </h3>
                                                                <div class="rating" style="color: #ffc808">
                                                                    @php
                                                                        
                                                                        $rating = $bestSell->reviews->avg('rating');
                                                                    @endphp
                                                                    @for ($i = 1; $i <= 5; $i++)
                                                                        <i
                                                                            class="glyphicon glyphicon-star{{ $i <= $rating ? '' : '-empty' }}"></i>
                                                                    @endfor
                                                                </div>
                                                                <div class="product-price">
                                                                    <span class="price">
                                                                        {{ $bestSell->discount_price }} TK</span>

                                                                </div><!-- /.product-price -->

                                                            </div>
                                                        </div><!-- /.col -->
                                                    </div><!-- /.product-micro-row -->
                                                </div><!-- /.product-micro -->

                                            </div>
                                        </div>
                                    </div>

                                @empty
                                    Not Avaliable
                                @endforelse
                            </div>
                        </div><!-- /.sidebar-widget-body -->
                    </div><!-- /.sidebar-widget -->
                    <!-- ==== BEST SELLER : END ======= -->


                    <!-- ======= FEATURED PRODUCTS ======== -->
                    <section class="section wow fadeInUp new-arriavls">
                        <h3 class="section-title">New Arrivals</h3>
                        <div class="owl-carousel home-owl-carousel custom-carousel owl-theme outer-top-xs">

                            @foreach ($products as $product)
                                <div class="item item-carousel">
                                    <div class="products">

                                        @include('components.product.product', ['product' => $product])
                                    </div><!-- /.products -->
                                </div><!-- /.item -->
                            @endforeach
                        </div><!-- /.home-owl-carousel -->
                    </section><!-- /.section -->
                    <!-- ===================== FEATURED PRODUCTS : END ===================== -->

                </div><!-- /.homebanner-holder -->
                <!-- ===================== CONTENT : END ===================== -->
            </div><!-- /.row -->
            
        </div><!-- /.container -->
    </div><!-- /#top-banner-and-menu -->

@endsection

