@extends('layouts.admin-layout')
@section('title','Role')
@section('roles','active show-sub')
@section('all-roles','active')
@section('content')
<nav class="breadcrumb sl-breadcrumb">
  <a class="breadcrumb-item" href="{{route('admin.dashboard')}}">{{__('Dashboard')}}</a>
  <span class="breadcrumb-item active">Role</span>
</nav>

<div class="sl-pagebody slider-page">
    <div class="row row-sm">
        <div class="col-md-12">
            <div class="card pd-10 pd-sm-20">
                <h6 class="card-body-title">All Roles</h6>
                <div class="table-wrapper">
                    <table class="table display responsive" id="role-table">
                        <thead>
                            <tr>
                                <th class="wd-5p">SI</th>
                                <th class="wd-15p">Name</th>
                                <th class="wd-65p">Permissions</th>
                                <th class="wd-15p">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @php
                                $start = 0;
                            @endphp
                            @forelse ($roles as $role)   
                                <tr>
                                    <td class="wd-5p">{{++$start }}</td>
                                    <td class="wd-15p">{{$role->name}}</td>
                                    <td class="wd-65p">
                                        
                                        @forelse($role->permissions as $permission)
                                            <span class="badge badge-success">{{$permission->name}}</span>
                                        @empty
                                        
                                        ---
                                        
                                        @endForelse
                                    
                                    </td>
                                    
                                    <td class="wd-15p">
                                        @if($role->id !=1)
                                            <a href="{{route('roles.edit',$role->id)}}" class="btn btn-success" title="Role Edit"><i class="fa fa-edit"></i></a>
                                            <form action="{{route('roles.destroy',$role->id)}}" method="POST" id="delete-form">
                                                @csrf
                                                @method('get')
                                                <button type="submit" class="btn btn-danger" title="Role Delete"><i class="fa fa-trash"></i></button>
                                            </form>
                                        @endif
                                        
                                        
                                    </td>
                                </tr> 
                            @empty
                                <tr>
                                    <td colspan="6">No Data Found</td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
@section('scripts')
    <script type="text/javascript">
        $('#role-table').DataTable({
            responsive: true,
            language: {
            searchPlaceholder: 'Search...',
            sSearch: '',
            lengthMenu: '_MENU_ items/page',
            }
        });
        $(document).on('click','#delete-form',function(e){
            e.preventDefault();
            let link=$(this).attr('action');
            Swal.fire({
                title:"Are your sure want to Delete !",
                text:'Once deleted, you will not be able to recover',
                icon:'warning',
                showDenyButton: true,
                showCancelButton: true,
                confirmButtonText: 'Delete',
                denyButtonText: `Don't Delete`,
            }).then((willDelete)=>{
                if (willDelete.isConfirmed) {
                    window.location.href=link;
                }else{
                    Swal.fire('This Role is safe','', 'info')
                }
            })
        });
        @if (session()->has('success'))
            Swal.fire({
                icon:'success',
                text:"{{session('success')}}"
            })
        @endif
        @if (session()->has('error'))
            Swal.fire({
                icon:'error',
                text:"{{session('error')}}"
            })
        @endif
    </script>
@endsection