@extends('layouts.admin-layout')
@section('title', 'All Quotes')
@section('quote', 'active')
@section('content')
    <nav class="breadcrumb sl-breadcrumb">
        <a class="breadcrumb-item" href="{{ route('admin.dashboard') }}">{{ __('Dashboard') }}</a>
        <span class="breadcrumb-item active">Quotes</span>
    </nav>

    <div class="sl-pagebody">
        <div class="row row-sm">
            <div class="col-12">
                <div class="card pd-10 pd-sm-20">
                    <h6 class="card-body-title">All Quote</h6>
                    <div class="table-wrapper">
                        <table class="table display responsive nowrap" id="brand-table">
                            <thead>
                                <tr>
                                    <th>SI</th>
                                    <th>Name</th>
                                    <th>Phone Number</th>
                                    <th>Product Name</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @php
                                    $start = 0;
                                @endphp
                                @forelse ($quotes as $quote)
                                    <tr>
                                        <td>{{ ++$start }}</td>
                                        <td>{{ $quote->name }}</td>
                                        <td>{{ $quote->phone }}</td>
                                        <td>{{ $quote->product->product_name_en }}</td>

                                        <td>
                                            <a href="{{ route('admin.quote.show', $quote->id) }}" class="btn btn-success"
                                                title="Edit Brand">View</a>
                                            <a href="{{ route('admin.shipping.cost.edit', $quote->id) }}"
                                                class="btn btn-primary" title="Edit Brand">Edit</a>
                                            <a href="{{ route('admin.quote.invoice', $quote->id) }}" class="btn btn-warning"
                                                id="invoice" title="Invoice">Invoice</a>
                                            <a href="{{ route('admin.quote.destroy', $quote->id) }}" class="btn btn-danger"
                                                id="delete" title="Delete Brand">Delete</a>
                                        </td>
                                    </tr>
                                @empty
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

        </div>
    </div>
@endsection
@section('scripts')
    <script type="text/javascript">
        $('#brand-table').DataTable({
            responsive: true,
            language: {
                searchPlaceholder: 'Search...',
                sSearch: '',
                lengthMenu: '_MENU_ items/page',
            }
        });
        $(document).on('click', '#delete', function(e) {
            e.preventDefault();
            let link = $(this).attr('href');
            Swal.fire({
                title: "Are your sure want to Delete !",
                text: 'Once deleted, you will not be able to recover',
                icon: 'warning',
                showDenyButton: true,
                showCancelButton: true,
                confirmButtonText: 'Delete',
                denyButtonText: `Don't Delete`,
            }).then((willDelete) => {
                if (willDelete.isConfirmed) {
                    window.location.href = link;
                } else {
                    Swal.fire('Quote is safe', '', 'info')
                }
            })
        });
        @if (session()->has('success'))
            Swal.fire({
                icon: 'success',
                text: "{{ session('success') }}"
            })
        @endif
        @if (session()->has('error'))
            Swal.fire({
                icon: 'error',
                text: "{{ session('error') }}"
            })
        @endif
    </script>
@endsection
