@extends('layouts.admin-layout')
@section('title', 'Edit Product')
@section('product', 'active show-sub')
@section('all', 'active')
@section('content')
    <nav class="breadcrumb sl-breadcrumb">
        <a class="breadcrumb-item" href="{{ route('admin.dashboard') }}">{{ __('Dashboard') }}</a>
        <a class="breadcrumb-item" href="{{ route('products.all') }}">{{ __('Products') }}</a>
        <span class="breadcrumb-item active">Edit</span>
    </nav>
    @php
        $units = [
            'Pcs', 'Sft', 'Kg', 'Pound', 'Ton', 'Pair', 'Rol', 'Feet',
            'Metre', 'Centi Metre', 'Mili Metre', 'Box', 'Please Contact For Price',
        ];
    @endphp
    <div class="sl-pagebody">
        <div class="row row-sm">
            <div class="col-md-12">
                <div class="card pd-10 pd-sm-20">
                    <h6 class="card-body-title">Edit Product</h6>
                     @if ($errors->any())

                        <ul>
                            @foreach($errors->all() as $error)
                                <li class="text-danger"> {{ $error }}</li>
                            @endforeach
                        </ul>

                    @endif
                    <form action="{{ route('product.update', ['id' => $product->id]) }}" method="POST" class="form-layout">
                        @method('PATCH')
                        @csrf
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label class="form-control-label">Select Brand <span class="tx-danger">*</span></label>
                                    <select class="form-control select2 select2-show-search" name="brand_id"
                                        data-placeholder="Choose one">
                                        <option label="Choose one"></option>
                                        @foreach ($brands as $brand)
                                            <option value="{{ $brand->id }}" name="brand"
                                                {{ $product->brand_id == $brand->id ? 'selected' : '' }}>
                                                {{ $brand->brand_name_en }}</option>
                                        @endforeach
                                    </select>
                                    @error('brand_id')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label class="form-control-label">Select Category <span
                                            class="tx-danger">*</span></label>
                                    <select class="form-control select2 select2-show-search" name="category_id"
                                        data-placeholder="Choose one" id="category">
                                        <option label="Choose one">Choose one</option>
                                        @foreach ($categories as $category)
                                            <option value="{{ $category->id }}" name="category"
                                                {{ $product->category_id == $category->id ? 'selected' : '' }}>
                                                {{ $category->category_name_en }}</option>
                                        @endforeach
                                    </select>
                                    @error('category_id')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label class="form-control-label">Select Sub Category <span
                                            class="tx-danger">*</span></label>
                                    <select class="form-control select2 select2-show-search" name="subcategory_id"
                                        data-placeholder="Choose one" id="sub-category">
                                        <option label="{{ $product?->subCategory?->subcategory_name_en }}" selected
                                            value="{{ $product?->subCategory?->id }}">
                                            {{ $product?->subCategory?->subcategory_name_en }}</option>
                                    </select>
                                    @error('subcategory_id')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label class="form-control-label">Select Sub Sub Category <span
                                            class="tx-danger">*</span></label>
                                    <select class="form-control select2 select2-show-search" name="subsubcategory_id"
                                        data-placeholder="Choose one" id="sub-sub-category">
                                        <option label="{{ $product?->subSubCategory?->subsubcategory_name_en }}" selected
                                            value="{{ $product?->subSubCategory?->id }}">
                                            {{ $product?->subSubCategory?->subsubcategory_name_en }}
                                        </option>
                                    </select>
                                    @error('subsubcategory_id')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label class="form-control-label">Product Name<span class="tx-danger">*</span></label>
                                    <input class="form-control" type="text" name="product_name_en"
                                        value="{{ $product->product_name_en }}" placeholder="Enter Product Name">
                                    @error('product_name_en')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label class="form-control-label">Product Code<span class="tx-danger">*</span></label>
                                    <input class="form-control" type="text" name="product_code"
                                        value="{{ $product->product_code }}" placeholder="Enter Product Code">
                                    @error('product_code')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label class="form-control-label">Product Quantity <span
                                            class="tx-danger">*</span></label>
                                    <input class="form-control" type="text" name="product_quantity_en"
                                        value="{{ $product->product_quantity_en }}" placeholder="Enter Product Quantity">
                                    @error('product_quantity_en')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label class="form-control-label">Product Tags <span class="tx-danger">*</span></label>
                                    <input class="form-control" type="text" name="product_tags_en"
                                        value="{{ $product->product_tags_en }}" placeholder="Enter Product Tags"
                                        data-role="tagsinput">
                                    @error('product_tags_en')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label class="form-control-label">Attribute<span class="tx-danger">*</span></label>
                                    <select class="form-control select2" data-placeholder="Choose Attribute" multiple
                                        id="attribute">
                                        @foreach ($attributes as $attribute)
                                            <option value="{{ $attribute->name }}">{{ $attribute->name }}</option>
                                        @endforeach

                                    </select>

                                </div>
                            </div>

                            <div class="col-md-12">
                                <div class="row" id="product-attributes"></div>
                            </div>
                            @foreach ($product->productAttributes as $attribute)
                                <div class="col-md-4 my-1">
                                    <div class="form-group">
                                        <label class="form-control-label"
                                            for="{{ $attribute->attribute_name }}">{{ $attribute->attribute_name }}</label>
                                        <input class="form-control" type="text"
                                            name="product_attributes[{{ $attribute->attribute_name }}]"
                                            value='{{ $attribute->attribute_value }}'
                                            id="{{ $attribute->attribute_name }}" data-role="tagsinput">

                                    </div>
                                </div>
                            @endforeach

                            <div class="col-md-8">
                                <div class="form-group">
                                    <label class="form-control-label">Product Color</label>
                                    <input class="form-control" type="text" name="product_color_en"
                                        value="{{ $product->product_color_en }}" placeholder="Enter Product Color"
                                        data-role="tagsinput">
                                    @error('product_color_en')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label class="form-control-label">Product Size</label>
                                    <input class="form-control" type="text" name="product_size_en"
                                        value="{{ $product->product_size_en }}" placeholder="Enter Product Size"
                                        data-role="tagsinput">
                                    @error('product_size_en')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label class="form-control-label">Product Weight</label>
                                    <input class="form-control" type="text" name="product_weight_en"
                                        value="{{ old('product_weight_en') }}" placeholder="Enter Product Weight" data-role="tagsinput">
                                    @error('product_weight_en')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label class="form-control-label" for="unit">Unit</label>
                                    <select class="form-control select2 select2-show-search" name="unit"
                                        data-placeholder="Choose Unit" id="sub-sub-category">
                                        <option label="Choose Unit">Choose Unit</option>
                                        @foreach($units as $unit)
                                            <option label="{{ $unit }}" {{ $product->unit == $unit ? 'selected' : '' }}>
                                                {{ $unit }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('unit')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label class="form-control-label">Selling Price<span
                                            class="tx-danger">*</span></label>
                                    <input class="form-control" type="text" name="selling_price"
                                        value="{{ $product->selling_price }}" placeholder="Enter Product Name Bangla">
                                    @error('selling_price')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label class="form-control-label" for="discount-type">Discount Type<span
                                            class="tx-danger">*</span></label>
                                    <select name="discount_type" id="discount-type" class="form-control">
                                        <option value="flat" {{ $product->discount_type == 'flat' ? 'selected' : '' }}>
                                            Flat
                                        </option>
                                        <option
                                            value="parcent"{{ $product->discount_type == 'parcent' ? 'selected' : '' }}>
                                            Parcent</option>
                                    </select>
                                    @error('discount_type')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label class="form-control-label">Discount<span class="tx-danger">*</span></label>
                                    <input class="form-control" type="text" name="discount"
                                        value="{{ $product->discount }}" placeholder="Discount Amount">
                                    @error('discount')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            
                            <div class="col-md-3 mt-2">
                                <div class="form-group">
                                    <label class="ckbox">
                                        <input type="checkbox" value="1" name="product_type"
                                            {{ $product->product_type == '1' ? 'checked' : '' }}>
                                        <span>MS Plate</span>
                                    </label>
                                    @error('product_type')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-3 mt-2">
                                <div class="form-group">
                                    <label class="ckbox">
                                        <input type="checkbox" value="1" name="hide_size_weight" {{ $product->hide_size_weight == '1' ? 'checked' : '' }}>
                                        <span>Hide Size and Weight</span>
                                    </label>
                                    @error('hide_size_weight')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-3 mt-2">
                                <div class="form-group">
                                    <label class="ckbox">
                                        <input type="checkbox" value="1" name="hot_deals"
                                            {{ $product->hot_deals == '1' ? 'checked' : '' }}>
                                        <span>Hot Deals</span>
                                    </label>
                                    @error('hot_deals')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-3 mt-2">
                                <div class="form-group">
                                    <label class="ckbox">
                                        <input type="checkbox" value="1" name="featured"
                                            {{ $product->featured == '1' ? 'checked' : '' }}>
                                        <span>Featured</span>
                                    </label>
                                    @error('featured')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-3 mt-2">
                                <div class="form-group">
                                    <label class="ckbox">
                                        <input type="checkbox" value="1" name="special_offer"
                                            {{ $product->special_offer == '1' ? 'checked' : '' }}>
                                        <span>Special Offer</span>
                                    </label>
                                    @error('special_offer')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-3 mt-2">
                                <div class="form-group">
                                    <label class="ckbox">
                                        <input type="checkbox" value="1" name="special_deals"
                                            {{ $product->special_deals == '1' ? 'checked' : '' }}>
                                        <span>Special Deals</span>
                                    </label>
                                    @error('special_deals')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-3 mt-2">
                                <div class="form-group">
                                    <label class="ckbox">
                                        <input type="checkbox" name="hightlight_attribute" value="1"
                                            {{ $product->hightlight_attribute == '1' ? 'checked' : '' }}>
                                        <span>Hightlight Attributes</span>
                                    </label>
                                    @error('hot_deals')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                                <div style="margin-top: 40px;">
                                    <label class="ckbox">
                                        <input type="checkbox" name="is_price_variant" id="is-unit-variant" value="1" {{$product->is_price_variant ? "checked" : ''}}>
                                        <span>Enable Price Variant</span>
                                    </label>
                                    @error('is_price_variant')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-12 {{$product->is_price_variant ? '' : 'd-none'}}" id="unit-variants">
                                
                               
                            @if($product->is_price_variant)
                                @foreach($product->price_variants as $key => $variant)
                                <div class="row">
                            
                                  <div class="col-md-4">
                                    <div class="form-group">
                                      <div>
                                          <label class="form-control-label">Variant Unit Name <span class="tx-danger">*</span></label>
                                      </div>
                                      <div>
                                          
                                          <select class="form-control select2 select2-show-search w-full" style="width: 100%;" value='{{$variant->unit}}' name="variants[{{$key}}][unit]"
                                                  data-placeholder="Choose Unit">
                                            @foreach($units as $unit)
                                            <option label="{{ $unit }}" {{ $variant->unit == $unit ? 'selected' : '' }}>
                                                {{ $unit }}
                                            </option>
                                        @endforeach
                                          </select>
                                          </div>
                                     
                                    </div>
                                  </div>
                                  <div class="col-md-4">
                                    <div class="form-group">
                                      <label class="form-control-label">Variant Price <span class="tx-danger">*</span></label>
                                      <input class="form-control" type="text" name="variants[{{$key}}][price]" value='{{$variant->price}}'
                                              placeholder="Enter Variant Price">
                                      
                                    </div>
                                  </div>
                                  <div class="col-md-4" style="display: flex">
                                    <div class="form-group"  style="width: 75%">
                                      <label class="form-control-label">Convert Unit Value<span class="tx-danger">*</span></label>
                                      <input class="form-control" type="text" value='{{$variant->convert_value}}' name="variants[{{$key}}][convert_value]"
                                             placeholder="Enter Convert Unit Value">
                                      
                                    </div>
                                    <div class="ml-2" style="width: 25%">
                                        @if($key === 0)
                                        <button class="btn btn-success" onClick="addMoreVariant()" style="margin-top: 35px;" type="button">Add More</button>
                                        @else
                                        <button class="btn btn-danger remove-unit-variant" style="margin-top: 35px;" type="button">Remove</button>
                                        @endif
                                      
                                      </div>
                                  </div>
                                  
                            
                                </div>
                                @endForeach
                            @else
                            <div class="row">
                                 
                                  <div class="col-md-4">
                                    <div class="form-group">
                                      <div>
                                          <label class="form-control-label">Variant Unit Name <span class="tx-danger">*</span></label>
                                      </div>
                                      <div>
                                          
                                          <select class="form-control select2 select2-show-search w-full" style="width: 100%;" name="variants[0][unit]"
                                                  data-placeholder="Choose Unit">
                                            <option label="Choose Unit">Choose Unit</option>
                                            <option label="Pcs">Pcs</option>
                                            <option label="Sft">Sft</option>
                                            <option label="Kg">Kg</option>
                                            <option label="Pound">Pound</option>
                                            <option label="Ton">Ton</option>
                                            <option label="Pair">Pair</option>
                                            <option label="Rol">Rol</option>
                                            <option label="Feet">Feet</option>
                                            <option label="Metre">Metre</option>
                                            <option label="Centi Metre">Centi Metre</option>
                                            <option label="Mili Metre">Mili Metre</option>
                                            <option label="Box">Box</option>
                                            <option label="Please Ask For Price">Please Contact For Price</option>
                                          </select>
                                          </div>
                                     
                                    </div>
                                  </div>
                                  <div class="col-md-4">
                                    <div class="form-group">
                                      <label class="form-control-label">Variant Price <span class="tx-danger">*</span></label>
                                      <input class="form-control" type="text" name="variants[0][price]"
                                              placeholder="Enter Variant Price">
                                      
                                    </div>
                                  </div>
                                  <div class="col-md-4" style="display: flex">
                                    <div class="form-group"  style="width: 75%">
                                      <label class="form-control-label">Convert Unit Value<span class="tx-danger">*</span></label>
                                      <input class="form-control" type="text" name="variants[0][convert_value]"
                                             placeholder="Enter Convert Unit Value">
                                      
                                    </div>
                                    <div class="ml-2" style="width: 25%">
                                        
                                        <button class="btn btn-success" onClick="addMoreVariant()" style="margin-top: 35px;" type="button">Add More</button>
                                      </div>
                                  </div>
                                  
                            
                                </div>
                             @endif
                             </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-control-label">Product Short Description<span
                                            class="tx-danger">*</span></label>
                                    <textarea name="short_desc_en" id="short-description">{{ $product->short_desc_en }}</textarea>
                                    @error('short_desc_en')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-control-label">Product Full Description<span
                                            class="tx-danger">*</span></label>
                                    <textarea name="full_desc_en" id="full-description">{{ $product->full_desc_en }}</textarea>
                                    @error('full_desc_en')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="form-layout-footer col-12">
                                <button class="btn btn-info text-center">Save</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('scripts')
    <script src="{{ asset('assets/backend/js/axios.min.js') }}" type="text/javascript"></script>
    @include('components.tinymce.tinymce', [
        'selector' => 'short-description',
    ])
    <script type="text/javascript">
        tinymce.init({
            selector: "#full-description",
            
            plugins: [
                'advlist', 'autolink', 'link', 'image', 'lists', 'charmap', 'print', 'preview', 'hr', 'media',
                'anchor', 'pagebreak ', 'wordcount', 'code', 'fullscreen',
                'save', 'table', 'contextmenu', 'directionality', 'emoticons', 'template', 'paste', 'textcolor'
            ],
            toolbar: [
                'formatselect | fontsizeselect | bold | italic | underline |  bullist | numlist | alignleft | aligncenter | alignright | alignjustify  | blockquote | link | unlink |image | table |  forecolor | removeformat | charmap | copy | cut | paste | liquickimageneheight | redo | undo | spellchecker | imageoptions | code',
            ],
            height: 500,
            branding: false,
            menubar: false,
            image_class_list: [{
                title: 'Responsive',
                value: 'img-responsive'
            }],
            mobile: {
                resize: true
            },
            //  fontsize_formats: "8pt 9pt 10pt 11pt 12pt 14pt 18pt 24pt 30pt 36pt 48pt 60pt 72pt 96pt",
        });
        //Product Thumbnail Preview
        var loadFile = function(event) {
            var reader = new FileReader();
            reader.onload = function() {
                var output = document.getElementById('thumbnail-preview');
                output.src = reader.result;
            };
            reader.readAsDataURL(event.target.files[0]);
        };
        $(document).ready(function() {

            $('#is-unit-variant').change(function(){
                if(this.checked){
                    $('#unit-variants').removeClass('d-none')
                }else{
                    $('#unit-variants').addClass('d-none')
                }
            })
            $('#attribute').on('change', function() {
                let attributes = $(this).val();
                let productAttributes = '';
                attributes.forEach(function(item) {
                    productAttributes += `<div class="col-md-4 my-1">
                                            <div class="form-group">
                                                <label class="form-control-label" for="${item}">${item}</label>
                                                <input class="form-control" type="text" name="product_attributes[${item}]"  placeholder="Enter ${item}"  value='' id="${item}" data-role="tagsinput">
                                                
                                            </div>
                                        </div>`
                });

                $('#product-attributes').html(productAttributes);

            })


            //Get Sub Category Using Axios
            $('#category').on('change', function() {
                let categoryId = $(this).val();
                let url = "/admin/sub/sub-category/filter/" + categoryId;
                axios.get(url)
                    .then(function(response) {
                        if (response.status == 200) {
                            let datas = response.data;
                            $('#sub-category').empty();
                            $('#sub-sub-category').empty();
                            $.each(datas, function(id, subCategory) {
                                $('#sub-category').append(
                                    '<option value="' + subCategory.id + '">' + subCategory
                                    .subcategory_name_en + '</option>'
                                );
                            })
                        }
                    }).catch(function(error) {

                    })
            });

            //Get Sub Sub Caegory Using 
            $('#sub-category').on('change', function() {
                let subCategoryId = $(this).val();
                let url = "/admin/sub/sub/sub-category/filter/" + subCategoryId;
                axios.get(url)
                    .then(function(response) {
                        if (response.status == 200) {
                            let datas = response.data;
                            $('#sub-sub-category').empty();
                            $.each(datas, function(id, subSubCategory) {
                                $('#sub-sub-category').append(
                                    '<option value="' + subSubCategory.id + '">' +
                                    subSubCategory.subsubcategory_name_en + '</option>'
                                );
                            })
                        }
                    }).catch(function(error) {

                    })
            });
            $('.text-editor').summernote({
                height: 150
            })
            $('.select2').select2({
                minimumResultsForSearch: Infinity
            });

            $('.select2-show-search').select2({
                minimumResultsForSearch: ''
            });

            $('.select2-tag').select2({
                tags: true,
                tokenSeparators: [',', ' ']
            });
        });

 function addMoreVariant(){
            
            const totalVariant = $('#unit-variants').children().length
          
            
            const varitant = `<div class="row">
                            
                                  <div class="col-md-4">
                                    <div class="form-group">
                                      <div>
                                          <label class="form-control-label">Variant Unit Name <span class="tx-danger">*</span></label>
                                      </div>
                                      <div>
                                          
                                          <select class="form-control select2 select2-show-search w-full" style="width: 100%;" name="variants[${totalVariant}][unit]"
                                                  data-placeholder="Choose Unit">
                                            <option label="">Choose Unit</option>
                                            <option label="Pcs">Pcs</option>
                                            <option label="Sft">Sft</option>
                                            <option label="Kg">Kg</option>
                                            <option label="Pound">Pound</option>
                                            <option label="Ton">Ton</option>
                                            <option label="Pair">Pair</option>
                                            <option label="Rol">Rol</option>
                                            <option label="Feet">Feet</option>
                                            <option label="Metre">Metre</option>
                                            <option label="Centi Metre">Centi Metre</option>
                                            <option label="Mili Metre">Mili Metre</option>
                                            <option label="Box">Box</option>
                                            <option label="Please Ask For Price">Please Contact For Price</option>
                                          </select>
                                          </div>
                                      
                                    </div>
                                  </div>
                                  <div class="col-md-4">
                                    <div class="form-group">
                                      <label class="form-control-label">Variant Price <span class="tx-danger">*</span></label>
                                      <input class="form-control" type="text" name="variants[${totalVariant}][price]"
                                              placeholder="Enter Variant Price">
                                     
                                    </div>
                                  </div>
                                  <div class="col-md-4" style="display: flex">
                                    <div class="form-group"  style="width: 75%">
                                      <label class="form-control-label">Convert Unit Value<span class="tx-danger">*</span></label>
                                      <input class="form-control" type="text" name="variants[${totalVariant}][convert_value]"
                                             placeholder="Enter Convert Unit Value">
                                      
                                    </div>
                                    <div class="ml-2" style="width: 25%">
                                        <button class="btn btn-danger remove-unit-variant" style="margin-top: 35px;" type="button">Remove</button>
                                      </div>
                                  </div>
                                  
                            
                                </div>`
                                
            $('#unit-variants').append(varitant)
                                
                                
        }
        @if (session()->has('error'))
            Swal.fire({
                icon: 'error',
                text: "{{ session('error') }}"
            })
        @endif
        $(document).ready(function() {
          $(document).on('click', '.remove-unit-variant', function() {
            $(this).closest('.row').remove();
          });
        });
    </script>
@endsection
