@extends('layouts.admin-layout')
@section('title', 'Deals')
@section('deal', 'active')
@section('content')
    <nav class="breadcrumb sl-breadcrumb">
        <a class="breadcrumb-item" href="{{ route('admin.dashboard') }}">{{ __('Dashboard') }}</a>
        <span class="breadcrumb-item active">Deals</span>
    </nav>

    <div class="sl-pagebody">
        <div class="row row-sm">
            <div class="col-md-12">
                <div class="card pd-10 pd-sm-20">
                    <div class="row mb-2">
                        <div class="col-md-6">
                            <h6 class="card-body-title">All Deal</h6>
                        </div>
                        <div class="col-md-6 text-right">
                            <a href="{{ route('admin.deal.create') }}" class="btn btn-primary">Add New</a>
                        </div>
                    </div>
                    <div class="table-wrapper">
                        <table class="table display responsive nowrap" id="brand-table">
                            <thead>
                                <tr>
                                    <th class="wd-10p">SI</th>
                                    <th class="wd-15p">Deal Name</th>
                                    <th class="wd-15p">Start Date</th>
                                    <th class="wd-15p">End Date</th>
                                    <th class="wd-15p">Expiration</th>
                                    <th class="wd-10p">Status</th>
                                    <th class="wd-40p">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @php
                                    $start = 0;
                                @endphp
                                @forelse ($deals as $deal)
                                    <tr>
                                        <td>{{ ++$start }}</td>
                                        <td>{{ $deal->deal_name }}</td>
                                        <td>
                                            {{ Carbon\Carbon::parse($deal->start_date)->format('D d-m-Y') }}
                                        </td>
                                        <td>
                                            {{ Carbon\Carbon::parse($deal->end_date)->format('D d-m-Y') }}
                                        </td>
                                        <td>
                                            @if (Carbon\Carbon::parse($deal->end_date) > Carbon\Carbon::now())
                                                <span class="badge badge-primary">Not Expired</span>
                                            @else
                                                <span class="badge badge-primary">Expired</span>
                                            @endif
                                        </td>
                                        <td>
                                            @if ($deal->status == 'active')
                                                <span class="badge badge-success">Active</span>
                                            @else
                                                <span class="badge badge-danger">Deactive</span>
                                            @endif
                                        </td>
                                        <td>
                                            <a href="{{ route('admin.deal.edit', $deal->id) }}" class="btn btn-primary"
                                                title="Edit DEAL">Edit</a>
                                            <a href="{{ route('admin.deal.delete', $deal->id) }}" class="btn btn-danger"
                                                id="delete" title="Delete Deal">Delete</a>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="6">No Data Found</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('scripts')
    <script type="text/javascript">
        $('#brand-table').DataTable({
            responsive: true,
            language: {
                searchPlaceholder: 'Search...',
                sSearch: '',
                lengthMenu: '_MENU_ items/page',
            }
        });
        $(document).on('click', '#delete', function(e) {
            e.preventDefault();
            let link = $(this).attr('href');
            Swal.fire({
                title: "Are your sure want to Delete !",
                text: 'Once deleted, you will not be able to recover',
                icon: 'warning',
                showDenyButton: true,
                showCancelButton: true,
                confirmButtonText: 'Delete',
                denyButtonText: `Don't Delete`,
            }).then((willDelete) => {
                if (willDelete.isConfirmed) {
                    window.location.href = link;
                } else {
                    Swal.fire('Your Deal is safe', '', 'info')
                }
            })
        });
        @if (session()->has('success'))
            Swal.fire({
                icon: 'success',
                text: "{{ session('success') }}"
            })
        @endif
        @if (session()->has('error'))
            Swal.fire({
                icon: 'error',
                text: "{{ session('error') }}"
            })
        @endif
    </script>
@endsection
