@extends('layouts.admin-layout')
@section('title', 'Add New Deal')
@section('deal', 'active')
@section('content')
    <nav class="breadcrumb sl-breadcrumb">
        <a class="breadcrumb-item" href="{{ route('admin.dashboard') }}">{{ __('Dashboard') }}</a>
        <a class="breadcrumb-item" href="{{ route('admin.coupon') }}">{{ __('Deal') }}</a>
        <span class="breadcrumb-item active">Create Deal</span>
    </nav>

    <div class="sl-pagebody">
        <div class="row row-sm">
            <div class="col-md-12">
                <div class="card pd-10 pd-sm-20">
                    <h6 class="card-body-title">Create Deal</h6>
                    <form action="{{ route('admin.deal.store') }}" class="form-layout" method="POST"
                        enctype="multipart/form-data">
                        @method('POST')
                        @csrf
                        <div class="form-group">
                            <label class="form-control-label">Deal Name: <span class="tx-danger">*</span></label>
                            <input class="form-control" type="text" name="deal_name" placeholder="Enter Deal Name">
                            @error('deal_name')
                                <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>
                        <div class="form-group">
                            <label class="form-control-label">Deal Type: <span class="tx-danger">*</span></label>
                            <select name="deal_type" id="deal-type" class="form-control">
                                <option value="hot_deals">Hot Deal</option>
                                <option value="featured">Feature Deal</option>
                                <option value="special_offer">Special Offer</option>
                                <option value="special_deals">Special Deal</option>
                            </select>
                            @error('hot_deals')
                                <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>
                        <div class="form-group">
                            <label class="form-control-label">Start Date: <span class="tx-danger">*</span></label>
                            <input class="form-control" type="date" name="start_date">
                            @error('start_date')
                                <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>
                        <div class="form-group">
                            <label class="form-control-label">End Date: <span class="tx-danger">*</span></label>
                            <input class="form-control" type="date" name="end_date"
                                min="{{ Carbon\Carbon::now()->format('Y-m-d') }}">
                            @error('start_date')
                                <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>
                        <div class="form-group">
                            <label class="form-control-label">Deal Image (1*1.4): <span class="tx-danger">*</span></label>
                            <input class="form-control" type="file" name="image">
                            @error('image')
                                <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>
                        <div class="form-group">
                            <label class="form-control-label">Status: <span class="tx-danger">*</span></label>
                            <select name="status" id="deal-type" class="form-control">
                                <option value="active">Active</option>
                                <option value="deactive">Deactive</option>
                            </select>
                            @error('status')
                                <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>
                        <div class="form-layout-footer">
                            <button class="btn btn-info mg-r-5">Save</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('scripts')
    <script type="text/javascript">
        @if (session()->has('error'))
            Swal.fire({
                icon: 'error',
                text: "{{ session('error') }}"
            })
        @endif
    </script>
@endsection
