@extends('layouts.admin-layout')
@section('title','Edit Category')
@section('category','active show-sub')
@section('all-category','active')
@section('content')
<nav class="breadcrumb sl-breadcrumb">
  <a class="breadcrumb-item" href="{{route('admin.dashboard')}}">{{__('Dashboard')}}</a>
  <a class="breadcrumb-item" href="{{route('admin.brand')}}">{{__('Category')}}</a>
  <span class="breadcrumb-item active">Edit Category</span>
</nav>

<div class="sl-pagebody">
    <div class="row row-sm">
        <div class="col-md-12">
            <div class="card pd-10 pd-sm-20">
                <h6 class="card-body-title">Edit Category</h6>
                <form action="{{url('admin/category/update/'.$category->id)}}" class="form-layout" method="POST" enctype="multipart/form-data">
                    @method('PUT')
                    @csrf
                    <div class="form-group">
                        <label class="form-control-label">Category Name : <span class="tx-danger">*</span></label>
                        <input class="form-control" type="text" name="category_name_en" value="{{$category->category_name_en}}" placeholder="Enter Category Name">
                        @error('category_name_en')
                            <span class="text-danger">{{$message}}</span>
                        @enderror
                    </div>
                    <div class="form-group">
                        <label class="form-control-label">Position: <span class="tx-danger">*</span></label>
                        <input class="form-control" type="text" name="category_name_bn" value="{{$category->category_name_bn}}" placeholder="Enter Category Position">
                        @error('category_name_bn')
                            <span class="text-danger">This Position Already Taken</span>
                        @enderror
                    </div>
                    
                    <div class="form-group">
                        <label class="form-control-label">Category Image(1*1): <span class="tx-danger">*</span></label>
                        <input class="form-control-file" type="file" name="category_icon">
                        <input class="" type="hidden" name="category_icon_old" value="{{$category->category_icon}}">
                        @error('category_icon')
                            <span class="text-danger">{{$message}}</span>
                        @enderror
                    </div>
                    <div class="form-group">
                        <input class="" type="checkbox" name="show_on_navbar" id="show-navbar" {{$category->show_on_navbar==true ? 'checked':''}} />
                        <label class="form-control-label" for="show-navbar">Show On Navbar</label>
                        
                        @error('show_on_navbar')
                            <span class="text-danger">{{$message}}</span>
                        @enderror
                    </div>
                    <div class="form-layout-footer">
                        <button class="btn btn-info mg-r-5">Save</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection
@section('scripts')
    <script type="text/javascript">
        
        @if (session()->has('error'))
            Swal.fire({
                icon:'error',
                text:"{{session('error')}}"
            })
        @endif
    </script>
@endsection