@extends('layouts.admin-layout')
@section('title', 'Product Attribute')
@section('product', 'active show-sub')
@section('attribute', 'active')
@section('content')
    <style>
        .modal.show .modal-dialog {
            width: 40%;
        }
    </style>
    <nav class="breadcrumb sl-breadcrumb">
        <a class="breadcrumb-item" href="{{ route('admin.dashboard') }}">{{ __('Dashboard') }}</a>
        <span class="breadcrumb-item active">Brand</span>
    </nav>

    <div class="sl-pagebody">
        <div class="row row-sm">
            <div class="col-md-8">
                <div class="card pd-10 pd-sm-20">
                    <h6 class="card-body-title">All Attributes</h6>
                    <div class="table-wrapper">
                        <table class="table display responsive nowrap" id="brand-table">
                            <thead>
                                <tr>
                                    <th>SI</th>
                                    <th>Attribute Name</th>
                                    <th>Attribute Priyority</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @php
                                    $start = 0;
                                @endphp
                                @forelse ($attributes as $attribute)
                                    <tr>
                                        <td>{{ ++$start }}</td>
                                        <td>{{ $attribute->name }}</td>
                                        <td>{{ $attribute->priyority }}</td>

                                        <td>

                                            <a href="#" class="btn btn-primary edit-btn" title="Edit Attribute"
                                                data-toggle="modal" data-target="#edit-attribute"
                                                data-id="{{ $attribute->id }}">Edit</a>
                                            <a href="{{ route('product.attribute.delete' , $attribute->id) }}"
                                                class="btn btn-danger" id="delete" title="Delete Brand">Delete</a>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="4">No Data Found</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="card pd-10 pd-sm-20">
                    <h6 class="card-body-title">Add New Attribute</h6>
                    <form action="{{ route('product.attribute.store') }}" class="form-layout" method="POST">
                        @csrf

                        <div class="form-group">
                            <label class="form-control-label">Attribute Name: <span class="tx-danger">*</span></label>
                            <input class="form-control" type="text" name="name" value="{{ old('name') }}"
                                placeholder="Enter Attribute Name" required>
                            @error('name')
                                <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>
                        <div class="form-group">
                            <label class="form-control-label">Attribute Priyority(Ex:5): <span
                                    class="tx-danger">*</span></label>
                            <input class="form-control" type="text" name="priyority" value="{{ old('priyority') }}"
                                placeholder="Enter Attribute Pryority" required>
                            @error('priyority')
                                <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>

                        <div class="form-layout-footer">
                            <button class="btn btn-info mg-r-5">Save</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

@endsection
@push('modal')
    <!-- edit modal  -->
    <div class="modal fade show" id="edit-attribute">
        <div class="modal-dialog modal-lg" role="document">
            <form action="" method="POST" id="edit-attribute-form">
                @method('PUT')
                @csrf
                <div class="modal-content bd-0">
                    <div class="modal-header pd-y-20 pd-x-25">
                        <h6 class="tx-14 mg-b-0 tx-uppercase tx-inverse tx-bold">Edit Attribute</h6>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">×</span>
                        </button>
                    </div>
                    <div class="modal-body pd-25">
                        <div class="form-group">
                            <input type="hidden" class="attribute-id" value="" name="attribute_id">
                            <label class="form-control-label" for="attribute-name">Attribute Name: <span
                                    class="tx-danger">*</span></label>
                            <input class="attribute-name form-control" type="text" name="name" value=""
                                required>
                            @error('name')
                                <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>
                        <div class="form-group">
                            <label class="form-control-label" for="attribute-priyority">Attribute Priyority(Ex:5): <span
                                    class="tx-danger">*</span></label>
                            <input class="attribute-priyority form-control" type="text" name="priyority" value=""
                                placeholder="Enter Attribute Pryority" required>
                            @error('priyority')
                                <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-info pd-x-20" id="update-btn">Update</button>
                        <button type="button" class="btn btn-secondary pd-x-20" data-dismiss="modal">Close</button>
                    </div>
                </div>
            </form>

        </div><!-- modal-dialog -->
    </div><!-- modal -->
@endpush
@section('scripts')
    <script type="text/javascript">
        $('#brand-table').DataTable({
            responsive: true,
            language: {
                searchPlaceholder: 'Search...',
                sSearch: '',
                lengthMenu: '_MENU_ items/page',
            }
        });
        $('.edit-btn').on('click', function() {
            let id = $(this).attr('data-id');
            let url = "/admin/attribute/edit/" + id;

            axios.get(url).then(function(response) {
                if (response.status == 200) {
                    let attribute = response.data.data;
                    $('.attribute-id').val(attribute.id);
                    $('.attribute-name').val(attribute.name);
                    $('.attribute-priyority').val(attribute.priyority);
                }
            }).catch(function(error) {
                console.log(error)
            })
        });
        $('#update-btn').on('click', function() {
            let id = $("#attribute-id").val();
            let url = "/admin/attribute/update/" + id;

            $("#edit-attribute-form").attr('action', url);


        });

        $(document).on('click', '#delete', function(e) {
            e.preventDefault();
            let link = $(this).attr('href');
            Swal.fire({
                title: "Are your sure want to Delete !",
                text: 'Once deleted, you will not be able to recover',
                icon: 'warning',
                showDenyButton: true,
                showCancelButton: true,
                confirmButtonText: 'Delete',
                denyButtonText: `Don't Delete`,
            }).then((willDelete) => {
                if (willDelete.isConfirmed) {
                    window.location.href = link;
                } else {
                    Swal.fire('Your Brand is safe', '', 'info')
                }
            })
        });
        @if (session()->has('success'))
            Swal.fire({
                icon: 'success',
                text: "{{ session('success') }}"
            })
        @endif
        @if (session()->has('error'))
            Swal.fire({
                icon: 'error',
                text: "{{ session('error') }}"
            })
        @endif
    </script>
@endsection
