@extends('layouts.admin-layout')
@section('title','Edit Admin Role')
@section('admins','active show-sub')
@section('add-admins','active')
@section('content')
<nav class="breadcrumb sl-breadcrumb">
  <a class="breadcrumb-item" href="{{route('admin.dashboard')}}">{{__('Dashboard')}}</a>
  <a class="breadcrumb-item" href="{{route('roles.index')}}">{{__('Admin')}}</a>
  <span class="breadcrumb-item active">Edit Admin Role</span>
</nav>

<div class="sl-pagebody">
    <div class="row row-sm">
        <div class="col-md-12">
            <div class="card pd-10 pd-sm-20">
                <h6 class="card-body-title">Edit Admin Role</h6>
                <form action="{{route('admins.update',$admin->id)}}" class="form-layout" method="POST" >
                    @csrf
                    @method('PUT')
                    
                    <div class="form-group">
                        <p class="form-control-label">Name : {{$admin->name}}</p>
                    </div>
                    
                    <div class="form-group">
                        <p class="form-control-label">Email : {{$admin->email}}</p>
                    </div>
                    
                    <div class="form-group">
                        <p class="form-control-label">Phone : {{$admin->phone}}</p>
                    </div>
                    
                    
                    
                    <div class="form-group">
                        @foreach($roles as $role)
                        <label  style="display: flex;flex-wrap: wrap; align-items:center; justify-content:start; margin: 10px 15px" for="role-{{$role->id}}">
                            <input type="radio" id="role-{{$role->id}}" {{$admin->admin_role_id == $role->id ? 'checked' : ''}} value="{{$role->id}}" name="admin_role_id" style="margin-right: 10px" />
                            <p class="badge badge-success" style="margin-bottom: 0"> {{$role->name}}</p>
                        </label>
                        @endforeach
                        @error('admin_role_id')
                            <p class="text-danger">{{$message}}</p>
                        @enderror
                        
                    </div>
                    
                    
                    <div class="form-layout-footer">
                        <button class="btn btn-info mg-r-5">Save</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection
@section('scripts')
    <script type="text/javascript">
        //Product Thumbnail Preview
        var loadFile = function(event) {
        var reader = new FileReader();
            reader.onload = function(){
                var output = document.getElementById('preview');
                output.src = reader.result;
                };
            reader.readAsDataURL(event.target.files[0]);
        };
        @if (session()->has('error'))
            Swal.fire({
                icon:'error',
                text:"{{session('error')}}"
            })
        @endif
    </script>
@endsection