@extends('layouts.admin-layout')
@section('title','Add New admin')
@section('admins','active show-sub')
@section('add-admins','active')
@section('content')
<nav class="breadcrumb sl-breadcrumb">
  <a class="breadcrumb-item" href="{{route('admin.dashboard')}}">{{__('Dashboard')}}</a>
  <a class="breadcrumb-item" href="{{route('roles.index')}}">{{__('Admin')}}</a>
  <span class="breadcrumb-item active">Add Admin</span>
</nav>

<div class="sl-pagebody">
    <div class="row row-sm">
        <div class="col-md-12">
            <div class="card pd-10 pd-sm-20">
                <h6 class="card-body-title">Add Role</h6>
                <form action="{{route('admins.store')}}" class="form-layout" method="POST" >
                    @csrf
                    
                    <div class="form-group">
                        <label class="form-control-label">Name : <span class="tx-danger">*</span></label>
                        <input class="form-control" type="text" name="name" value="{{old('name')}}" placeholder="Enter Name">
                        @error('name')
                            <span class="text-danger">{{$message}}</span>
                        @enderror
                    </div>
                    
                    <div class="form-group">
                        <label class="form-control-label">Email : <span class="tx-danger">*</span></label>
                        <input class="form-control" type="text" name="email" value="{{old('email')}}" placeholder="Enter email">
                        @error('email')
                            <span class="text-danger">{{$message}}</span>
                        @enderror
                    </div>
                    
                    <div class="form-group">
                        <label class="form-control-label">Phone : <span class="tx-danger">*</span></label>
                        <input class="form-control" type="text" name="phone" value="{{old('phone')}}" placeholder="Enter Phone">
                        @error('phone')
                            <span class="text-danger">{{$message}}</span>
                        @enderror
                    </div>
                    
                    <div class="form-group">
                        <label class="form-control-label">Password : <span class="tx-danger">*</span></label>
                        <input class="form-control" type="text" name="password" value="{{old('password')}}" placeholder="Enter Password">
                        @error('password')
                            <span class="text-danger">{{$message}}</span>
                        @enderror
                    </div>
                    
                    <div class="form-group">
                        @foreach($roles as $role)
                        <label  style="display: flex;flex-wrap: wrap; align-items:center; justify-content:start; margin: 10px 15px" for="role-{{$role->id}}">
                            <input type="radio" id="role-{{$role->id}}" value="{{$role->id}}" name="admin_role_id" multiple style="margin-right: 10px" />
                            <p class="badge badge-success" style="margin-bottom: 0"> {{$role->name}}</p>
                        </label>
                        @endforeach
                        @error('admin_role_id')
                            <p class="text-danger">{{$message}}</p>
                        @enderror
                        
                    </div>
                    
                    
                    <div class="form-layout-footer">
                        <button class="btn btn-info mg-r-5">Save</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection
@section('scripts')
    <script type="text/javascript">
        //Product Thumbnail Preview
        var loadFile = function(event) {
        var reader = new FileReader();
            reader.onload = function(){
                var output = document.getElementById('preview');
                output.src = reader.result;
                };
            reader.readAsDataURL(event.target.files[0]);
        };
        @if (session()->has('error'))
            Swal.fire({
                icon:'error',
                text:"{{session('error')}}"
            })
        @endif
    </script>
@endsection