<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateOrderItemsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create( 'order_items', function ( Blueprint $table )
        {
            $table->id();
            $table->unsignedBigInteger( 'order_id' );
            $table->foreign( 'order_id' )->references( 'id' )->on( 'orders' )->cascadeOnDelete();
            $table->unsignedBigInteger( 'product_id' );
            $table->string( 'product_name' )->nullable();
            $table->string( 'color' )->nullable();
            $table->string( 'size' )->nullable();
            $table->integer( 'qty' )->nullable();
            $table->float( 'price', 8, 2 )->nullable();
            $table->timestamps();
        } );
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists( 'order_items' );
    }
}
