<?php

namespace App\View\Composers;

use App\Models\Deal;
use App\Models\Product;
use Illuminate\Support\Facades\Auth;
use Illuminate\View\View;


class SpecialOfferComposer
{

    /**
     * Bind data to the view.
     *
     * @param  \Illuminate\View\View  $view
     * @return void
     */
    
    
    public function compose( View $view )
    {
        $specialOffer=Deal::where('deal_type','special_offer')->where('status','active')->first();
        
        $specialOffeAvaliable=\Carbon\Carbon::parse($specialOffer->end_date)->format('Y-m-d') >= \Carbon\Carbon::now()->format('Y-m-d');
        
        if($specialOffeAvaliable){
            $products = Product::with(['reviews' => function ($status)
            {
                $status->approve();
            },
            ])->active()->where('special_offer', 1)->take(8)->get();
        }else {
            $products=null;
        }
        $view->with( ['products'=>$products,'specialOffeAvaliable'=>$specialOffeAvaliable] );
    }
}