<?php

namespace App\Providers;

use App\View\Composers\AvatarComposer;
use App\View\Composers\HotDealComposer;
use App\View\Composers\SpecialOfferComposer;
use App\View\Composers\SpecialDealComposer;
use App\View\Composers\FeaturedOfferComposer;
use App\View\Composers\FooterPageComposer;
use Illuminate\Support\Facades\View;
use Illuminate\Support\ServiceProvider;

class ViewServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        //
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        View::composer('components.mobile.profile', AvatarComposer::class);
        View::composer('admin.inc.header', AvatarComposer::class);
        View::composer('frontend.inc.footer', FooterPageComposer::class);
        View::composer('components.deals.hot-deal', HotDealComposer::class);
        View::composer('components.deals.special-offer', SpecialOfferComposer::class);
        View::composer('components.deals.special-deal', SpecialDealComposer::class);
        View::composer('components.deals.feature-offer', FeaturedOfferComposer::class);
    }
}