<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;

class Permission extends Model
{
    use HasFactory;
    
    protected $fillable = ['name'];
    
    
    public function adminRoles(): BelongsToMany
    {
        return $this->belongsToMany(AdminRole::class, 'role_permission');
    }
}
