<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Category extends Model
{
    use HasFactory;
    /**
     * The attributes that are mass assignable.
     *
     * @var string[]
     */
    protected $fillable = [
        'category_name_en',
        'category_slug_en',
        'category_name_bn',
        'category_slug_bn',
        'category_icon',
        'show_on_navbar',
    ];

    public function product(): BelongsTo
    {
        return $this->belongsTo(Product::class);
    }
}