<?php

    namespace App\Http\Controllers\User;

    use App\Http\Controllers\Controller;
    use App\Mail\OrderMail;
    use App\Models\Brand;
    use App\Models\Coupon;
    use App\Models\Option;
    use App\Models\Order;
    use App\Models\OrderItem;
    use App\Models\Product;
    use App\Models\ShippingAddress;
    use App\Models\ShippingCost;
    use App\Models\State;
    use Illuminate\Http\Request;
    use Illuminate\Support\Carbon;
    use Illuminate\Support\Facades\Auth;
    use Illuminate\Support\Facades\Mail;
    use Illuminate\Support\Facades\Session;

    class BuyController extends Controller
    {
        public function index(Request $request)
        {

            $color   = $request->color;
            $size    = $request->size;
            $qty     = $request->quantity ?? 1;
            $unit     = $request->unit;
            $product = Product::findOrFail($request->product_id);
            $order   = [
                'product_id'   => $request->product_id,
                'product_name' => $product->product_name_en,
                'price'        => intval($request->price),
                'color'        => $color,
                'size'         => $size,
                'qty'          => $qty,
                'unit'         => $unit,
                'thickness'    => $request->thickness,
            ];
            
            if(!Auth::check()){
                session()->put('intended_url',route('user.buy.checkout'));
            }
            
            Session::put('order', $order);
            return redirect()->route('user.buy.checkout');
            
            // $brands = Brand::all();
            // return view('user.buy.buy', compact('product', 'color', 'size', 'qty', 'brands'));
        }
        //Apply Coupon
        public function applyCoupon(Request $request)
        {
            $couponCode = $request->coupon_code;
            $coupon     = Coupon::where('coupon_code', $couponCode)->first();

            if ($coupon)
            {
                if ($coupon->validity >= Carbon::now()->format('Y-m-d'))
                {
                    $productId      = Session::get('order')['product_id'];
                    $qty            = Session::get('order')['qty'];
                    $product        = Product::findOrFail($productId);
                    $amount         = $product->discount_price * intval($qty);
                    $discount       = $coupon->discount;
                    $discountAmount = ($amount * $discount) / 100;
                    $totalAmount    = $amount - $discountAmount;
                    Session::put('coupon', [
                        'couponCode'     => $couponCode,
                        'couponDiscount' => $coupon->discount,
                        'discount'       => $discountAmount,
                        'subtotal'       => $amount,
                        'totalAmount'    => $totalAmount,
                    ]);
                    return response()->json(['success' => "{$couponCode} Applied Successfully"]);
                }
                else
                {
                    return response()->json(['error' => 'Your Coupon is Expired']);
                }
            }
            else
            {
                return response()->json(['error' => 'Your Coupon is Invalid']);
            }
        }
        //Get Coupon Discount
        public function couponDiscount()
        {
            if (Session::has('coupon'))
            {
                $productId = Session::get('order')['product_id'];
                $qty       = Session::get('order')['qty'];
                $product   = Product::findOrFail($productId);
                $subtotal  = $product->discount_price * $qty;
                $coupon    = session()->get('coupon')['couponCode'];
                $discount  = session()->get('coupon')['discount'];
                $total     = session()->get('coupon')['totalAmount'];
                return response()->json([
                    'subtotal'    => $subtotal,
                    'coupon'      => $coupon,
                    'discount'    => $discount,
                    'totalAmount' => $total,
                ]);
            }
            else
            {
                $productId = Session::get('order')['product_id'];
                $qty       = Session::get('order')['qty'];
                $product   = Product::findOrFail($productId);
                $total     = $product->discount_price * $qty;
                return response()->json([
                    'total' => $total,
                ]);
            }
        }
        //Remove Coupon
        public function removeCoupon()
        {

            Session::forget('coupon');
            return response()->json(['success' => 'Coupon successfully Removed']);

        }

        public function checkout()
        {
            $id              = Session::get('order')['product_id'];
            $qty             = Session::get('order')['qty'];
            $color           = Session::get('order')['color'];
            $price           = Session::get('order')['price'];
            $product         = Product::findOrFail($id);
            $costs           = ShippingCost::latest()->get();
            $shippingAddress = ShippingAddress::where('user_id', '=', Auth::id())->get();
            if (!Session::has('coupon')) {

                $total = intval($product->discount_price) * $qty;
                return view('user.buy.checkout', compact('product', 'total', 'qty','color','costs', 'shippingAddress','price'));
                
            }
            
            $total    = Session::get('coupon')['totalAmount'];
            $subtotal = Session::get('coupon')['subtotal'];
            return view('user.buy.checkout', compact('product', 'subtotal', 'total', 'costs', 'shippingAddress','price'));
        }
        //
        public function storeShippingInfo(Request $request)
        {

            if (empty($request->address_id))
            {
                $request->validate([
                    'name'           => 'required',
                    'email'          => 'required',
                    'phone'          => 'required',
                    'division_id'   => 'required',
                    'district_id'    => 'required',
                    'state_id'       => 'required',
                    'address1'       => 'required',
                    'address2'       => 'nullable',
                    'post_code'      => 'nullable',
                    'notes'          => 'nullable',
                    'payment_method' => 'required',
                    'shipping_cost'  => 'nullable',
                ]);
            }

            try {
                if ($request->address_id) {
                    $address = ShippingAddress::findOrFail($request->address_id);

                    $shippingInfo                   = [];
                    $shippingInfo['name']           = $address->name;
                    $shippingInfo['email']          = $address->email;
                    $shippingInfo['phone']          = $address->phone;
                    $shippingInfo['shipping_cost']  = 0;
                    $shippingInfo['division_id']    = $address->division_id;
                    $shippingInfo['district_id']    = $address->district_id;
                    $shippingInfo['state_id']       = $address->state_id;
                    $shippingInfo['address1']       = $address->address1;
                    $shippingInfo['address2']       = $address->address2;
                    $shippingInfo['post_code']      = $address->post_code;
                    $shippingInfo['notes']          = $request->notes;
                    $shippingInfo['payment_method'] = $request->payment_method;
                }
                else {

                    if ($request->save_address === 'on') {

                        ShippingAddress::create([
                            'user_id'       => Auth::id(),
                            'name'          => $request->name,
                            'email'         => $request->email,
                            'phone'         => $request->phone,
                            'shipping_cost' => $request->shipping_cost ? $request->shipping_cost : 0,
                            'address_1'     => $request->address1,
                            'address_2'     => $request->address2,
                            'division_id'   => $request->division_id,
                            'district_id'   => $request->district_id,
                            'state_id'      => $request->state_id,
                            'post_code'     => $request->post_code,
                        ]);
                    }
                    $shippingInfo                   = [];
                    $shippingInfo['name']           = $request->name;
                    $shippingInfo['email']          = $request->email;
                    $shippingInfo['phone']          = $request->phone;
                    $shippingInfo['division_id']    = $request->division_id;
                    $shippingInfo['district_id']    = $request->district_id;
                    $shippingInfo['state_id']       = $request->state_id;
                    $shippingInfo['address1']       = $request->address1;
                    $shippingInfo['address2']       = $request->address2;
                    $shippingInfo['post_code']      = $request->post_code;
                    $shippingInfo['notes']          = $request->notes;
                    $shippingInfo['payment_method'] = $request->payment_method;
                    $shippingInfo['shipping_cost']  = $request->shipping_cost ? $request->shipping_cost : 0;

                }

                $cartQty         = Session::get('order')['qty'];
                $price           = Session::get('order')['price'];
                $productId       = Session::get('order')['product_id'];
                $product         = Product::findOrfail($productId);
                $cartTotalAmount = intval($cartQty) * intval($price);

                if ($request->payment_method === 'stripe')
                {
                    if (Session::has('coupon'))
                    {
                        $total       = Session::get('coupon')['totalAmount'];
                        $totalAmount = intval($shippingInfo['shipping_cost']) + intval($total);
                        $cartTotal   = intval($shippingInfo['shipping_cost']) + intval($cartTotalAmount);
                        return view('user.buy.stripe', compact('shippingInfo', 'cartTotal', 'totalAmount'));
                    }
                    else
                    {
                        $cartTotal = intval($shippingInfo['shipping_cost']) + intval($cartTotalAmount);
                        return view('user.buy.stripe', compact('shippingInfo', 'cartTotal'));
                    }

                }
                elseif ($request->payment_method === 'paypal')
                {
                    if (Session::has('coupon'))
                    {
                        $total       = Session::get('coupon')['totalAmount'];
                        $totalAmount = intval($shippingInfo['shipping_cost']) + intval($total);
                        $subTotal    = intval($shippingInfo['shipping_cost']) + intval($cartTotalAmount);
                        return view('user.buy.stripe', compact('shippingInfo', 'subTotal', 'totalAmount'));
                    }
                    else
                    {
                        $subTotal = intval($shippingInfo['shipping_cost']) + intval($cartTotalAmount);
                        return view('user.buy.stripe', compact('shippingInfo', 'subTotal'));
                    }

                }
                elseif ($request->payment_method === 'sslcommerz_hosted')
                {
                    if (Session::has('coupon'))
                    {
                        $total       = Session::get('coupon')['totalAmount'];
                        $totalAmount = intval($shippingInfo['shipping_cost']) + intval($total);
                        $subTotal    = intval($shippingInfo['shipping_cost']) + intval($cartTotalAmount);
                        return view('user.buy.sslcommerz', compact('shippingInfo', 'product', 'cartQty', 'subTotal', 'totalAmount'));
                    }
                    else
                    {
                        $subTotal = intval($shippingInfo['shipping_cost']) + intval($cartTotalAmount);
                        return view('user.payment.sslcommerz', compact('shippingInfo', 'product', 'cartQty', 'subTotal'));
                    }
                }
                elseif ($request->payment_method === 'sslcommerz_easy')
                {
                    if (Session::has('coupon'))
                    {
                        $total       = Session::get('coupon')['totalAmount'];
                        $totalAmount = intval($shippingInfo['shipping_cost']) + intval($total);
                        $subTotal    = intval($shippingInfo['shipping_cost']) + intval($cartTotalAmount);
                        return view('user.buy.sslcommerz', compact('shippingInfo', 'product', 'cartQty', 'subTotal', 'totalAmount'));
                    }
                    else
                    {
                        $subTotal = intval($shippingInfo['shipping_cost']) + intval($cartTotalAmount);
                        return view('user.buy.sslcommerz', compact('shippingInfo', 'product', 'cartQty', 'subTotal'));
                    }
                }
                elseif ($request->payment_method === 'amaarpay')
                {
                    if (Session::has('coupon'))
                    {

                        $total       = Session::get('coupon')['totalAmount'];
                        $totalAmount = intval($shippingInfo['shipping_cost']) + intval($total);
                        $subTotal    = intval($shippingInfo['shipping_cost']) + intval($cartTotalAmount);

                        return view('user.buy.aamarpay', compact('shippingInfo', 'product', 'cartQty', 'subTotal', 'totalAmount'));
                    }
                    else
                    {
                        $subTotal = intval($shippingInfo['shipping_cost']) + intval($cartTotalAmount);

                        return view('user.buy.aamarpay', compact('shippingInfo', 'product', 'cartQty', 'subTotal'));
                    }

                }
                elseif ($request->payment_method === 'cod')
                {
                    if (Session::has('coupon'))
                    {
                        $total             = Session::get('coupon')['totalAmount'];
                        $totalAmount       = intval($shippingInfo['shipping_cost']) + intval($total);
                        $cartTosubTotaltal = intval($shippingInfo['shipping_cost']) + intval($cartTotalAmount);

                        return view('user.buy.cod', compact('shippingInfo', 'product', 'cartQty', 'subTotal', 'totalAmount'));
                    }
                    else
                    {
                        $subTotal = intval($shippingInfo['shipping_cost']) + intval($cartTotalAmount);
                        return view('user.buy.cod', compact('shippingInfo', 'product', 'cartQty', 'subTotal'));
                    }

                }
                else
                {
                    return redirect()->back()->withError('Please Select A Payment Method');
                }
            }
            catch (\Exception$e)
            {
                return redirect()->back()->withError($e->getMessage());
            }

        }
        public function cod(Request $request)
        {

            $state = State::with('district')->findoRFail($request->state_id);
          
            try {
                if (Session::has('coupon')) {
                    $amount   = Session::get('coupon')['totalAmount'] + intval($request->shipping_cost);
                    $discount = Session::get('coupon')['discount'];
                }
                else {
                    $price    = Session::get('order')['price'];
                    $qty      = Session::get('order')['qty'];
                    $amount   = (intval($price) * intval($qty)) + intval($request->shipping_cost);
                    $discount = null;
                }
                  
                $invoice = "Steel-Bazar-" . mt_rand(10000000, 99999999);
                $orderId = Order::insertGetId([
                    'user_id'         => Auth::id(),
                    'division_id'     => $request->division_id,
                    'district_id'     => $request->district_id,
                    'state_id'        => $request->state_id,
                    'address1'        => $request->address1,
                    'address2'        => $request->address2,
                    'name'            => $request->name,
                    'email'           => $request->email,
                    'phone'           => $request->phone,
                    'post_code'       => $request->post_code,
                    'payment_method'  => 'COD',
                    'transaction_id'  => uniqid(),
                    'currency'        => "BDT",
                    'amount'          => $amount,
                    'shipping_cost'   => 0,
                    'coupon_discount' => $discount,
                    'order_number'    => uniqid(),
                    'invoice_no'      => $invoice,
                    'order_date'      => Carbon::now()->format('d F Y'),
                    'order_month'     => Carbon::now()->format('F'),
                    'order_year'      => Carbon::now()->format('Y'),
                    'notes'           => $request->notes,
                    'created_at'      => Carbon::now(),
                ]);

                if (Session::has('order')) {
                    $productId  = Session::get('order')['product_id'];
                    $qty        = Session::get('order')['qty'];
                    $product    = Product::findOrFail($productId);
                    $stockQty   = intval($product->product_quantity_en) - intval($qty);
                    $totalSells = intval($product->sells) + intval($qty);
                    $product->update([
                        'product_quantity_en' => $stockQty,
                        'sells'               => $totalSells,
                    ]);

                    OrderItem::create([
                        'order_id'     => $orderId,
                        'product_id'   => Session::get('order')['product_id'],
                        'product_name' => Session::get('order')['product_name'],
                        'color'        => Session::get('order')['color'],
                        'size'         => Session::get('order')['size'],
                        'qty'          => Session::get('order')['qty'],
                        'price'        => Session::get('order')['price'],
                        'unit'         => Session::get('order')['unit'],
                        'thickness'    => Session::get('order')['thickness'],
                    ]);
                }
                $mailInfo = [
                    'order_id'   => $orderId,
                    'invoice_no' => $invoice,
                    'price'      => $amount,
                ];
                Mail::to($request->email)->send(new OrderMail($mailInfo));
                if (Session::has('coupon')) {
                    Session::forget('coupon');
                }
                if (Session::has('order')) {
                    Session::forget('order');
                }

                return redirect()->route('user.order.all')->withSuccess('Your Order has placed successfully');
            }
            catch (\Exception$e)
            {
                return redirect()->back()->withError($e->getMessage());
            }

        }
        
        public function stripe(Request $request)
        {
            if (Session::has('coupon'))
            {
                $totalAmount = Session::get('coupon')['totalAmount'];
                $amount      = round(intval($totalAmount) / 85);
                $discount    = Session::get('coupon')['discount'];
            }
            else
            {
                $price    = Session::get('order')['price'];
                $qty      = Session::get('order')['qty'];
                $amount   = (intval($price) * intval($qty)) + intval($request->shipping_cost);
                $discount = null;
            }

            \Stripe\Stripe::setApiKey(env('STRIPE_SECRET'));
            $charge = \Stripe\Charge::create([
                "amount"      => $amount * 100,
                "currency"    => "usd",
                "source"      => $request->stripeToken,
                "description" => "This payment from Manik Mia Account",
                "metadata"    => ["order_id" => uniqid()],
            ]);
            $invoice = "EPEC-" . mt_rand(10000000, 99999999);
            $orderId = Order::insertGetId([
                'user_id'         => Auth::id(),
                'division_id'     => $request->division_id,
                'district_id'     => $request->district_id,
                'state_id'        => $request->state_id,
                'address1'        => $request->address1,
                'address2'        => $request->address2,
                'name'            => $request->name,
                'email'           => $request->email,
                'phone'           => $request->phone,
                'post_code'       => $request->post_code,
                'payment_type'    => $charge->payment_method,
                'payment_method'  => 'Stripe',
                'transaction_id'  => $charge->balance_transaction,
                'currency'        => $charge->currency,
                'amount'          => $amount,
                'shipping_cost'   => $request->shipping_cost,
                'coupon_discount' => $discount,
                'shipping_cost'   => $request->shipping_cost,
                'coupon_discount' => $discount,
                'order_number'    => $charge->metadata->order_id,
                'invoice_no'      => $invoice,
                'order_date'      => Carbon::now()->format('d F Y'),
                'order_month'     => Carbon::now()->format('F'),
                'order_year'      => Carbon::now()->format('Y'),
                'notes'           => $request->notes,
                'created_at'      => Carbon::now(),
            ]);

            if (Session::has('order'))
            {
                $productId  = Session::get('order')['product_id'];
                $qty        = Session::get('order')['qty'];
                $product    = Product::findOrFail($productId);
                $stockQty   = intval($product->product_quantity_en) - intval($qty);
                $totalSells = intval($product->sells) + intval($qty);
                $product->update([
                    'product_quantity_en' => $stockQty,
                    'sells'               => $totalSells,
                ]);
                OrderItem::create([
                    'order_id'     => $orderId,
                    'product_id'   => $productId,
                    'product_name' => Session::get('order')['product_name'],
                    'color'        => Session::get('order')['color'],
                    'size'         => Session::get('order')['size'], 
                    'unit'         => Session::get('order')['unit'],
                    'qty'          => $qty,
                    'price'        => Session::get('order')['price'],
                ]);
            }

            $mailInfo = [
                'order_id'   => $orderId,
                'invoice_no' => $invoice,
                'price'      => $amount,
            ];
            Mail::to($request->email)->send(new OrderMail($mailInfo));
            if (Session::has('coupon'))
            {
                Session::forget('coupon');
            }
            if (Session::has('order'))
            {
                Session::forget('order');
            }

            return redirect()->route('user.dashboard')->withSuccess('Your Order Successfully Placed. Please Wait For Product');
        }
        public function aamarpay(Request $request)
        {

            $state = State::with('district')->findoRFail($request->state_id);
            if (Session::has('coupon'))
            {
                $amount   = Session::get('coupon')['totalAmount'] + intval($request->shipping_cost);
                $discount = Session::get('coupon')['discount'];
            }
            else
            {
                $price    = Session::get('order')['price'];
                $qty      = Session::get('order')['qty'];
                $amount   = (intval($price) * intval($qty)) + intval($request->shipping_cost);
                $discount = null;
            }
            $amaarpayStoreId      = Option::where('key', '=', 'aamaypay_store_id')->first();
            $amaarpaySingatureKey = Option::where('key', '=', 'aamaypay_signature_key')->first();
            $fields               = [
                'store_id'      => $amaarpayStoreId->value,
                'amount'        => $amount, //transaction amount
                'payment_type' => 'VISA', //no need to change
                'currency'   => 'BDT', //currenct will be USD/BDT
                'tran_id'       => uniqid(),
                'cus_name'      => $request->name, //customer name
                'cus_email'    => $request->email, //customer email address
                'cus_add1'   => $request->address1, //customer address
                'cus_add2'      => $request->address2, //customer address
                'cus_city' => $state->district->name, //customer city
                'cus_state' => $state->name, //state
                'cus_postcode' => $request->post_code, //postcode or zipcode
                'cus_country' => 'Bangladesh', //country
                'cus_phone' => $request->phone, //customer phone number
                'cus_fax' => 'Not¬Applicable', //fax
                'ship_name' => $request->name, //ship name
                'ship_add1' => $request->address1, //ship address
                'ship_add2' => $request->address2,
                'ship_city'     => $request->phone,
                'ship_state'    => $request->phone,
                'ship_postcode' => $request->post_code,
                'ship_country'  => 'Bangladesh',
                'desc'          => 'payment description',
                'success_url'   => route('amaarpay.success'), //your success route
                'fail_url'     => route('amaarpay.fail'), //your fail route
                'cancel_url' => 'http://localhost/foldername/cancel.php', //your cancel url
                'signature_key' => $amaarpaySingatureKey->value,
            ]; //signature key will provided aamarpay, contact integration@aamarpay.com for test/live signature key

            #Before  going to initiate the payment order status need to insert or update as Pending.
            $invoice = "EPEC-" . mt_rand(10000000, 99999999);
            $orderId = Order::insertGetId([
                'user_id'         => Auth::id(),
                'division_id'     => $request->division_id,
                'district_id'     => $request->district_id,
                'state_id'        => $request->state_id,
                'address1'        => $request->address1,
                'address2'        => $request->address2,
                'name'            => $request->name,
                'email'           => $request->email,
                'phone'           => $request->phone,
                'post_code'       => $request->post_code,
                'payment_method'  => 'AmaarPay',
                'transaction_id'  => $fields['tran_id'],
                'currency'        => "BDT",
                'amount'          => $amount,
                'shipping_cost'   => $request->shipping_cost,
                'coupon_discount' => $discount,
                'order_number'    => $fields['tran_id'],
                'invoice_no'      => $invoice,
                'order_date'      => Carbon::now()->format('d F Y'),
                'order_month'     => Carbon::now()->format('F'),
                'order_year'      => Carbon::now()->format('Y'),
                'notes'           => $request->notes,
                'created_at'      => Carbon::now(),
            ]);

            if (Session::has('order'))
            {
                $productId  = Session::get('order')['product_id'];
                $qty        = Session::get('order')['qty'];
                $product    = Product::findOrFail($productId);
                $stockQty   = intval($product->product_quantity_en) - intval($qty);
                $totalSells = intval($product->sells) + intval($qty);
                $product->update([
                    'product_quantity_en' => $stockQty,
                    'sells'               => $totalSells,
                ]);
                OrderItem::create([
                    'order_id'     => $orderId,
                    'product_id'   => Session::get('order')['product_id'],
                    'product_name' => Session::get('order')['product_name'],
                    'color'        => Session::get('order')['color'],
                    'size'         => Session::get('order')['size'],
                    'qty'          => Session::get('order')['qty'],
                    'price'        => Session::get('order')['price'],
                ]);
            }
            $mailInfo = [
                'order_id'   => $orderId,
                'invoice_no' => $invoice,
                'price'      => $amount,
            ];

            Mail::to($request->email)->send(new OrderMail($mailInfo));
            if (Session::has('coupon')) {
                Session::forget('coupon');
            }
            if (Session::has('order')) {
                Session::forget('order');
            }

            $url = 'https://sandbox.aamarpay.com/request.php'; // live url https://secure.aamarpay.com/request.php

            $fields_string = http_build_query($fields);

            $ch = curl_init();
            curl_setopt($ch, CURLOPT_VERBOSE, true);
            curl_setopt($ch, CURLOPT_URL, $url);

            curl_setopt($ch, CURLOPT_POSTFIELDS, $fields_string);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            $url_forward = str_replace('"', '', stripslashes(curl_exec($ch)));
            curl_close($ch);

            $this->redirect_to_merchant($url_forward);
        }
        public function redirect_to_merchant($url)
        {

        ?>
<html xmlns="http://www.w3.org/1999/xhtml">

<head>
    <script type="text/javascript">
    function closethisasap() {
        document.forms["redirectpost"].submit();
    }
    </script>
</head>

<body onLoad="closethisasap();">

    <form name="redirectpost" method="post" action="<?php echo 'https://sandbox.aamarpay.com/' . $url; ?>"></form>
    <!-- for live url https://secure.aamarpay.com -->
</body>

</html>
<?php
    exit;
        }
        
        public function sslcommerzHosted(Request $request)
        {

            $state = State::with('district')->findoRFail($request->state_id);

            if (Session::has('coupon'))
            {
                $amount   = Session::get('coupon')['totalAmount'] + intval($request->shipping_cost);
                $discount = Session::get('coupon')['discount'];
            }
            else
            {
                $price    = Session::get('order')['price'];
                $qty      = Session::get('order')['qty'];
                $amount   = (intval($price) * intval($qty)) + intval($request->shipping_cost);
                $discount = null;
            }
            if (Session::has('order'))
            {
                $productName = Session::get('order')['product_name'];
            }

            $post_data                 = [];
            $post_data['total_amount'] = $amount; # You cant not pay less than 10
            $post_data['currency']     = "BDT";
            $post_data['tran_id']      = uniqid(); // tran_id must be unique

            # CUSTOMER INFORMATION
            $post_data['cus_name']     = $request->name;
            $post_data['cus_email']    = $request->email;
            $post_data['cus_add1']     = $request->address1;
            $post_data['cus_add2']     = $request->address2;
            $post_data['cus_city']     = $state->district->name;
            $post_data['cus_state']    = $state->name;
            $post_data['cus_postcode'] = $request->post_code;
            $post_data['cus_country']  = "Bangladesh";
            $post_data['cus_phone']    = $request->phone;
            $post_data['cus_fax']      = "";

            # SHIPMENT INFORMATION
            $post_data['ship_name']     = $request->name;
            $post_data['ship_add1']     = $request->address1;
            $post_data['ship_add2']     = $request->address2;
            $post_data['ship_city']     = $state->district->name;
            $post_data['ship_state']    = $state->name;
            $post_data['ship_postcode'] = $request->post_code;
            $post_data['ship_phone']    = $request->phone;
            $post_data['ship_country']  = "Bangladesh";

            $post_data['shipping_method']  = "NO";
            $post_data['product_name']     = $productName;
            $post_data['product_category'] = "Goods";
            $post_data['product_profile']  = "physical-goods";

            #Before  going to initiate the payment order status need to insert or update as Pending.
            $invoice = "EPEC-" . mt_rand(10000000, 99999999);
            $orderId = Order::insertGetId([
                'user_id'         => Auth::id(),
                'division_id'     => $request->division_id,
                'district_id'     => $request->district_id,
                'state_id'        => $request->state_id,
                'address1'        => $request->address1,
                'address2'        => $request->address2,
                'name'            => $request->name,
                'email'           => $request->email,
                'phone'           => $request->phone,
                'post_code'       => $request->post_code,
                'payment_method'  => 'SSLCommerz',
                'transaction_id'  => $post_data['tran_id'],
                'currency'        => "BDT",
                'amount'          => $amount,
                'shipping_cost'   => $request->shipping_cost,
                'coupon_discount' => $discount,
                'order_number'    => $post_data['tran_id'],
                'invoice_no'      => $invoice,
                'order_date'      => Carbon::now()->format('d F Y'),
                'order_month'     => Carbon::now()->format('F'),
                'order_year'      => Carbon::now()->format('Y'),
                'notes'           => $request->notes,
                'created_at'      => Carbon::now(),
            ]);

            if (Session::has('order'))
            {
                $productId  = Session::get('order')['product_id'];
                $qty        = Session::get('order')['qty'];
                $product    = Product::findOrFail($productId);
                $stockQty   = intval($product->product_quantity_en) - intval($qty);
                $totalSells = intval($product->sells) + intval($qty);
                $product->update([
                    'product_quantity_en' => $stockQty,
                    'sells'               => $totalSells,
                ]);

                OrderItem::create([
                    'order_id'     => $orderId,
                    'product_id'   => Session::get('order')['product_id'],
                    'product_name' => Session::get('order')['product_name'],
                    'color'        => Session::get('order')['color'],
                    'size'         => Session::get('order')['size'],
                    'qty'          => Session::get('order')['qty'],
                    'price'        => Session::get('order')['price'],
                ]);
            }
            $mailInfo = [
                'order_id'   => $orderId,
                'invoice_no' => $invoice,
                'price'      => $amount,
            ];
            Mail::to($request->email)->send(new OrderMail($mailInfo));
            if (Session::has('coupon'))
            {
                Session::forget('coupon');
            }
            if (Session::has('order'))
            {
                Session::forget('order');
            }

            $sslc = new SslCommerzNotification();
            # initiate(Transaction Data , false: Redirect to SSLCOMMERZ gateway/ true: Show all the Payement gateway here )
            $payment_options = $sslc->makePayment($post_data, 'hosted');

            if (!is_array($payment_options))
            {
                print_r($payment_options);
                $payment_options = [];
            }
        }
    
    }