<?php

namespace App\Http\Controllers\Frontend;

use App\Http\Controllers\Controller;
use App\Models\Brand;
use App\Models\Page;
use App\Models\Product;
use App\Models\Review;
use App\Models\Category;
use App\Models\SubCategory;
use App\Models\SubSubCategory;

class SiteController extends Controller
{
    public function productDetail($id)
    {
        $singleProduct  = Product::active()->with('images', 'productAttributes')->findOrFail($id);
        $bestSells      = Product::active()->orderBy('sells', "DESC")->take(5)->get();
        $brands         = Brand::orderBy('brand_name_en', 'ASC')->get();
        $colorBn        = $singleProduct->product_color_bn;
        $productColorBn = explode(',', $colorBn);
        $colorEn        = $singleProduct->product_color_en;
        $productColorEn = explode(',', $colorEn);
        $sizeBn         = $singleProduct->product_size_bn;
        $productSizeBn  = explode(',', $sizeBn);
        $sizeEn         = $singleProduct->product_size_en;
        $productSizeEn  = explode(',', $sizeEn);
        $weight         =$singleProduct->product_weight_en;
        $productWeight  = explode(',', $weight);
        $reviews        = Review::with('user')->approve()->get();
        $ratings        = Review::where('product_id', $id)->approve()->avg('rating');
        $rating         = number_format($ratings, 1);
        return view('frontend.product-detail', compact('singleProduct', 'brands', 'productColorBn', 'productColorEn', 'productSizeBn', 'productSizeEn','productWeight', 'reviews', 'rating', 'bestSells'));
    }
    public function categoryProduct($id)
    {
        $products = Product::with(['reviews' => function ($status)
        {
            $status->approve();
        },

        ])->active()->where('category_id', $id)->latest()->paginate(20);
        $category = Category::select('category_name_en')->findOrfail($id);

        return view('frontend.product-category', compact('products', 'category'));
    }
    public function subCategoryProduct($id)
    {
        $products = Product::with(['reviews' => function ($status)
        {
            $status->approve();
        },

        ])->active()->where('subcategory_id', $id)->latest()->paginate(20);
        $subCategory = SubCategory::select('subcategory_name_en')->findOrfail($id);

        return view('frontend.product-subcategory', compact('products', 'subCategory'));
    }
    public function subSubCategoryProduct($id)
    {
        $products = Product::with(['reviews' => function ($status)
        {
            $status->approve();
        },
        ])->active()->where('subsubcategory_id', $id)->latest()->paginate(20);
        $subSubCategory = SubSubCategory::select('subsubcategory_name_en')->findOrfail($id);
        return view('frontend.product-subsubcategory', compact('products', 'subSubCategory'));
    }
    public function page($slug)
    {
        $page = Page::where('slug', '=', $slug)->first();
        return view('frontend.page', compact('page'));
    }

}