<?php

namespace App\Http\Controllers\Frontend;

use App\Http\Controllers\Controller;
use App\Models\Brand;
use App\Models\Category;
use App\Models\Product;
use App\Models\Slider;
use App\Models\Deal;

class HomeController extends Controller
{
    public function home()
    {
        // $allProduct = Product::with(['reviews' => function ($status)
        // {
        //     $status->approve();
        // }
        // ])->active()->take(40);
        // $products = Product::with(['reviews' => function ($status)
        // {
        //     $status->approve();
        // },
        // ])->active()->latest()->get();
        // Latest Products
        // $products = $allProduct->latest()->get();

        $products = Product::with(['reviews' => function ($status){
            $status->approve();
        }
        
        ])->active()->take(40)->get();
        
        $slider = Slider::active()->latest()->get();

        
        $bestSells    = Product::with(['reviews' => function ($status) {
            $status->approve();
        },
        ])->active()->orderBy('sells', "DESC")->take(10)->get();

        $brands = Brand::orderBy('brand_name_en', 'ASC')->get();
        return view('frontend.home', compact('products', 'slider', 'bestSells', 'brands'));
    }
    public function productView($id)
    {
        $product = Product::with('images', 'productAttributes')->findOrFail($id);

        $productCategory = Category::findOrFail($product->category_id);

        $productBrand   = Brand::findOrFail($product->brand_id);
        $colorBn        = $product->product_color_bn;
        $productColorBn = explode(',', $colorBn);
        $colorEn        = $product->product_color_en;
        $productColorEn = explode(',', $colorEn);
        $sizeBn         = $product->product_size_bn;
        $productSizeBn  = explode(',', $sizeBn);
        $sizeEn         = $product->product_size_en;
        $productSizeEn  = explode(',', $sizeEn);
        return response()->json([
            'product'  => $product,
            'category' => $productCategory,
            'brand'    => $productBrand,
            'colorsBn' => $productColorBn,
            'colorsEn' => $productColorEn,
            'sizesBn'  => $productSizeBn,
            'sizesEn'  => $productSizeEn,
        ]);
    }
    
    public function redirectToLogin($id,$slug)
    {
        session()->put('product_params',['id'=>$id,'slug'=>$slug]);
       
        return redirect()->route('login');
    }

}