<?php

namespace App\Http\Controllers;

use App\Mail\OrderMail;
use App\Models\Order;
use App\Models\OrderItem;
use App\Models\Product;
use App\Models\State;
use Carbon\Carbon;
use Gloudemans\Shoppingcart\Facades\Cart;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Session;
use App\Helpers\Supports;

class CODController extends Controller
{
    public function index(Request $request)
    {

        $state = State::with('district')->findoRFail($request->state_id);
        
        try {
            if (Session::has('coupon'))
            {
                $amount   = Session::get('coupon')['totalAmount'] + intval($request->shipping_cost);
                $discount = Session::get('coupon')['discount'];
            }
            else
            {
                $amount   = intval(round(Supports::getCartTotal())) + intval($request->shipping_cost);
                $discount = null;
            }
            $invoice = "EPEC-" . mt_rand(10000000, 99999999);
            $orderId = Order::insertGetId([
                'user_id'         => Auth::id(),
                'division_id'     => $request->division_id,
                'district_id'     => $request->district_id,
                'state_id'        => $request->state_id,
                'address1'        => $request->address1,
                'address2'        => $request->address2,
                'name'            => $request->name,
                'email'           => $request->email,
                'phone'           => $request->phone,
                'post_code'       => $request->post_code,
                'payment_method'  => 'COD',
                'transaction_id'  => uniqid(),
                'currency'        => "BDT",
                'amount'          => $amount,
                'shipping_cost'   => $request->shipping_cost,
                'coupon_discount' => $discount,
                'order_number'    => uniqid(),
                'invoice_no'      => $invoice,
                'order_date'      => Carbon::now()->format('d F Y'),
                'order_month'     => Carbon::now()->format('F'),
                'order_year'      => Carbon::now()->format('Y'),
                'notes'           => $request->notes,
                'created_at'      => Carbon::now(),
            ]);

            $carts = Supports::getCartCheckoutItems();

            foreach ($carts as $cart)
            {
                $product    = Product::findOrFail($cart->id);
                $stockQty   = intval($product->product_quantity_en) - intval($cart->qty);
                $totalSells = intval($product->sells) + intval($cart->qty);
                $product->update([
                    'product_quantity_en' => $stockQty,
                    'sells'               => $totalSells,
                ]);
                OrderItem::create([
                    'order_id'     => $orderId,
                    'product_id'   => $cart->id,
                    'product_name' => $cart->name,
                    'color'        => $cart->options->color,
                    'size'         => $cart->options->size,
                    'unit'         => $cart->options->unit,
                    'qty'          => $cart->qty,
                    'price'        => $cart->price,
                    'thickness'    => $cart?->options?->thickness
                ]);
                
                Cart::remove($cart->rowId);
            }
            $mailInfo = [
                'order_id'   => $orderId,
                'invoice_no' => $invoice,
                'price'      => $amount,
            ];
            Mail::to($request->email)->send(new OrderMail($mailInfo));
            if (Session::has('coupon')) {
                Session::forget('coupon');
            }
            
            return redirect()->route('user.order.all')->withSuccess('Your Order has placed successfully');
        }
        catch (\Exception$e)
        {
            return redirect()->back()->withError($e->getMessage());
        }

    }
}