<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Quote;
use Illuminate\Http\Request;

class QuoteController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('admin.quote.index', ['quotes' => Quote::with('product')->latest()->take(20)->get()]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'product_id'  => 'required',
            'qty'         => 'required',
            'name'        => 'required',
            'phone'       => 'required',
            'email'       => 'nullable',
            'b_name'      => 'nullable',
            'requirments' => 'required',
            'file'        => 'nullable | file',
        ]);
        try {
            
            $file = $request->file('file');
            
            $url = null;
            
            if($file){
                
                $data=$file->move('uploads/files/', $file->getClientOriginalName());
            
                $url  =$file->getClientOriginalName();
            }
           
            
            Quote::create([
                'product_id'  => $request->product_id,
                'qty'         => $request->qty,
                'name'        => $request->name,
                'phone'       => $request->phone,
                'email'       => $request->email,
                'b_name'      => $request->b_name,
                'requirments' => $request->requirments,
                'file'        =>'/uploads/files/'.$url
            ]);
            return redirect()->back()->withSuccess('Your Request has submitted successfully');
        }
        catch (\Exception$e)
        {
            return redirect()->back()->withError($e->getMessage());
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Quote  $quote
     * @return \Illuminate\Http\Response
     */
    public function show($quoteId)
    {
        return view('admin.quote.show', ['quote' => Quote::with('product')->findOrFail($quoteId)]);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Quote  $quote
     * @return \Illuminate\Http\Response
     */
    public function destroy($quoteId)
    {
        try {
            $quote=Quote::findOrFail($quoteId);
            
            if(file_exists($quote->file)){
            
                unlink($quote->file);
            }
            
            $quote->delete();
            return redirect()->back()->withSuccess('Quote has deleted sucessfully');
        }
        catch (\Exception$e)
        {
            return redirect()->back()->withError($e->getMessage());
        }
    }
    // Order Invoie
    public function quoteInvoice($quoteId)
    {
        $quote = Quote::findOrFail($quoteId);
        $pdf   = \PDF::loadview('admin.quote.invoice', compact('quote'))->setOptions([
            'tempDir'              => public_path(),
            'chroot'               => public_path(),
            'isHtml5ParserEnabled' => true,
        ]);
        return $pdf->download('quote-invoice.pdf');
    }
    
}