<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Order;
use App\Models\OrderItem;
use Carbon\Carbon;
use Illuminate\Http\Request;

class OrderController extends Controller
{
    //Pending Order
    public function index()
    {
        $orders = Order::where('status', 'pending')->orderBy('id','desc')->get(); 
        return view('admin.order.index', compact('orders'));
    }
    //Confirmed Order
    public function confirmedOrder()
    {
        $orders = Order::where('status', 'confirmed')->orderBy('id','desc')->get();
        return view('admin.order.confirm', compact('orders'));
    }
    //Processing Order
    public function processingOrder()
    {
        $orders = Order::where('status', 'processing')->orderBy('id','desc')->get();
        return view('admin.order.processed', compact('orders'));
    }
    //Processing Order
    public function shippedOrder()
    {
        $orders = Order::where('status', 'shipped')->orderBy('id','desc')->get();
        return view('admin.order.shipped', compact('orders'));
    }
    //Picked Order
    public function pickedOrder()
    {
        $orders = Order::where('status', 'picked')->orderBy('id','desc')->get();
        return view('admin.order.picked', compact('orders'));
    }
    //Delievered Order
    public function delieveredOrder()
    {
        $orders = Order::where('status', 'delievered')->orderBy('id','desc')->get();
        return view('admin.order.delievered', compact('orders'));
    }

    //Canceled Order
    public function canceledOrder()
    {
        $orders = Order::where('status', 'canceled')->orderBy('id','desc')->get();
        return view('admin.order.canceled', compact('orders'));
    }
    //Returned Order
    public function returedOrder()
    {
        $orders = Order::where('status', 'returned')->orderBy('id','desc')->get();
        return view('admin.order.returned', compact('orders'));
    }

    //Order Confirm
    public function toConfirm($orderId)
    {
        $order = Order::findOrFail($orderId)->update([
            'status'       => 'confirmed',
            'confirm_date' => Carbon::now(),
        ]);
        return redirect()->route('admin.order.confirmed')->withSuccess('This Order Successfully Confirmed');
    }

    //Cancel Order
    public function toCancel(Request $request)
    {
        $request->validate([
            'cancel_reason' => 'required | string',
        ]);

        try {
            Order::findOrFail(intval($request->order_id))->update([
                'status'        => 'canceled',
                'cancel_date'   => Carbon::now(),
                'cancel_reason' => $request->cancel_reason,
            ]);
            return redirect()->back()->withSuccess('Order Canceled Successfully');
        }
        catch (\Exception$e)
        {
            return redirect()->back()->withError($e->getMessage());
        }
    }
    //Order Processing
    public function toProcessing($orderId)
    {
        $order = Order::findOrFail($orderId)->update([
            'status'          => 'processing',
            'processing_date' => Carbon::now(),
        ]);
        return redirect()->route('admin.order.processed')->withSuccess('This Order is Now Processed');
    }
    //Order Shipped
    public function toShipped($orderId)
    {
        $order = Order::findOrFail($orderId)->update([
            'status'       => 'shipped',
            'shipped_date' => Carbon::now(),
        ]);
        return redirect()->route('admin.order.shipped')->withSuccess('This Order is Now Shipped');
    }
    //Order Picked
    public function toPicked($orderId)
    {
        $order = Order::findOrFail($orderId)->update([
            'status'      => 'picked',
            'picked_date' => Carbon::now(),
        ]);
        return redirect()->route('admin.order.picked')->withSuccess('This Order is Picked');
    }
    //Order Delieverd
    public function toDelieverd($orderId)
    {
        $order = Order::findOrFail($orderId)->update([
            'status'         => 'delievered',
            'delivered_date' => Carbon::now(),
        ]);
        return redirect()->route('admin.order.delievered')->withSuccess('Order Successfully Delieverd');
    }

    //Order Details
    public function orderDetail($orderId)
    {
        $order      = Order::with('division', 'district', 'state', 'user')->findOrFail($orderId);
        $orderItems = OrderItem::with('product')->where('order_id', $orderId)->get();
        
        return view('admin.order.order-detail', compact('order', 'orderItems'));
    }
    
    // Delete Order
    public function delete($id)
    {
        OrderItem::where('order_id',$id)->delete();
        $deleted=Order::findOrFail($id)->delete();
        if($deleted){
            return redirect()->route('admin.order.picked')->withSuccess('Order is Deleted');
        }else {
            return redirect()->route('admin.order.picked')->withError('Order delete fail');
        }
    }
}