<?php
declare(strict_types=1);

namespace App\Helpers;
use Gloudemans\Shoppingcart\Facades\Cart;

class Supports {
    
    public static function getCartTotal()
    {
        $cartItems = Cart::content();


        $checkoutItems = $cartItems->filter(function ($item) {
            return $item->options->has('is_checkout') && $item->options->get('is_checkout') === true;
        });


        return $checkoutItems->sum(function ($item) {
            return $item->price * $item->qty;
        });
        
    }
    
    public static function getCartCheckoutItems()
    {
        $cartItems = Cart::content();

        return $cartItems->filter(function ($item) {
            return $item->options->has('is_checkout') && $item->options->get('is_checkout') === true;
        });
    
    }
    public static function getCartCheckoutTotalItem()
    {
        $cartItems = Cart::content();

        $items = $cartItems->filter(function ($item) {
            return $item->options->has('is_checkout') && $item->options->get('is_checkout') === true;
        });
        
        return count($items);
    
    }
}