<!DOCTYPE html>
<html>

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <title> <?php echo e(__('Billing Invoice - EPEC-Ecommerce')); ?> </title>
    <link
        href="https://fonts.googleapis.com/css2?family=Roboto:ital,wght@0,300;0,400;0,500;0,700;0,900;1,300&display=swap"
        rel="stylesheet">
</head>

<body>


    <style>
        * {
            font-family: 'Roboto', sans-serif;
            line-height: 26px;
            font-size: 15px;
        }

        ul {
            margin: 0;
            padding: 0;
            list-style: none;
        }

        /*=====================[ Table ]=========================*/

        .custom--table {
            width: 100%;
            color: inherit;
            vertical-align: top;
            font-weight: 400;
            border-collapse: collapse;
            border-bottom: 2px solid #ddd;
            margin-top: 0;
        }

        .table-title {
            font-size: 24px;
            font-weight: 600;
            line-height: 32px;
            margin-bottom: 10px;
        }

        .custom--table thead {
            font-weight: 700;
            background: inherit;
            color: inherit;
            font-size: 13px;
            font-weight: 500;
        }

        .custom--table tbody {
            border-top: 0;
            overflow: hidden;
            border-radius: 10px;
        }

        .custom--table thead tr {
            border-top: 2px solid #ddd;
            border-bottom: 2px solid #ddd;
            text-align: left;
        }

        .custom--table thead tr th {
            border-top: 2px solid #ddd;
            border-bottom: 2px solid #ddd;
            text-align: left;
            font-size: 13px;
            padding: 10px 0;
        }

        .custom--table tbody tr {
            vertical-align: top;
        }

        .custom--table tbody tr td {
            font-size: 12px;
            line-height: 16px;
            vertical-align: top;
        }

        .custom--table tbody tr td:last-child {
            padding-bottom: 10px;
        }

        .custom--table tbody tr td .data-span {
            font-size: 12px;
            font-weight: 500;
            line-height: 16px;
        }

        .custom--table tbody .table_footer_row {
            border-top: 2px solid #ddd;
            margin-bottom: 10px !important;
            padding-bottom: 10px !important;

        }

        /* invoice area */
        .invoice-area {
            padding: 10px 0;
        }

        .invoice-wrapper {
            max-width: 650px;
            margin: 0 auto;
            box-shadow: 0 0 10px #f3f3f3;
            padding: 0px;
        }

        .invoice-header {
            margin-bottom: 40px;
        }

        .invoice-flex-contents {
            display: flex;
            align-items: center;
            justify-content: space-between;
            gap: 24px;
            flex-wrap: wrap;
        }

        .invoice-logo {}

        .invoice-logo img {}

        .invoice-header-contents {
            float: right;
        }

        .invoice-header-contents .invoice-title {
            font-size: 40px;
            font-weight: 700;
        }

        .invoice-details {
            margin-top: 20px;
        }

        .invoice-details-flex {
            display: flex;
            align-items: flex-start;
            justify-content: space-between;
            gap: 24px;
            flex-wrap: wrap;
        }

        .invoice-details-title {
            font-size: 24px;
            font-weight: 700;
            line-height: 32px;
            color: #153568;
            margin: 0;
            padding: 0;
        }

        .invoice-single-details {}

        .details-list {
            margin: 0;
            padding: 0;
            list-style: none;
            margin-top: 10px;
        }

        .details-list .list {
            font-size: 12px;
            font-weight: 400;
            line-height: 18px;
            color: #666;
            margin: 0;
            padding: 0;
            transition: all .3s;
        }

        .details-list .list strong {
            font-size: 12px;
            font-weight: 500;
            line-height: 18px;
            color: #666;
            margin: 0;
            padding: 0;
            transition: all .3s;
        }

        .details-list .list a {
            display: inline-block;
            color: #666;
            transition: all .3s;
            text-decoration: none;
            margin: 0;
            line-height: 16px
        }

        .item-description {
            margin-top: 10px;
        }

        .products-item {
            text-align: left;
        }

        .invoice-total-count {}

        .invoice-total-count .list-single {
            display: flex;
            align-items: center;
            gap: 30px;
            font-size: 13px;
            line-height: 28px;
        }

        .invoice-total-count .list-single strong {}

        .invoice-subtotal {
            border-bottom: 2px solid #ddd;
            padding-bottom: 15px;
        }

        .invoice-total {
            padding-top: 10px;
        }

        .terms-condition-content {
            margin-top: 30px;
        }

        .terms-flex-contents {
            display: flex;
            align-items: center;
            justify-content: space-between;
            gap: 20px;
            flex-wrap: wrap;
        }

        .terms-left-contents {
            flex-basis: 50%;
        }

        .terms-title {
            font-size: 18px;
            font-weight: 700;
            color: #333;
            margin: 0;
        }

        .terms-para {
            margin-top: 10px;
        }

        .invoice-footer {}

        .invoice-flex-footer {
            display: flex;
            align-items: flex-start;
            justify-content: space-between;
            flex-wrap: wrap;
            gap: 30px;
        }

        .single-footer-item {
            flex: 1;
        }

        .single-footer {
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .single-footer .icon {
            display: flex;
            align-items: center;
            justify-content: center;
            height: 30px;
            width: 30px;
            font-size: 14px;
            background-color: #000e8f;
            color: #fff;
        }

        .icon-details {
            flex: 1;
        }

        .icon-details .list {
            display: block;
            text-decoration: none;
            color: #666;
            transition: all .3s;
            line-height: 24px;
        }

        .data-span {
            display: inline-block;
            margin-left: 50px;
            text-align: right !important;

        }

        .text-left {
            min-width: 120px
        }

        .text-green th,
        .custom--table th,
        .custom--table td {
            text-align: center;
        }

        .amount-table tr td {
            border-collapse: collapse !important;
            border-bottom: 1px solid #ddd !important;
        }
    </style>

    <!-- Invoice area Starts -->
    <div class="invoice-area">
        <div class="invoice-wrapper">
            <div class="invoice-header">
                <div class="invoice-flex-contents">
                    <div class="invoice-logo">
                        <img src="<?php echo e(asset( $setting->logo)); ?>" alt="">
                    </div>
                    <div class="invoice-header-contents" style="float:right;margin-top:-120px;">
                        <h2 class="invoice-title"><?php echo e(__('INVOICE')); ?></h2>
                    </div>
                </div>
            </div>
            <div class="invoice-details">
                <div class="invoice-details-flex">
                    <div class="invoice-single-details">
                        <h4 class="invoice-details-title"><?php echo e($order->name); ?></h4>
                        <ul class="details-list">
                            <li class="list"> <strong>Email: </strong> <?php echo e($order->email); ?> </li>
                            <li class="list"> <strong><?php echo e(__('Phone')); ?>: </strong> <?php echo e($order->phone); ?> </li>
                            <li class="list"> <strong><?php echo e(__('City')); ?>: </strong> <?php echo e($order->state->name); ?> </li>
                            <li class="list"> <strong><?php echo e(__('Address')); ?>:
                                </strong><?php echo e($order->address1); ?> </li>
                        </ul>

                    </div>
                    <div class="invoice-single-details" style="float:right;margin-top:-120px;">

                        <ul class="details-list" style="text-align: right;">
                            <li class="list"> <?php echo e($setting?->address); ?> </li>
                            <li class="list"><?php echo e($setting?->email); ?> </li>
                            <li class="list"><?php echo e($setting?->phone_1); ?></li>
                            <li class="list"><?php echo e($setting?->phone_2); ?></li>
                        </ul>
                    </div>
                </div>
            </div>
            <div class="invoice-details">
                <div class="invoice-details-flex">

                    <div class="invoice-single-details" style="float:right;margin-top:-120px;">
                        <ul class="details-list" style="text-align: right;">
                            <li class="list"> <strong><?php echo e(__('Invoice No')); ?>: </strong> <?php echo e($order?->invoice_no); ?>

                            <li class="list"> <strong><?php echo e(__('Order No')); ?>: </strong> <?php echo e($order?->id); ?>

                            <li class="list"> <strong><?php echo e(__('Order Date')); ?>: </strong> <?php echo e($order?->order_date); ?>

                            </li>
                        </ul>
                    </div>
                </div>
            </div>

            <div class="item-description">
                <h3 style="font-size: 20px;" class="table-title">Products</h3>
                <table class="custom--table">
                    <thead>
                        <tr class="text-green" style="text-align: center;">
                            <th style="text-align: center;">Product</th>
                            <th style="text-align: center;">Image</th>
                            <th style="text-align: center;">Quantity</th>
                            <th style="text-align: center;">Price (TK)</th>
                            <th style="text-align: center;">Discount Price(TK)</th>
                            <th style="text-align: center;">Total Price(TK)</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $orderItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $orderItem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td style="width: 100px"><?php echo e($orderItem?->product->product_name_en); ?></td>
                                <td style="width: 40px">
                                    <img style="width: 100%;"
                                        src="<?php echo e(asset($orderItem->product->product_thumbnail)); ?>" alt="">
                                </td>
                                <td><?php echo e($orderItem?->qty); ?></td>
                                <td><?php echo e($orderItem?->product->selling_price); ?></td>

                                <td><?php echo e($orderItem?->price); ?></td>
                                <td><?php echo e($orderItem?->price * $orderItem?->qty); ?></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>

            <div class="">
                <div class="table-responsive" style="float:left; margin-left: 20px;">

                    <?php if($order?->notes): ?>
                        <p> Notes: <?php echo e($order?->notes); ?></p>
                    <?php endif; ?>
                    <?php if($sellerNotes): ?>
                        <p> Seller Notes: <?php echo e($sellerNotes?->value); ?></p>
                    <?php endif; ?>
                </div>
                <div class="table-responsive" style="float:right;">

                    <?php
                        $total = intval($order?->amount) + intval($order?->coupon_discount) - intval($order?->shipping_cost);
                        $subTotal = intval($total) + intval($order?->shipping_cost);
                    ?>
                    <table style="margin-right: 40px;" class="amount-table">
                        <tr>
                            <td><?php echo e(__('Total Price:')); ?></td>
                            <td>TK. <?php echo e($total); ?></td>
                        </tr>
                        <tr>
                            <td><?php echo e(__('Shipping Cost:')); ?></td>
                            <td>TK. <?php echo e($order?->shipping_cost); ?></td>
                        </tr>
                        <tr>
                            <td><?php echo e(__('Sub Total:')); ?></td>
                            <td>TK. <?php echo e($subTotal); ?></td>
                        </tr>
                        <tr>
                            <td> <?php echo e(__('Coupon Amount:')); ?></td>
                            <td>TK. <?php echo e($order?->coupon_discount); ?></td>
                        </tr>
                        <tr>
                            <td> <?php echo e(__('Total Amount:')); ?></td>
                            <td>TK. <?php echo e($order?->amount); ?></td>
                        </tr>
                        <?php if($order->payment_method === 'cod'): ?>
                            <tr>
                                <td> <?php echo e(__('Payment DUE:')); ?></td>
                                <td>TK. <?php echo e($order?->amount); ?></td>
                            </tr>
                        <?php endif; ?>
                    </table>

                    

                </div>
            </div>


            <footer>
                <h3 style="text-align: center">
                    
                </h3>
            </footer>

        </div>
    </div>

    <!-- Invoice area end -->

</body>

</html>
<?php /**PATH /home/steellbaazaar/public_html/resources/views/user/order/invoice.blade.php ENDPATH**/ ?>