
<?php $__env->startSection('title',"Wishlist Page"); ?>
<?php $__env->startSection('content'); ?>

<div class="breadcrumb">
	<div class="container">
		<div class="breadcrumb-inner">
			<ul class="list-inline list-unstyled">
				<li><a href="<?php echo e(url('/')); ?>"><?php echo e(session()->get('language')=='bangla' ? "হোম" : 'Home'); ?></a></li>
				<li class='active'><a href=""><?php echo e(session()->get('language')=='bangla' ? "উইশলিস্ট" : 'WishList'); ?></a></li>
			</ul>
		</div><!-- /.breadcrumb-inner -->
	</div><!-- /.container -->
</div><!-- /.breadcrumb -->

<div class="body-content">
	<div class="container">
		<div class="my-wishlist-page">
			<div class="row">
				<div class="col-md-12 my-wishlist">
	<div class="table-responsive">
		<table class="table">
			<thead>
				<tr>
					<th colspan="4" class="heading-title">My Wishlist</th>
				</tr>
			</thead>
			<tbody>
                <?php $__empty_1 = true; $__currentLoopData = $wishlists; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $wishlist): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    
				<tr>
					<td class="col-md-2"><img src="<?php echo e(asset($wishlist?->product?->product_thumbnail)); ?>" alt="<?php echo e($wishlist?->product?->product_name_en); ?>"></td>
					<td class="col-md-7">
						<div class="product-name"><a href="<?php echo e(route('product.detail',['id'=>$wishlist?->product->id,'slug'=>$wishlist?->product->product_slug_en])); ?>"><?php echo e($wishlist?->product->product_name_en); ?></a></div>
						
                        <?php if($wishlist?->product?->discount==null): ?>
                        <div>
							<span>৳ <?php echo e($wishlist?->product?->selling_price); ?></span>
						</div> 
                        <?php else: ?>
                        <div class="price">
							৳ <?php echo e($wishlist?->product?->discount_price); ?>

							<span>৳ <?php echo e($wishlist?->product?->selling_price); ?></span>
						</div> 
                        <?php endif; ?>
						
					</td>
					<td class="col-md-2">
						
						<a type="button" class="btn-upper btn btn-primary" href="<?php echo e(route('product.detail',['id'=>$wishlist?->product->id,'slug'=>$wishlist?->product->product_slug_en])); ?>}">View Product</button>
					</td>
					<td class="col-md-1 close-btn">
						<a href="<?php echo e(route('user.wishlist.delete',$wishlist?->product->id)); ?>" class="btn btn-danger" id="delete" ><i class="fa fa-times"></i></button>
					</td>
				</tr>
                
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="4">Your WishList is Empty</td>
                    </tr>
                <?php endif; ?>
			</tbody>
		</table>
	</div>
</div>			</div><!-- /.row -->
		</div><!-- /.sigin-in-->
<!-- ============================================== BRANDS CAROUSEL ============================================== -->
		<?php echo $__env->make('frontend.inc.brand-carousel',['brands'=>$brands], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<!-- ======= BRANDS CAROUSEL : END=========== -->	
	</div><!-- /.container -->
</div><!-- /.body-content -->

<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <script type="text/javascript">
        $(document).on('click', '#delete', function(e) {
            e.preventDefault();
            let link = $(this).attr('href');
            Swal.fire({
                title: "Are your sure want to Delete This!",
                text: 'Once deleted, you will not be able to recover',
                icon: 'warning',
                showDenyButton: true,
                showCancelButton: true,
                confirmButtonText: 'Delete',
                denyButtonText: `Don't Delete`,
            }).then((willDelete) => {
                if (willDelete.isConfirmed) {
                    window.location.href = link;
                } else {
                    Swal.fire('Product Not Deleted from wishlist', '', 'info')
                }
            })
        });
        <?php if(session()->has('success')): ?>
            Swal.fire({
                icon: 'success',
                text: "<?php echo e(session('success')); ?>"
            })
        <?php endif; ?>
        <?php if(session()->has('error')): ?>
            Swal.fire({
                icon: 'error',
                text: "<?php echo e(session('error')); ?>"
            })
        <?php endif; ?>
        

    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.frontend-layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/epeccomb/steelbazar.com/resources/views/user/wishlist.blade.php ENDPATH**/ ?>