<?php $__env->startSection('title', 'Add New Product'); ?>
<?php $__env->startSection('product', 'active show-sub'); ?>
<?php $__env->startSection('add-new', 'active'); ?>
<?php $__env->startSection('content'); ?>
    <nav class="breadcrumb sl-breadcrumb">
        <a class="breadcrumb-item" href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a>
        <a class="breadcrumb-item" href="<?php echo e(route('products.all')); ?>"><?php echo e(__('All Products')); ?></a>
        <span class="breadcrumb-item active">Add New Product</span>
    </nav>

    <div class="sl-pagebody">
        <div class="row row-sm">
            <div class="col-md-12">
                <div class="card pd-10 pd-sm-20">
                    <h6 class="card-body-title">All New Product</h6>
                     <?php if($errors->any()): ?>

                        <ul>
                            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li class="text-danger"> <?php echo e($error); ?></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>

                    <?php endif; ?>
                    <form action="<?php echo e(route('product.store')); ?>" method="POST" class="form-layout"
                        enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label class="form-control-label">Select Brand <span class="tx-danger">*</span></label>
                                    <select class="form-control select2 select2-show-search" name="brand_id"
                                        data-placeholder="Choose one">
                                        <option label="Choose one"></option>
                                        <?php $__currentLoopData = $brands; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $brand): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($brand->id); ?>" name="brand"><?php echo e($brand->brand_name_en); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <?php $__errorArgs = ['brand_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label class="form-control-label">Select Category <span
                                            class="tx-danger">*</span></label>
                                    <select class="form-control select2 select2-show-search" name="category_id"
                                        data-placeholder="Choose one" id="category">
                                        <option label="Choose one">Choose Category</option>
                                        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($category->id); ?>" name="category">
                                                <?php echo e($category->category_name_en); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <?php $__errorArgs = ['category_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label class="form-control-label">Select Sub Category <span
                                            class="tx-danger">*</span></label>
                                    <select class="form-control select2 select2-show-search" name="subcategory_id"
                                        data-placeholder="Choose one" id="sub-category">
                                        <option label="Choose one">Choose Sub Category</option>
                                    </select>
                                    <?php $__errorArgs = ['subcategory_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label class="form-control-label">Select Sub Sub Category <span
                                            class="tx-danger">*</span></label>
                                    <select class="form-control select2 select2-show-search" name="subsubcategory_id"
                                        data-placeholder="Choose one" id="sub-sub-category">
                                        <option label="Choose one"></option>
                                    </select>
                                    <?php $__errorArgs = ['subsubcategory_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label class="form-control-label">Product Name <span class="tx-danger">*</span></label>
                                    <input class="form-control" type="text" name="product_name_en"
                                        value="<?php echo e(old('product_name_en')); ?>" placeholder="Enter Product Name">
                                    <?php $__errorArgs = ['product_name_en'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label class="form-control-label">Product Code<span class="tx-danger">*</span></label>
                                    <input class="form-control" type="text" name="product_code"
                                        value="<?php echo e(old('product_code')); ?>" placeholder="Enter Product Code">
                                    <?php $__errorArgs = ['product_code'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label class="form-control-label">Product Quantity <span
                                            class="tx-danger">*</span></label>
                                    <input class="form-control" type="text" name="product_quantity_en"
                                        value="<?php echo e(old('product_quantity_en')); ?>" placeholder="Enter Product Quantity">
                                    <?php $__errorArgs = ['product_quantity_en'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label class="form-control-label">Product Tags<span class="tx-danger">*</span></label>
                                    <input class="form-control" type="text" name="product_tags_en"
                                        value="<?php echo e(old('product_tags_en')); ?>" placeholder="Enter Product Tags"
                                        data-role="tagsinput">
                                    <?php $__errorArgs = ['product_tags_en'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div>
                                    <div class="form-group">
                                        <label class="form-control-label">Attribute
                                        <span class="tx-danger">*</span></label>
                                            
                                        <select class="form-control select2" data-placeholder="Choose Attribute"multiple id="attribute">
                                            <?php $__currentLoopData = $attributes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $attribute): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($attribute->name); ?>"><?php echo e($attribute->name); ?>

                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="row" id="product-attributes"></div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label class="form-control-label">Product Color</label>
                                    <input class="form-control" type="text" name="product_color_en"
                                        value="<?php echo e(old('product_color_en')); ?>" placeholder="Enter Product Color"
                                        data-role="tagsinput">
                                    <?php $__errorArgs = ['product_color_en'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label class="form-control-label">Product Size</label>
                                    <input class="form-control" type="text" name="product_size_en"
                                        value="<?php echo e(old('product_size_en')); ?>" placeholder="Enter Product Size"
                                        data-role="tagsinput">
                                    <?php $__errorArgs = ['product_size_en'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label class="form-control-label">Product Weight</label>
                                    <input class="form-control" type="text" name="product_weight_en"
                                        value="<?php echo e(old('product_weight_en')); ?>" placeholder="Enter Product Weight" data-role="tagsinput">
                                    <?php $__errorArgs = ['product_weight_en'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label class="form-control-label" for="unit">Unit<span
                                            class="tx-danger">*</span></label>
                                    <select class="form-control select2 select2-show-search" name="unit"
                                        data-placeholder="Choose Unit" id="sub-sub-category">
                                        <option label="Choose Unit">Choose Unit</option>
                                        <option label="Pcs">Pcs</option>
                                        <option label="Sft">Sft</option>
                                        <option label="Kg">Kg</option>
                                        <option label="Pound">Pound</option>
                                        <option label="Ton">Ton</option>
                                        <option label="Pair">Pair</option>
                                        <option label="Rol">Rol</option>
                                        <option label="Feet">Feet</option>
                                        <option label="Metre">Metre</option>
                                        <option label="Centi Metre">Centi Metre</option>
                                        <option label="Mili Metre">Mili Metre</option>
                                        <option label="Box">Box</option>
                                        <option label="Please Ask For Price">Please Contact For Price</option>
                                    </select>
                                    <?php $__errorArgs = ['unit'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>


                            <div class="col-md-4">
                                <div class="form-group">
                                    <label class="form-control-label">Selling Price<span
                                            class="tx-danger">*</span></label>
                                    <input class="form-control" type="text" name="selling_price"
                                        value="<?php echo e(old('selling_price')); ?>" placeholder="Selling Price">
                                    <?php $__errorArgs = ['selling_price'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div style="margin-top: 40px;">
                                    <label class="ckbox">
                                        <input type="checkbox" name="is_price_variant" id="is-unit-variant" value="1">
                                        <span>Enable Price Variant</span>
                                    </label>
                                    <?php $__errorArgs = ['is_price_variant'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                            <div class="col-12 d-none" id="unit-variants">
                                <div class="row">
                            
                                  <div class="col-md-4">
                                    <div class="form-group">
                                      <div>
                                          <label class="form-control-label">Variant Unit Name <span class="tx-danger">*</span></label>
                                      </div>
                                      <div>
                                          
                                          <select class="form-control select2 select2-show-search w-full" style="width: 100%;" name="variants[0][unit]"
                                                  data-placeholder="Choose Unit">
                                            <option label="Choose Unit">Choose Unit</option>
                                            <option label="Pcs">Pcs</option>
                                            <option label="Sft">Sft</option>
                                            <option label="Kg">Kg</option>
                                            <option label="Pound">Pound</option>
                                            <option label="Ton">Ton</option>
                                            <option label="Pair">Pair</option>
                                            <option label="Rol">Rol</option>
                                            <option label="Feet">Feet</option>
                                            <option label="Metre">Metre</option>
                                            <option label="Centi Metre">Centi Metre</option>
                                            <option label="Mili Metre">Mili Metre</option>
                                            <option label="Box">Box</option>
                                            <option label="Please Ask For Price">Please Contact For Price</option>
                                          </select>
                                          </div>
                                     
                                    </div>
                                  </div>
                                  <div class="col-md-4">
                                    <div class="form-group">
                                      <label class="form-control-label">Variant Price <span class="tx-danger">*</span></label>
                                      <input class="form-control" type="text" name="variants[0][price]"
                                              placeholder="Enter Variant Price">
                                      
                                    </div>
                                  </div>
                                  <div class="col-md-4" style="display: flex">
                                    <div class="form-group"  style="width: 75%">
                                      <label class="form-control-label">Convert Unit Value<span class="tx-danger">*</span></label>
                                      <input class="form-control" type="text" name="variants[0][convert_value]"
                                             placeholder="Enter Convert Unit Value">
                                      
                                    </div>
                                    <div class="ml-2" style="width: 25%">
                                        <button class="btn btn-success" onClick="addMoreVariant()" style="margin-top: 35px;" type="button">Add More</button>
                                      </div>
                                  </div>
                                  
                            
                                </div>
                             </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label class="form-control-label" for="discount-type">Discount Type</label>
                                    <select name="discount_type" id="discount-type" class="form-control">
                                        <option value="flat">Flat</option>
                                        <option value="parcent">Parcent</option>
                                    </select>
                                    <?php $__errorArgs = ['discount_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label class="form-control-label">Discount</label>
                                    <input class="form-control" type="text" name="discount"
                                        value="<?php echo e(old('discount')); ?>" placeholder="Discount Amount">
                                    <?php $__errorArgs = ['discount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                            <div class="col-md-4">
                                
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label class="form-control-label">Product Thumbnail<span
                                            class="tx-danger">*</span></label>
                                    <input class="form-control" type="file" name="product_thumbnail"
                                        value="<?php echo e(old('product_thumbnail')); ?>" accept="image/*"
                                        onchange="loadFile(event)">
                                    <?php $__errorArgs = ['product_thumbnail'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <img style="width:50%;" id="thumbnail-preview" />
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label class="form-control-label">Prdouct  Image Gallery<span
                                            class="tx-danger">*</span></label>
                                    <input class="form-control" type="file" name="product_multiple_image[]"
                                        value="<?php echo e(old('product_multiple_image')); ?>" id="multiple-image" multiple>
                                    <?php $__errorArgs = ['product_multiple_image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <div class="preview-all" id="preview-all"></div>
                            </div>
                            
                            
                            <div class="col-md-4">
                                
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="ckbox">
                                        <input type="checkbox" value="1" name="product_type">
                                        <span>MS Plate</span>
                                    </label>
                                    <?php $__errorArgs = ['product_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="ckbox">
                                        <input type="checkbox" value="1" name="hot_deals">
                                        <span>Hot Deals</span>
                                    </label>
                                    <?php $__errorArgs = ['hot_deals'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="ckbox">
                                        <input type="checkbox" value="1" name="featured">
                                        <span>Featured</span>
                                    </label>
                                    <?php $__errorArgs = ['featured'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="ckbox">
                                        <input type="checkbox" value="1" name="special_offer">
                                        <span>Special Offer</span>
                                    </label>
                                    <?php $__errorArgs = ['special_offer'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="ckbox">
                                        <input type="checkbox" value="1" name="special_deals">
                                        <span>Special Deals</span>
                                    </label>
                                    <?php $__errorArgs = ['special_deals'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="ckbox">
                                        <input type="checkbox" value="1" name="hide_size_weight">
                                        <span>Hide Size and Weight</span>
                                    </label>
                                    <?php $__errorArgs = ['hide_size_weight'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                    
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                        <label class="ckbox">
                                            <input type="checkbox" name="hightlight_attribute" value="1">
                                            <span>Hightlight Attributes</span>
                                        </label>
                                        <?php $__errorArgs = ['hightlight_attribute'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="text-danger"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div> 
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-control-label">Product Short Description<span
                                            class="tx-danger">*</span></label>
                                    <textarea name="short_desc_en"  id="short-description"><?php echo e(old('short_desc_en')); ?></textarea>
                                    <?php $__errorArgs = ['short_desc_en'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-control-label">Product Full Description<span
                                            class="tx-danger">*</span></label>
                                    <textarea name="full_desc_en"  id="full-description"><?php echo e(old('full_desc_en')); ?></textarea>
                                    <?php $__errorArgs = ['full_desc_en'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>


                            <div class="form-layout-footer col-12">
                                <button class="btn btn-info text-center">Save</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    
    <?php echo $__env->make('components.tinymce.tinymce', [
        'selector' => 'short-description',
    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <script type="text/javascript">
        tinymce.init({
            selector: "#full-description",
            
            plugins: [
                'advlist', 'autolink', 'link', 'image', 'lists', 'charmap', 'print', 'preview', 'hr', 'media',
                'anchor', 'pagebreak ', 'wordcount', 'code', 'fullscreen',
                'save', 'table', 'contextmenu', 'directionality', 'emoticons', 'template', 'paste', 'textcolor'
            ],
            toolbar: [
                'formatselect | fontsizeselect | bold | italic | underline |  bullist | numlist | alignleft | aligncenter | alignright | alignjustify  | blockquote | link | unlink |image | table |  forecolor | removeformat | charmap | copy | cut | paste | liquickimageneheight | redo | undo | spellchecker | imageoptions | code',
            ],
            height: 500,
            branding: false,
            menubar: false,
            image_class_list: [{
                title: 'Responsive',
                value: 'img-responsive'
            }],
            mobile: {
                resize: true
            }
        });
        //Product Thumbnail Preview
        var loadFile = function(event) {
            var reader = new FileReader();
            reader.onload = function() {
                var output = document.getElementById('thumbnail-preview');
                output.src = reader.result;
            };
            reader.readAsDataURL(event.target.files[0]);
        };
        $(document).ready(function() {
            $('#is-unit-variant').change(function(){
                if(this.checked){
                    $('#unit-variants').removeClass('d-none')
                }else{
                    $('#unit-variants').addClass('d-none')
                }
            })
            $('#attribute').on('change', function() {
                let attributes = $(this).val();
                let productAttributes = '';
                attributes.forEach(function(item) {
                    productAttributes += `<div class="col-md-4 my-1">
                                            <div class="form-group">
                                                <label class="form-control-label" for="${item}">${item}</label>
                                                <input class="form-control" type="text" name="product_attributes[${item}]"  placeholder="Enter ${item}"  value='' id="${item}" data-role="tagsinput">
                                                
                                            </div>
                                        </div>`
                });

                $('#product-attributes').html(productAttributes);

            })


            // Multile Image preview
            function previewImages() {

                var $preview = $('#preview-all').empty();
                if (this.files) $.each(this.files, readAndPreview);

                function readAndPreview(i, file) {

                    if (!/\.(jpe?g|png|gif|webp)$/i.test(file.name)) {
                        return alert(file.name + " is not an image");
                    } // else...

                    var reader = new FileReader();

                    $(reader).on("load", function() {
                        $preview.append($("<img/>", {
                            src: this.result,
                            height: 100
                        }));
                    });

                    reader.readAsDataURL(file);

                }

            }

            $('#multiple-image').on("change", previewImages);


            //Get Sub Category Using Axios
            $('#category').on('change', function() {
                let categoryId = $(this).val();
                let url = "/admin/sub/sub-category/filter/" + categoryId;
                axios.get(url)
                    .then(function(response) {
                        if (response.status == 200) {
                            let datas = response.data;
                            $('#sub-category').empty();
                            $('#sub-sub-category').empty();
                            $.each(datas, function(id, subCategory) {
                                $('#sub-category').append(
                                    '<option value="' + subCategory.id + '">' + subCategory
                                    .subcategory_name_en + '</option>'
                                );
                            })
                        }
                    }).catch(function(error) {
                        console.log(error);
                    })
            });

            //Get Sub Sub Caegory Using 
            $('#sub-category').on('change', function() {
                let subCategoryId = $(this).val();
                let url = "/admin/sub/sub/sub-category/filter/" + subCategoryId;
                axios.get(url)
                    .then(function(response) {
                        if (response.status == 200) {
                            let datas = response.data;
                            $('#sub-sub-category').empty();
                            $.each(datas, function(id, subSubCategory) {
                                $('#sub-sub-category').append(
                                    '<option value="' + subSubCategory.id + '">' +
                                    subSubCategory.subsubcategory_name_en + '</option>'
                                );
                            })
                        }
                    }).catch(function(error) {

                    })
            });
            $('.text-editor').summernote({
                height: 150
            })
        });
        
        function addMoreVariant(){
            
            const totalVariant = $('#unit-variants').children().length
          
            
            const varitant = `<div class="row">
                            
                                  <div class="col-md-4">
                                    <div class="form-group">
                                      <div>
                                          <label class="form-control-label">Variant Unit Name <span class="tx-danger">*</span></label>
                                      </div>
                                      <div>
                                          
                                          <select class="form-control select2 select2-show-search w-full" style="width: 100%;" name="variants[${totalVariant}][unit]"
                                                  data-placeholder="Choose Unit">
                                            <option label="">Choose Unit</option>
                                            <option label="Pcs">Pcs</option>
                                            <option label="Sft">Sft</option>
                                            <option label="Kg">Kg</option>
                                            <option label="Pound">Pound</option>
                                            <option label="Ton">Ton</option>
                                            <option label="Pair">Pair</option>
                                            <option label="Rol">Rol</option>
                                            <option label="Feet">Feet</option>
                                            <option label="Metre">Metre</option>
                                            <option label="Centi Metre">Centi Metre</option>
                                            <option label="Mili Metre">Mili Metre</option>
                                            <option label="Box">Box</option>
                                            <option label="Please Ask For Price">Please Contact For Price</option>
                                          </select>
                                          </div>
                                      
                                    </div>
                                  </div>
                                  <div class="col-md-4">
                                    <div class="form-group">
                                      <label class="form-control-label">Variant Price <span class="tx-danger">*</span></label>
                                      <input class="form-control" type="text" name="variants[${totalVariant}][price]"
                                              placeholder="Enter Variant Price">
                                     
                                    </div>
                                  </div>
                                  <div class="col-md-4" style="display: flex">
                                    <div class="form-group"  style="width: 75%">
                                      <label class="form-control-label">Convert Unit Value<span class="tx-danger">*</span></label>
                                      <input class="form-control" type="text" name="variants[${totalVariant}][convert_value]"
                                             placeholder="Enter Convert Unit Value">
                                      
                                    </div>
                                    <div class="ml-2" style="width: 25%">
                                        <button class="btn btn-danger remove-unit-variant" style="margin-top: 35px;" type="button">Remove</button>
                                      </div>
                                  </div>
                                  
                            
                                </div>`
                                
            $('#unit-variants').append(varitant)
                                
                                
        }
       
        <?php if(session()->has('error')): ?>
            Swal.fire({
                icon: 'error',
                text: "<?php echo e(session('error')); ?>"
            })
        <?php endif; ?>
        $(document).ready(function() {
          $(document).on('click', '.remove-unit-variant', function() {
            $(this).closest('.row').remove();
          });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin-layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/steellbaazaar/public_html/resources/views/admin/product/create.blade.php ENDPATH**/ ?>