
<?php $__env->startSection('title', 'Cart Page'); ?>
<?php $__env->startSection('content'); ?>

    <div class="breadcrumb">
        <div class="container">
            <div class="breadcrumb-inner">
                <ul class="list-inline list-unstyled">
                    <li><a href="<?php echo e(url('/')); ?>">Home</a></li>
                    <li class='active'>Shopping Cart</li>
                </ul>
            </div><!-- /.breadcrumb-inner -->
        </div><!-- /.container -->
    </div><!-- /.breadcrumb -->

    <div class="body-content outer-top-xs">
        <div class="container">
            <div class="row ">
                
                <div class="shopping-cart">
                    <?php if(count($carts) > 0): ?>
                    <div class="shopping-cart-table ">
                        <div class="table-responsive">
                            <table class="table">
                                <thead>
                                    <tr>
                                        <th class="cart-qty item"> <label for="all-item"><input <?php echo e($checkoutAll ? 'checked' : ''); ?> type="checkbox" id="all-item" /> Select All</label></th>
                                        <th class="cart-qty item">Name</th>
                                        <th class="cart-description item">Image</th>
                                        <th class="cart-qty item">Quantity</th>
                                        <th class="cart-sub-total item">Price</th> 
                                        <th class="cart-product-name item">Action</th>
                                    </tr>
                                </thead><!-- /thead -->

                                <tfoot>
                                    <tr>
                                        <td colspan="7">
                                            <div class="shopping-cart-btn">
                                                <span class="">
                                                    <!--<a href="<?php echo e(route('home')); ?>"-->
                                                    <!--    class="btn btn-upper btn-primary outer-left-xs">Continue-->
                                                    <!--    Shopping</a>-->
                                                    <a href="<?php echo e(route('home')); ?>"
                                                        class="btn btn-upper btn-primary pull-right outer-right-xs">Continue
                                                        shopping</a>
                                                </span>
                                            </div><!-- /.shopping-cart-btn -->
                                        </td>
                                    </tr>
                                </tfoot>
                                <tbody>
                                    <?php $__empty_1 = true; $__currentLoopData = $carts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cart): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <tr>
                                            <td class="cart-product-name-info text-center">
                        						<input type="checkbox" value="<?php echo e($cart->name); ?>" class="single-cart-item" onchange="handleIsCheckkout('<?php echo e($cart->rowId); ?>')" <?php echo e($cart->options->is_checkout ? 'checked' : ''); ?>/>
                        					</td>
                        					
                        					<td class="cart-product-name-info text-center">
                        						<h4 class='cart-product-description'><a href="detail.html"><?php echo e($cart->name); ?></a></h4>
                        						<div class="cart-product-info">
                        							<span class="product-color">COLOR:<span style="text-transform:capitalize"><?php echo e($cart->options->color); ?></span></span>
                        						</div>
                        					</td>
                        					<td class="cart-image">
                        						<a class="entry-thumbnail" href="">
                        						    <img src="/<?php echo e($cart->options->image); ?>" alt="">
                        						</a>
                        					</td>
                        					<td class="cart-product-quantity">
                        						<div stye="display:flex;">
                        				            <button class="btn btn-danger"  onclick="decreaseQty('<?php echo e($cart->rowId); ?>',<?php echo e($cart->id); ?>,<?php echo e($cart->qty); ?>)" id="decrease-<?php echo e($cart->id); ?>" <?php echo e($cart->qty > 1 ? '' : 'disabled'); ?>>-</button>
                        				            <button class="btn" id="qty-<?php echo e($cart->id); ?>"><?php echo e($cart->qty); ?></button>
                        				            <button class="btn btn-success" id="increase-<?php echo e($cart->id); ?>"  onclick="increaseQty('<?php echo e($cart->rowId); ?>',<?php echo e($cart->id); ?>,<?php echo e($cart->qty); ?>)">+</button>
                        			              </div>
                        		            </td>
                        					<td class="cart-product-sub-total"><span class="cart-sub-total-price">৳ <?php echo e($cart->price); ?></span></td> 
                        					<td class="romove-item">
                        					
                        						<a href="<?php echo e(route('cart.remove',$cart->rowId)); ?>" title="cancel" class="btn icon remove-cart-product"><i class="fa fa-trash-o"></i>
                        						</a>
                        					</td>
                    					</tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        No Item Found
                                    <?php endif; ?>
                                </tbody><!-- /tbody -->
                            </table><!-- /table -->
                        </div>
                    </div><!-- /.shopping-cart-table -->

                    <div class="col-md-6 col-sm-12 estimate-ship-tax">
                        <table class="table" id="coupon-section">

                            <thead>
                                <tr>
                                    <th>
                                        <span class="estimate-title">Discount Code</span>
                                        <p>Enter your coupon code if you have one..</p>
                                    </th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>
                                        <div class="form-group">
                                            <input type="text" class="form-control unicase-form-control text-input"
                                                placeholder="You Coupon.." id="coupon-code">
                                        </div>
                                        <div class="clearfix pull-right">
                                            <button type="submit" id="coupon-btn" class="btn-upper btn btn-primary">APPLY
                                                COUPON</button>
                                        </div>
                                    </td>
                                </tr>
                            </tbody><!-- /tbody -->

                        </table><!-- /table -->
                    </div><!-- /.estimate-ship-tax -->

                    <div class="col-md-6 col-sm-12 cart-shopping-total">
                        <table class="table">
                            <thead>
                                <tr id="total-amount">

                                </tr>
                            </thead><!-- /thead -->
                            <tbody>
                                <tr>
                                    <td>
                                        <div class="cart-checkout-btn pull-right">
                                            <a href="<?php echo e(route('user.checkout')); ?>" style="font-weight:600;"
                                                class="btn btn-primary checkout-btn">PROCCED TO CHEKOUT</a>
                                        </div>
                                    </td>
                                </tr>
                            </tbody><!-- /tbody -->
                        </table><!-- /table -->
                    </div><!-- /.cart-shopping-total -->
                    <?php else: ?>
                        <div class="text-center">Your Cart is empty</div>
                    <?php endif; ?>
                </div><!-- /.shopping-cart -->
                
            </div> <!-- /.row -->

            <!-- ============================================== BRANDS CAROUSEL ============================================== -->
            <?php echo $__env->make('frontend.inc.brand-carousel', ['brands' => $brands], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <!-- ======= BRANDS CAROUSEL : END=========== -->
        </div><!-- /.container -->
    </div><!-- /.body-content -->

<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <script type="text/javascript">
        //Increase Quantity
        function increaseQty(rawId,productId,qty) {
         
            
            axios.get("<?php echo e(url('/cart/quantity/increase')); ?>/" + rawId)
                .then(function(response) {
                  
                    if (response.status === 200) {
                        
                         let id = `qty-${productId}` 
                        
                        $(`#${id}`).html(response.data.qty)
                        
                        $('#cart-table').empty();
                        $('#total-amount').empty();

                     
                        discountWithCoupon();

                    }
                })
        }

        //Decrease Quantity
        function decreaseQty(rawId,productId,qty) {
            
          
              
            axios.get("<?php echo e(url('/cart/quantity/decrease')); ?>/" + rawId)
                .then(function(response) {
                    if (response.status === 200) {
 
                        let id = `qty-${productId}`
                        
                        $(`#${id}`).html(response.data.qty);
                        
                        $('#cart-table').empty();
                        $('#total-amount').empty();
                      
                        discountWithCoupon();

                    }
                })
        }

        function discountWithCoupon() {
            axios.get("<?php echo e(url('/coupon/discount')); ?>")
                .then(function(response) {

                    $('#total-amount').empty();
                    
                    if (response.status === 200) {
                        
                        if (response.data.hasCoupon) {

                            $('<th>').html(
                                `<div class="cart-sub-total">
								Subtotal<span class="inner-left-md">৳${response.data.subtotal}</span>
							</div>
							<div class="cart-sub-total">
								Coupon<span class="inner-left-md">${response.data.coupon}</span>
								<button class="btn" id="remove-coupon" onclick="removeCoupon()"><i class="fa fa-times"></i></button>
							</div>
							<div class="cart-sub-total">
								Discount<span class="inner-left-md">৳${response.data.discount}</span>
							</div>
							<div class="cart-grand-total">
								Grand Total<span class="inner-left-md">৳${response.data.totalAmount}</span>
							</div>`
                            ).appendTo('#total-amount');
                        } else {
                            let total = response.data.cartTotal;
                            $('<th>').html(
                                `<div class="cart-sub-total">
							Subtotal<span class="inner-left-md">৳${total}</span>
						</div>
						<div class="cart-grand-total">
							Grand Total<span class="inner-left-md">৳${total}</span>
						</div>`
                            ).appendTo('#total-amount');
                        }
                    }
                })
                .catch(function(error) {
                    alert(error)
                })
        }

        //Coupon Apply
        $('#coupon-btn').on('click', function() {
            let couponCode = $('#coupon-code').val();
            axios.post("/coupon/apply", {
                    'coupon_code': couponCode,
                    '_token': "<?php echo e(csrf_token()); ?>"
                })
                .then(function(response) {
 
                       
                  
                    discountWithCoupon();
                    
                    if (response.status === 200) {
                        const ApplyCoupon = Swal.mixin({
                            Toast: true,
                            position: 'top-end',
                            showConfirmButton: false,
                            timer: 2000,
                        })
                       
                        
                        if ($.isEmptyObject(response.data.success)) {
                            ApplyCoupon.fire({
                                icon: 'error',
                                text: response.data.error,
                            })
                        } else {
                            
                            $('#coupon-section').hide();
                    
                            ApplyCoupon.fire({
                                icon: 'success',
                                text: response.data.success,
                            })
                        }
                    }
                })
                .catch(function(error) {
                    alert(error);
                })
        })
        discountWithCoupon();

        function removeCoupon() {
            axios.get("<?php echo e(url('/coupon/remove')); ?>")
                .then(function(response) {
                    $('#coupon-section').show();
                    $('#coupon-code').val('');
                    discountWithCoupon();

                    if (response.status === 200) {
                        const removeAlert = Swal.mixin({
                            toast: true,
                            position: 'top-end',
                            showConfirmButton: false,
                            timer: 2000
                        })
                        if ($.isEmptyObject(response.data.error)) {

                            removeAlert.fire({
                                icon: 'success',
                                text: response.data.success,
                            })
                        } else {
                            removeAlert.fire({
                                icon: 'error',
                                text: "Something Went Wrong",
                            })
                        }

                    }
                })
                .catch(function(error) {
                    alert(error)
                })
        }
        
       
        $('#all-item').click(function() {
            
            const is_checkout = "<?php echo e($checkoutAll); ?>" ? false : true;
            
            axios.post("<?php echo e(route('checkout-action')); ?>",{
                'is_checkout': is_checkout,
                '_token': "<?php echo e(csrf_token()); ?>"
                
            })
                .then(function(response) {
                    

                    if (response.status === 200) {
                        
                        discountWithCoupon();
                        Swal.fire({
                            toast: true,
                            position: 'top-end',
                            showConfirmButton: false,
                            timer: 2000,
                            icon: 'success',
                            text: "All item checkout status changed",
                        })
                        
                        window.location.reload();
                        
                    }
                })
                .catch(function(error) {
                    console.log(error)
                })
        });

        function handleIsCheckkout(rowId){
            let url = '/cart/single-checkout-action/'+rowId
            axios.get(url)
                .then(function(response) {
                    

                    if (response.status === 200) {
                        
                        discountWithCoupon();
                        Swal.fire({
                            toast: true,
                            position: 'top-end',
                            showConfirmButton: false,
                            timer: 2000,
                            icon: 'success',
                            text: "Selected Item checkout status changed",
                        })
                        
                        window.location.reload();
                        
                    }
                })
                .catch(function(error) {
                    console.log(error)
                })
        }
     
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.frontend-layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/epeccomb/steelbazar.com/resources/views/user/cart.blade.php ENDPATH**/ ?>