
<div class="product">
    <div class="product-image">
        <div class="image">
            <a href="<?php echo e(route('product.detail', ['id' => $product->id, 'slug' => $product->product_slug_en])); ?>">
                <img src="<?php echo e(asset($product->product_thumbnail)); ?>" alt="<?php echo e($product->product_name_en); ?>">
            </a>
        </div><!-- /.image -->

        <?php if($product->discount == null): ?>
            <div class="tag new">
                <span>
                    New
                </span>
            </div>
        <?php else: ?>
            <div class="tag hot">
                <span>
                    <?php if($product->discount_type == 'flat'): ?>
                        
                        <?php echo e($product->discount); ?> TK Off
                    <?php else: ?>
                        <?php echo e($product->discount); ?>% Off
                    <?php endif; ?>
                </span>
            </div>
        <?php endif; ?>
    </div><!-- /.product-image -->


    <div class="product-info text-left">
        <h3 class="name">
            <a href="<?php echo e(route('product.detail', ['id' => $product->id, 'slug' => $product->product_slug_en])); ?>">
                <?php echo e($product->product_name_en); ?>

            </a>
        </h3>
        <div class="rating" style="color: #ffc808">
            <?php
                
                $rating = $product->reviews->avg('rating');
            ?>
            <?php for($i = 1; $i <= 5; $i++): ?>
                <i class="glyphicon glyphicon-star<?php echo e($i <= $rating ? '' : '-empty'); ?>"></i>
            <?php endfor; ?>
        </div>
        <div class="description"></div>

        <div class="product-price">
            <?php if($product->discount == null): ?>
                <span class="price">
                    ৳<?php echo e($product->discount_price); ?>

                </span>
            <?php else: ?>
                <span class="price">
                    ৳<?php echo e($product->discount_price); ?>

                </span>
                <span class="price-before-discount">
                    ৳<?php echo e($product->selling_price); ?>

                </span>
            <?php endif; ?>
                <a href="<?php echo e(route('product.detail', ['id' => $product->id, 'slug' => $product->product_slug_en])); ?>" id="mobile-view-btn" class="btn btn-primary icon"><i class="fa fa-eye"></i> View</a>

        </div><!-- /.product-price -->

    </div><!-- /.product-info -->
    <div class="cart clearfix animate-effect" id="desktop-view-btn">
        <div class="action">
            <ul class="list-unstyled">
                <li class="add-cart-button btn-group">
                    <!--<button data-toggle="modal" id="product-view" onClick="viewProduct(<?php echo e($product->id); ?>)"-->
                    <!--    data-target="#view-product-modal" class="btn btn-primary icon" type="button"-->
                    <!--    data-original-title="View Product" title="">-->
                    <!--    <i class="fa fa-eye"></i>-->
                    <!--</button>-->
                    <a class="btn btn-primary icon" href="<?php echo e(route('product.detail', ['id' => $product->id, 'slug' => $product->product_slug_en])); ?>"
                        data-original-title="View Product" title="View Product">
                        <i class="fa fa-eye"></i>
                    </a>



                </li>

                <li>
                    <input type="hidden" name="wishlist_add" value="<?php echo e($product->id); ?>">
                    
                    <button onclick="addToWishList(<?php echo e($product->id); ?>)" data-toggle="tooltip"
                        class="btn add-to-wishlist" title="" data-original-title="Wishlist">
                        <i class="icon fa fa-heart"></i>
                    </button>
                </li>


            </ul>
        </div><!-- /.action -->
    </div><!-- /.cart -->
</div><!-- /.product -->
<?php /**PATH /home/epeccomb/steelbazar.com/resources/views/components/product/product.blade.php ENDPATH**/ ?>