<!DOCTYPE html>
<html lang="en">

<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <!-- Twitter -->
    <meta name="twitter:site" content="@themepixels">
    <meta name="twitter:creator" content="@themepixels">
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="Starlight">
    <meta name="twitter:description" content="Premium Quality and Responsive UI for Dashboard.">
    <meta name="twitter:image" content="http://themepixels.me/starlight/img/starlight-social.png">

    <!-- Facebook -->
    <meta property="og:url" content="http://themepixels.me/starlight">
    <meta property="og:title" content="Starlight">
    <meta property="og:description" content="Premium Quality and Responsive UI for Dashboard.">

    <meta property="og:image" content="http://themepixels.me/starlight/img/starlight-social.png">
    <meta property="og:image:secure_url" content="http://themepixels.me/starlight/img/starlight-social.png">
    <meta property="og:image:type" content="image/png">
    <meta property="og:image:width" content="1200">
    <meta property="og:image:height" content="600">

    <!-- Meta -->
    <meta name="description" content="Premium Quality and Responsive UI for Dashboard.">
    <meta name="author" content="ThemePixels">

    <style>
        @import  'https://fonts.googleapis.com/css?family=Open+Sans:600,700';

        * {
            font-family: 'Open Sans', sans-serif;
        }

        .rwd-table {
            margin: auto;
            min-width: 300px;
            max-width: 100%;
            border-collapse: collapse;
        }

        .rwd-table tr {
            border-top: 1px solid #ddd;
            border-bottom: 1px solid #ddd;
            background-color: #f5f9fc;
        }

        .rwd-table tr:nth-child(odd):not(:first-child) {
            background-color: #ebf3f9;
        }

        .rwd-table th {
            display: none;
        }

        .rwd-table td {
            display: block;
        }

        .rwd-table td:first-child {
            margin-top: .5em;
        }

        .rwd-table td:last-child {
            margin-bottom: .5em;
        }

        .rwd-table td:before {
            content: attr(data-th) ": ";
            font-weight: bold;
            width: 120px;
            display: inline-block;
            color: #000;
        }

        .rwd-table th,
        .rwd-table td {
            text-align: left;
        }

        .rwd-table {
            color: #333;
            border-radius: .4em;
            overflow: hidden;
        }

        .rwd-table tr {
            border-color: #bfbfbf;
        }

        .rwd-table th,
        .rwd-table td {
            padding: .5em 1em;
        }

        @media  screen and (max-width: 601px) {
            .rwd-table tr:nth-child(2) {
                border-top: none;
            }
        }

        @media  screen and (min-width: 600px) {
            .rwd-table tr:hover:not(:first-child) {
                background-color: #d8e7f3;
            }

            .rwd-table td:before {
                display: none;
            }

            .rwd-table th,
            .rwd-table td {
                display: table-cell;
                padding: .25em .5em;
            }

            .rwd-table th:first-child,
            .rwd-table td:first-child {
                padding-left: 0;
            }

            .rwd-table th:last-child,
            .rwd-table td:last-child {
                padding-right: 0;
            }

            .rwd-table th,
            .rwd-table td {
                padding: 1em !important;
            }
        }

        body {
            background: #4B79A1;
            background: -webkit-linear-gradient(to left, #4B79A1, #283E51);
            background: linear-gradient(to left, #4B79A1, #283E51);
        }

        h1 {
            text-align: center;
            font-size: 2.4em;
            color: #f2f2f2;
        }

        .container {
            display: block;
            text-align: center;
        }

        h3 {
            display: inline-block;
            position: relative;
            text-align: center;
            font-size: 1.5em;
            color: #cecece;
        }

        h3:before {
            content: "\25C0";
            position: absolute;
            left: -50px;
            -webkit-animation: leftRight 2s linear infinite;
            animation: leftRight 2s linear infinite;
        }

        h3:after {
            content: "\25b6";
            position: absolute;
            right: -50px;
            -webkit-animation: leftRight 2s linear infinite reverse;
            animation: leftRight 2s linear infinite reverse;
        }

        @-webkit-keyframes leftRight {
            0% {
                -webkit-transform: translateX(0)
            }

            25% {
                -webkit-transform: translateX(-10px)
            }

            75% {
                -webkit-transform: translateX(10px)
            }

            100% {
                -webkit-transform: translateX(0)
            }
        }

        @keyframes  leftRight {
            0% {
                transform: translateX(0)
            }

            25% {
                transform: translateX(-10px)
            }

            75% {
                transform: translateX(10px)
            }

            100% {
                transform: translateX(0)
            }
        }


        .flex-item {
            width: 50%;
            float: left;
        }
    </style>
</head>

<body>

    <div class="sl-mainpanel">

        <div class="sl-pagebody">
            <div class="row row-sm">
                <div class="col-12">
                    <div class="card pd-10 pd-sm-20">
                        <h6 style="font-size: 22px; text-transform:uppercase; text-align:center;">Quote From
                            --<?php echo e($quote->name); ?> -- for
                            <?php echo e($quote->product->product_name_en); ?></h6>
                        <div class="flex">
                            <div class="flex-item">
                                <table class="rwd-table">
                                    <tr>
                                        <th>Name</th>
                                        <td><?php echo e($quote->name); ?></td>
                                    </tr>
                                    <tr>
                                        <th>Phone Number</th>
                                        <td><?php echo e($quote->phone); ?></td>
                                    </tr>
                                    <tr>
                                        <th>Email Address</th>
                                        <td><?php echo e($quote->email); ?></td>
                                    </tr>
                                    <tr>
                                        <th>Company Or Busienss Name </th>
                                        <td><?php echo e($quote?->b_name ? $quote?->b_name : '--'); ?></td>
                                    </tr>
                                    <tr>
                                        <th>Requirments </th>
                                        <td><?php echo e($quote->requirments); ?></td>
                                    </tr>
                                </table>

                            </div>
                            <div class="flex-item">
                                <table class="rwd-table">
                                    <tr>
                                        <th>Prodcut ID</th>
                                        <td><?php echo e($quote->product->id); ?></td>
                                    </tr>
                                    <tr>
                                        <th>Prodcut Name</th>
                                        <td><?php echo e($quote->product->product_name_en); ?></td>
                                    </tr>
                                    <tr>
                                        <th>Product Stock Quantity</th>
                                        <td><?php echo e($quote->product->product_quantity_en); ?></td>
                                    </tr>
                                    <tr>
                                        <th>Requirement Quantity</th>
                                        <td><?php echo e($quote->qty); ?></td>
                                    </tr>
                                    <tr>
                                        <th>Price</th>
                                        <td><?php echo e($quote->product->discount_price); ?> TK</td>
                                    </tr>
                                </table>

                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div><!-- sl-mainpanel -->


</body>

</html>
<?php /**PATH /home/epeccomb/steelbazar.com/resources/views/admin/quote/invoice.blade.php ENDPATH**/ ?>