
<?php $__env->startSection('title','Edit State | Shipping Area'); ?>
<?php $__env->startSection('shipping-area','active show-sub'); ?>
<?php $__env->startSection('state','active'); ?>
<?php $__env->startSection('content'); ?>
<nav class="breadcrumb sl-breadcrumb">
  <a class="breadcrumb-item" href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a>
  <span class="breadcrumb-item active">State Edit</span>
</nav>

<div class="sl-pagebody">
    <div class="row row-sm">
        <div class="col-md-12">
            <div class="card pd-10 pd-sm-20">
                <h6 class="card-body-title">Edit State</h6>
                <form action="<?php echo e(route('shipping.state.update',['id'=>$state->id])); ?>" class="form-layout" method="POST">
                    <?php echo method_field('PUT'); ?>
                    <?php echo csrf_field(); ?>
                    <div class="form-group">
                        <label class="form-control-label">Select Division: <span class="tx-danger">*</span></label>
                        <select class="form-control select2 select2-show-search" name="division_id" id="division" data-placeholder="Choose one" style="height: 35px; padding:0 10px;">
                            <option label="Choose one" style="height: 25px; padding:0 10px;"></option>
                            <?php $__currentLoopData = $divisions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $division): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($division->id); ?>" name="division_id" <?php echo e($state->division_id==$division->id ? 'selected': ''); ?> style="height: 25px; padding:0 10px;"><?php echo e($division->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <?php $__errorArgs = ['parent_category'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="text-danger"><?php echo e($message); ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="form-group">
                        <label class="form-control-label">Select District: <span class="tx-danger">*</span></label>
                        <select class="form-control select2 select2-show-search" name="district_id" id="district" data-placeholder="Choose one">
                            <option value="<?php echo e($state->district->id); ?>" name="division_id"><?php echo e($state->district->name); ?></option>
                        </select>
                        <?php $__errorArgs = ['district_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="text-danger"><?php echo e($message); ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="form-group">
                        <label class="form-control-label">State Name: <span class="tx-danger">*</span></label>
                        <input class="form-control" type="text" name="name" value="<?php echo e($state->name); ?>" placeholder="Enter State Name">
                        <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="text-danger"><?php echo e($message); ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="form-layout-footer">
                        <button class="btn btn-info mg-r-5">Update</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>

<script src="<?php echo e(asset('assets/backend/js/axios.min.js')); ?>" type="text/javascript"></script>
    <script type="text/javascript">
    
        $('#division').on('change',function () {
            let id=$(this).val();
            console.log(id);
            axios.get("<?php echo e(url('/admin/district/get')); ?>/"+id)
            .then(function (response) {
                if (response.status===200) {
                    $('#district').empty();
                    let districts=response.data;
                    $.each(districts,function (i,district) {
                        $('#district').append(
                            '<option value="'+district.id+'">'+district.name+'</option>'
                        )
                    })
                }
            }).catch(function (error) {
                
            })
        })
        <?php if(session()->has('error')): ?>
            Swal.fire({
                icon:'error',
                text:"<?php echo e(session('error')); ?>"
            })
        <?php endif; ?>
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin-layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/steellbaazaar/public_html/resources/views/admin/shipping-area/state/edit-state.blade.php ENDPATH**/ ?>