<?php

use App\Http\Controllers\Admin\AdminController;
use App\Http\Controllers\Admin\AttributeController;
use App\Http\Controllers\Admin\BrandController;
use App\Http\Controllers\Admin\CategoryController;
use App\Http\Controllers\Admin\CouponController;
use App\Http\Controllers\Admin\DealController;
use App\Http\Controllers\Admin\OptionController;
use App\Http\Controllers\Admin\OrderController as AdminOrderController;
use App\Http\Controllers\Admin\ProductController;
use App\Http\Controllers\Admin\QuoteController;
use App\Http\Controllers\Admin\SettingController;
use App\Http\Controllers\Admin\ShippingAreaController;
use App\Http\Controllers\Admin\ShippingCostController;
use App\Http\Controllers\Admin\SliderController;
use App\Http\Controllers\Admin\SubCategoryController;
use App\Http\Controllers\Admin\SubSubCategoryController;
use App\Http\Controllers\Admin\UserManageController;
use App\Http\Controllers\AmaarpayController;
use App\Http\Controllers\CODController;
use App\Http\Controllers\Frontend\CartController;
use App\Http\Controllers\Frontend\HomeController;
use App\Http\Controllers\Frontend\LanguageController;
use App\Http\Controllers\Frontend\SearchControler;
use App\Http\Controllers\Frontend\SiteController;
use App\Http\Controllers\Frontend\WishListController;
use App\Http\Controllers\SocialLoginController;
use App\Http\Controllers\SslCommerzPaymentController;
use App\Http\Controllers\User\BuyController;
use App\Http\Controllers\User\CheckoutController;
use App\Http\Controllers\User\OrderController;
use App\Http\Controllers\User\PaymentController;
use App\Http\Controllers\User\ReviewController;
use App\Http\Controllers\User\UserController;
use App\Http\Controllers\Auth\LoginController;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Route;
use Gloudemans\Shoppingcart\Facades\Cart;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
 */

Auth::routes();


Route::get('test',function(){
    
    $cartItems = Cart::content();

    $checkoutItems = $cartItems->filter(function ($item) {
        return $item->options->has('is_checkout') && $item->options->get('is_checkout') === true;
    });
    dd(\App\Helpers\Supports::getCartCheckoutTotalItem());
});
Route::get('/cache/clear',function(){
    Artisan::call('cache:clear');
    Artisan::call('route:clear');
    Artisan::call('view:clear');
    Artisan::call('config:clear');
    echo "Cache Cleared";
});

//Route::get( '/home', [App\Http\Controllers\HomeController::class, 'index'] )->name( 'home' );

//*********************Admin Route**************************

Route::middleware(['auth', 'admin'])->prefix('admin')->group(function ()
{
    Route::get('/dashboard', [AdminController::class, 'index'])->name('admin.dashboard');

    //Admin Profile Routes
    Route::get('/profile', [AdminController::class, 'showProfile'])->name('admin.profile');
    Route::get('/profile/edit', [AdminController::class, 'editProfile'])->name('admin.profile.edit');
    Route::patch('/profile/update', [AdminController::class, 'updateProfile'])->name('admin.profile.update');

    //Admin Profile Image Edit Routes
    Route::get('/profile/avater/edit', [AdminController::class, 'editAvater'])->name('admin.avater.edit');
    Route::patch('profile/avater/update', [AdminController::class, 'updateAvater'])->name('admin.avater.update');

    //Admin Password Change Routes
    Route::get('password/edit', [AdminController::class, 'editPassword'])->name('admin.password.edit');
    Route::patch('password/update', [AdminController::class, 'updatePassword'])->name('admin.password.update');

    // Brand Routes
    Route::get('/brands', [BrandController::class, 'index'])->name('admin.brand');
    Route::post('/brand/store', [BrandController::class, 'store'])->name('brand.add');
    Route::get('/brand/edit/{id}', [BrandController::class, 'editBrand'])->name('admin.brand.edit');
    Route::put('/brand/update/{id}', [BrandController::class, 'updateBrand'])->name('admin.brand.update');
    Route::get('/brand/delete/{id}', [BrandController::class, 'deleteBrand'])->name('admin.brand.delete');

    //Category Routes
    Route::get('/categories', [CategoryController::class, 'index'])->name('admin.category');
    Route::post('/category/add-category', [CategoryController::class, 'store'])->name('admin.category.store');
    Route::get('/category/edit/{id}', [CategoryController::class, 'edit'])->name('admin.category.edit');
    Route::put('/category/update/{id}', [CategoryController::class, 'update'])->name('admin.category.update');
    Route::get('/category/delete/{id}', [CategoryController::class, 'delete'])->name('admin.category.delete');
    //Sub Category  Routes
    Route::get('/sub-categories', [SubCategoryController::class, 'index'])->name('admin.subCategory');
    Route::post('/sub-category/store', [SubCategoryController::class, 'store'])->name('admin.subCategory.store');
    Route::get('/sub-category/edit/{id}', [SubCategoryController::class, 'editSubCategory'])->name('admin.subCategory.edit');
    Route::put('/sub-category/update/{id}', [SubCategoryController::class, 'update'])->name('admin.subCategory.update');
    Route::get('/sub-category/delete/{id}', [SubCategoryController::class, 'delete'])->name('admin.subCategory.delete');
    //Sub Sub Category Routes
    Route::get('/sub/sub-categories', [SubSubCategoryController::class, 'index'])->name('admin.subSubCategory');
    Route::get('/sub/sub-category/filter/{id}', [SubSubCategoryController::class, 'filterSubCategory'])->name('admin.subCategory.filter');
    Route::post('/sub/sub-category/store', [SubSubCategoryController::class, 'store'])->name('admin.subSubCategory.store');
    Route::get('/sub/sub-category/{id}', [SubSubCategoryController::class, 'edit'])->name('admin.subSubCategory.edit');
    Route::patch('/sub/sub-category/update/{id}', [SubSubCategoryController::class, 'update'])->name('admin.subSubCategory.update');
    Route::get('/sub/sub-category/delete/{id}', [SubSubCategoryController::class, 'delete'])->name('admin.subSubCategory.delete');

    //Route for Ajax and Axios Request

    Route::get('/sub/sub-category/filter/{id}', [SubSubCategoryController::class, 'filterSubCategory'])->name('admin.subCategory.filter');
    Route::get('/sub/sub/sub-category/filter/{id}', [SubSubCategoryController::class, 'filterSubSubCategory'])->name('admin.subSubCategory.filter');

    //Product Routes
    Route::get('/all-products', [ProductController::class, 'index'])->name('products.all');
    Route::get('/add-product', [ProductController::class, 'create'])->name('product.create');
    Route::post('/add-product/store', [ProductController::class, 'store'])->name('product.store');
    Route::get('product/edit/{id}', [ProductController::class, 'edit'])->name('product.edit');
    Route::patch('product/update/{id}', [ProductController::class, 'update'])->name('product.update');
    Route::patch('product/update-image/{id}', [ProductController::class, 'updateImage'])->name('product.update.image');
    Route::get('/product/delete/{id}', [ProductController::class, 'delete'])->name('product.delete');
    Route::get('product/edit-images/{id}', [ProductController::class, 'editImage'])->name('prouct.edit.image');
    Route::patch('product/thumbnail/update/{id}', [ProductController::class, 'thumbnailUpdate'])->name('product.thumbnail.update');
    Route::get('/product/image/delete/{id}', [ProductController::class, 'deleteProductImage'])->name('product.image.delete');
    Route::post('product/add-images/{id}', [ProductController::class, 'addProductImages'])->name('product.images.store');
    Route::get('/product/active/{id}', [ProductController::class, 'activeProduct'])->name('product.active');
    Route::get('/product/inactive/{id}', [ProductController::class, 'inactiveProduct'])->name('product.inactive');
    Route::post('/product/search', [ProductController::class, 'search'])->name('admin.product.search');
    // Product Attribute
    Route::get('/all-attributes', [AttributeController::class, 'index'])->name('product.attributes');
    Route::post('/attribute/store', [AttributeController::class, 'store'])->name('product.attribute.store');
    Route::get('/attribute/edit/{id}', [AttributeController::class, 'edit'])->name('product.attribute.edit');
    Route::put('/attribute/update/{id}', [AttributeController::class, 'update'])->name('product.attribute.update');
    Route::get('/attribute/delete/{id}', [AttributeController::class, 'destroy'])->name('product.attribute.delete');

    //Slider Routes
    Route::get('/slider/active/{id}', [SliderController::class, 'activeSlide'])->name('slider.active');
    Route::get('/slider/delete/{id}', [SliderController::class, 'delete'])->name('slider.delete');
    Route::get('/slider/inactive/{id}', [SliderController::class, 'inactiveSlide'])->name('slider.inactive');
    Route::resource('slider', \App\Http\Controllers\Admin\SliderController::class);

    //Coupon Routes
    Route::get('/shipping-costs', [ShippingCostController::class, 'index'])->name('admin.shipping.cost');
    Route::post('/shipping-costs/store', [ShippingCostController::class, 'store'])->name('admin.shipping.cost.store');
    Route::get('/shipping-costs/edit/{id}', [ShippingCostController::class, 'edit'])->name('admin.shipping.cost.edit');
    Route::put('/shipping-costs/update/{id}', [ShippingCostController::class, 'update'])->name('admin.shipping.cost.update');
    Route::get('/shipping-costs/delete/{id}', [ShippingCostController::class, 'destroy'])->name('admin.shipping.cost.delete');

    //Coupon Routes
    Route::get('/coupons', [CouponController::class, 'index'])->name('admin.coupon');
    Route::post('/coupon/store', [CouponController::class, 'store'])->name('admin.coupon.store');
    Route::get('/coupon/edit/{id}', [CouponController::class, 'edit'])->name('admin.coupon.edit');
    Route::put('/coupon/update/{id}', [CouponController::class, 'update'])->name('admin.coupon.update');
    Route::get('/coupon/delete/{id}', [CouponController::class, 'delete'])->name('admin.coupon.delete');

    // Deal Routes
    Route::get('/deal/all-deal', [DealController::class, 'index'])->name('admin.deals');
    Route::get('/deal/create', [DealController::class, 'create'])->name('admin.deal.create');
    Route::post('/deal/store', [DealController::class, 'store'])->name('admin.deal.store');
    Route::get('/deal/edit/{id}', [DealController::class, 'edit'])->name('admin.deal.edit');
    Route::put('/deal/update/{id}', [DealController::class, 'update'])->name('admin.deal.update');
    Route::get('/deal/delete/{id}', [DealController::class, 'destroy'])->name('admin.deal.delete');
    //Shipping Area Routes

    //Division Routes
    Route::get('/divisions', [ShippingAreaController::class, 'indexDivision'])->name('shipping.division');
    Route::post('/division/store', [ShippingAreaController::class, 'storeDivision'])->name('shipping.division.store');
    Route::get('/division/edit/{id}', [ShippingAreaController::class, 'editDivision'])->name('shipping.division.edit');
    Route::put('/division/update/{id}', [ShippingAreaController::class, 'updateDivision'])->name('shipping.division.update');
    Route::get('/division/delete/{id}', [ShippingAreaController::class, 'deleteDivision'])->name('shipping.division.delete');

    //District  Routes

    Route::get('/districts', [ShippingAreaController::class, 'indexDistrict'])->name('shipping.district');
    Route::post('/district/store', [ShippingAreaController::class, 'storeDistrict'])->name('shipping.district.store');
    Route::get('/district/edit/{id}', [ShippingAreaController::class, 'editDistrict'])->name('shipping.district.edit');
    Route::put('/district/update/{id}', [ShippingAreaController::class, 'updateDistrict'])->name('shipping.district.update');
    Route::get('/district/delete/{id}', [ShippingAreaController::class, 'deleteDistrict'])->name('shipping.district.delete');

    //State Routes

    Route::get('/states', [ShippingAreaController::class, 'indexState'])->name('shipping.state'); Route::post('/state/store', [ShippingAreaController::class, 'storeState'])->name('shipping.state.store');
    Route::get('/state/edit/{id}', [ShippingAreaController::class, 'editState'])->name('shipping.state.edit');
    Route::put('/state/update/{id}', [ShippingAreaController::class, 'updateState'])->name('shipping.state.update');
    Route::get('/state/delete/{id}', [ShippingAreaController::class, 'deleteState'])->name('shipping.state.delete');

    //Route for district with Axios
    Route::get('/district/get/{id}', [ShippingAreaController::class, 'getDistrict']);

    //Admin Order Route
    Route::get('/all-order', [AdminOrderController::class, 'index'])->name('admin.order.all');
    Route::get('order/confirmed', [AdminOrderController::class, 'confirmedOrder'])->name('admin.order.confirmed');
    Route::get('order/processed', [AdminOrderController::class, 'processingOrder'])->name('admin.order.processed');
    Route::get('order/shipped', [AdminOrderController::class, 'shippedOrder'])->name('admin.order.shipped');
    Route::get('order/picked', [AdminOrderController::class, 'pickedOrder'])->name('admin.order.picked');
    Route::get('order/delievered', [AdminOrderController::class, 'delieveredOrder'])->name('admin.order.delievered');
    Route::patch('order/cancel-now', [AdminOrderController::class, 'toCancel'])->name('admin.order.cancel');
    Route::get('order/canceled', [AdminOrderController::class, 'canceledOrder'])->name('admin.order.canceled');
    Route::get('order/retured', [AdminOrderController::class, 'returedOrder'])->name('admin.order.returned');
    //Admin Order Detail Route
    Route::get('/order/detail/{order_id}', [AdminOrderController::class, 'orderDetail'])->name('admin.order.detail');
    Route::get('order/confirm/{order_id}', [AdminOrderController::class, 'toConfirm'])->name('admin.order.confirm');
    Route::get('order/processing/{order_id}', [AdminOrderController::class, 'toProcessing'])->name('admin.order.processing');
    Route::get('order/shipped/{order_id}', [AdminOrderController::class, 'toShipped'])->name('admin.order.ship');
    Route::get('order/picked/{order_id}', [AdminOrderController::class, 'toPicked'])->name('admin.order.pick');
    Route::get('order/delieverd/{order_id}', [AdminOrderController::class, 'toDelieverd'])->name('admin.order.deliever');
    Route::get('order/delete/{id}', [AdminOrderController::class, 'delete'])->name('admin.order.delete');
    //User Manage Route
    // Page Routes
    Route::resource('/page', \App\Http\Controllers\Admin\PageController::class);
    Route::get('users/all', [UserManageController::class, 'index'])->name('admin.user.all');
    Route::get('/user/delete/{id}', [UserManageController::class, 'destroy'])->name('admin.user.destroy');
    Route::get('/user/suspend/{id}', [UserManageController::class, 'suspend'])->name('admin.user.suspend');
    Route::get('/user/continue/{id}', [UserManageController::class, 'continue'])->name('admin.user.continue');
    //Review Route
    Route::get('/reviews', [ReviewController::class, 'index'])->name('admin.review.all');
    Route::get('/review/approve/{id}', [ReviewController::class, 'approve'])->name('admin.review.approve');
    Route::get('/review/unapprove/{id}', [ReviewController::class, 'unApprove'])->name('admin.review.unapprove');
    Route::get('/review/delete/{id}', [ReviewController::class, 'destroy'])->name('admin.review.delete');
    Route::get('/settings', [SettingController::class, 'index'])->name('admin.setting.index');
    Route::patch('/setting/title-update', [SettingController::class, 'titleUpdate'])->name('admin.setting.title');
    Route::patch('/setting/address-update', [SettingController::class, 'addressUpdate'])->name('admin.setting.address');
    Route::patch('/setting/logo-update', [SettingController::class, 'logoUpdate'])->name('admin.setting.logo');
    Route::patch('/setting/favicon-update', [SettingController::class, 'faviconUpdate'])->name('admin.setting.favicon');
    Route::patch('/setting/seo-title-update', [SettingController::class, 'seoTitleUpdate'])->name('admin.setting.seo.tilte');
    Route::patch('/setting/seo-meta-update', [SettingController::class, 'seoMetaUpdate'])->name('admin.setting.seo.meta');
    Route::patch('/setting/seo-description-update', [SettingController::class, 'seoDescUpdate'])->name('admin.setting.seo.desc');
    Route::patch('/setting/phone-one-update', [SettingController::class, 'phoneOne'])->name('admin.setting.phone1');
    Route::patch('/setting/phone-two-update', [SettingController::class, 'phoneTwo'])->name('admin.setting.phone2');
    Route::patch('/setting/email-update', [SettingController::class, 'email'])->name('admin.setting.email');
    Route::patch('/setting/facebook-update', [SettingController::class, 'facebook'])->name('admin.setting.facebook');
    Route::patch('/setting/whatsapp-update', [SettingController::class, 'whatsapp'])->name('admin.setting.whatsapp');
    Route::patch('/setting/twitter-update', [SettingController::class, 'twitter'])->name('admin.setting.twitter');
    Route::patch('/setting/instagram-update', [SettingController::class, 'instagram'])->name('admin.setting.instagram');
    Route::patch('/setting/youtube-update', [SettingController::class, 'youtube'])->name('admin.setting.youtube');
    Route::put('/setting/mail-config', [OptionController::class, 'mailConfig'])->name('admin.setting.mail.config');
    Route::put('/setting/ssl-config', [OptionController::class, 'sslConfig'])->name('admin.setting.ssl.config');
    Route::put('/setting/amaarpay-config', [OptionController::class, 'amaarpayConfig'])->name('admin.setting.amaarpay.config');
    // Quote Route
    Route::get('/all-quote', [QuoteController::class, 'index'])->name('admin.quotes');
    Route::get('/get-product-quote/{id}', [QuoteController::class, 'show'])->name('admin.quote.show');
    Route::get('/delete-product-quote/{id}', [QuoteController::class, 'destroy'])->name('admin.quote.destroy');
    Route::get('/product-quote-invoice/{id}', [QuoteController::class, 'quoteInvoice'])->name('admin.quote.invoice');
    
});


//Frontend Routes

//Language Routes
Route::get('/english', [LanguageController::class, 'english'])->name('language.english');
Route::get('/bangla', [LanguageController::class, 'bangla'])->name('language.bangla');

Route::get('/', [HomeController::class, 'home'])->name('home');

Route::get('/product/view/{id}', [HomeController::class, 'productView'])->name('product.view');
Route::get('/product/{id}/{slug}', [HomeController::class, 'redirectToLogin'])->name('product.redirect.login');


Route::post('/product/buy', [BuyController::class, 'index'])->name('product.buy');
Route::get('cart/remove/{rowId}',[CartController::class, 'remove'])->name('cart.remove');

Route::get('/page/{slug}', [SiteController::class, 'page'])->name('page.slug');
Route::get('/product/detail/{id}/{slug}', [SiteController::class, 'productDetail'])->name('product.detail');
Route::post('/get-product-quote', [QuoteController::class, 'store'])->name('quote.store');

Route::get('/category/products/{id}/{slug}', [SiteController::class, 'categoryProduct'])->name('product.parent.category');
Route::get('/sub-category/products/{id}/{slug}', [SiteController::class, 'subCategoryProduct'])->name('product.category');
Route::get('/sub/sub-category/products/{id}/{slug}', [SiteController::class, 'subSubCategoryProduct'])->name('product.subSubCategory');
// Mini Cart Routes

Route::get('/product/remove-from-cart/{rowId}', [CartController::class, 'removeFromCart'])->name('product.cart.remove');
Route::post('/product/add-to-cart/{id}', [CartController::class, 'addToCard'])->name('product.cart.add');
Route::post('/single-product/add-to-cart/{id}', [CartController::class, 'addCard'])->name('product.add.cart');
Route::get('/product/mini-cart/view', [CartController::class, 'viewCart'])->name('product.cart.view');
//Wishlist Route
Route::post('/user/wishlist-add/{id}', [WishListController::class, 'create'])->name('user.wishlist');
//Cart Routes
Route::get('/cart/products', [CartController::class, 'index'])->name('user.cart.index');
Route::get('/cart/quantity/increase/{rawId}', [CartController::class, 'increaseQty']);
Route::get('/cart/quantity/decrease/{rawId}', [CartController::class, 'decreaseQty']);

Route::post('cart/checkout-action', [CartController::class, 'checkoutAction'])->name('checkout-action');


Route::get('cart/single-checkout-action/{rawId}', [CartController::class, 'singleCheckoutAction'])->name('single-checkout-action');

//Coupon Routes
Route::post('/coupon/apply', [CartController::class, 'applyCoupon'])->name('coupon.apply');
Route::get('/coupon/discount', [CartController::class, 'couponDiscount'])->name('coupon.discount');
Route::get('/coupon/remove', [CartController::class, 'removeCoupon']);
//Search Route
Route::get('search-product', [SearchControler::class, 'search'])->name('product.search');
Route::post('price-search-product', [SearchControler::class, 'priceSearch'])->name('product.search.price');
//Social Login
Route::get('/login/google', [SocialLoginController::class, 'google'])->name('user.login.google');
Route::get('/login/google/redirect', [SocialLoginController::class, 'loginGoogle'])->name('google.login.redirect');
Route::get('/login/facebook', [SocialLoginController::class, 'facebook'])->name('user.login.facebook');
Route::get('/login/facebook/redirect', [SocialLoginController::class, 'loginFacebook'])->name('facebook.login.redirect');

// SSLCOMMERZ Start

// Route::get('/example1', [SslCommerzPaymentController::class, 'exampleEasyCheckout']);
// Route::get('/example2', [SslCommerzPaymentController::class, 'exampleHostedCheckout']);

Route::post('/pay', [SslCommerzPaymentController::class, 'index']);
Route::post('/pay-via-ajax', [SslCommerzPaymentController::class, 'payViaAjax']);

Route::post('/success', [PaymentController::class, 'success']);
Route::post('/fail', [PaymentController::class, 'fail']);
Route::post('/cancel', [PaymentController::class, 'cancel']);

Route::post('/ipn', [PaymentController::class, 'ipn']);
//SSLCOMMERZ END

// AMAAR PAY START
Route::post('/amaarpay-index', [AmaarpayController::class, 'index'])->name('payment.amarpay.index');
Route::post('/amaarpay-success', [AmaarpayController::class, 'success'])->name('amaarpay.success');
Route::post('/amaarpay-fail', [AmaarpayController::class, 'fail'])->name('amaarpay.fail');

// COD
Route::post('/cod-index', [CODController::class, 'index'])->name('payment.cod.index');

// Login User
Route::post('/login/store', [LoginController::class, 'login'])->name('login.store');


//*********************User Route**************************


Route::middleware(['auth', 'user'])->prefix('user')->namespace('user')->group(function ()
{
    Route::get('/dashboard', [UserController::class, 'index'])->name('user.dashboard');

    //User Profile Routes
    Route::get('/profile', [UserController::class, 'showProfile'])->name('user.profile');
    Route::get('/profile/edit', [UserController::class, 'editProfile'])->name('user.profile.edit');
    Route::patch('/profile/store', [UserController::class, 'updateProfile'])->name('user.profile.store');
    //User Profile Image Edit Route
    Route::get('profile/image/edit', [UserController::class, 'editProfileImage'])->name('user.image.edit');
    Route::patch('/profile/image/update', [UserController::class, 'updateAvater'])->name('user.image.update');
    //User Password change Route
    Route::get('password/edit', [UserController::class, 'editPassword'])->name('user.password.edit');
    Route::patch('/password/store', [UserController::class, 'updatePassword'])->name('user.password.store');
    //User WishList Routes
    Route::get('/wishlists', [WishListController::class, 'index'])->name('user.wishlist.view');
    Route::get('/wishlist/remove-product/{id}', [WishListController::class, 'delete'])->name('user.wishlist.delete');
    //Checkout Route
    Route::get('/checkout', [CheckoutController::class, 'index'])->name('user.checkout');
    //Shipping Area With Axios Route
    Route::get('/checkout/division', [CheckoutController::class, 'getDivision']);
    Route::get('/checkout/district/{id}', [CheckoutController::class, 'getDistrict']);
    Route::get('/checkout/state/{id}', [CheckoutController::class, 'getState']);

    // Direct Buy Route
   
    Route::post('/buy/apply-coupon', [BuyController::class, 'applyCoupon'])->name('product.buy.coupon');
    Route::get('/buy/apply-coupon/discount', [BuyController::class, 'couponDiscount'])->name('product.buy.discount');
    Route::get('/buy/coupon/remove', [BuyController::class, 'removeCoupon'])->name('product.remove.coupon');
    Route::get('/buy/checkout', [BuyController::class, 'checkout'])->name('user.buy.checkout');
    Route::post('/buy/shipping-area/store', [BuyController::class, 'storeShippingInfo'])->name('buy.shipping.store');
    // Payment Routes For Direct Buy
    Route::post('/buy/payment/aamarpay', [BuyController::class, 'aamarpay'])->name('payment.amarpay.buy');
    Route::post('/buy/payment/sslcommerz', [BuyController::class, 'sslcommerzHosted'])->name('payment.sslcommerz.buy');
    Route::post('/buy/payment/cod', [BuyController::class, 'cod'])->name('payment.cod.buy');
    Route::post('/buy/payment/stripe', [BuyController::class, 'stripe'])->name('payment.stripe.buy');

    //Checkout Route
    Route::post('/checkout/shipping-area/store', [CheckoutController::class, 'storeShippingInfo'])->name('shipping.store');
    //Payment Route

    //Stripe Route
    Route::post('/payment/stripe', [PaymentController::class, 'stripe'])->name('payment.stripe');
    //SSLCommerz
    Route::post('/payment/sslcommerz/hosted-checkout', [PaymentController::class, 'sslcommerzHosted'])->name('payment.sslcommerz.hosted');
    //Order Read Route
    Route::get('/order/all', [OrderController::class, 'index'])->name('user.order.all');
    Route::get('/order/return', [OrderController::class, 'returnOrder'])->name('user.order.returned');
    Route::get('/order/cancel', [OrderController::class, 'cancelOrder'])->name('user.order.canceled');
    Route::get('/order/product/all/{order_id}', [OrderController::class, 'getOrderInfo'])->name('user.order.product');
    Route::get('/order/invoice/{order_id}', [OrderController::class, 'invoice'])->name('user.order.invoice');
    //Order Return Route
    Route::post('order/return/{order_id}', [OrderController::class, 'orderReturn'])->name('user.order.return');
    //Order Track Route
    Route::get('order/tracking-form', [OrderController::class, 'trackingForm'])->name('user.order.tracking');
    Route::post('/order/track', [OrderController::class, 'orderTrack'])->name('user.order.track');
    //Review Routes
    Route::get('/review/create/{id}', [ReviewController::class, 'create'])->name('user.review.create');
    Route::post('/review/store', [ReviewController::class, 'store'])->name('user.review.store');
});
