@extends('layouts.frontend-layout')
@section('title',"Wishlist Page")
@section('content')

<div class="breadcrumb">
	<div class="container">
		<div class="breadcrumb-inner">
			<ul class="list-inline list-unstyled">
				<li><a href="{{url('/')}}">{{session()->get('language')=='bangla' ? "হোম" : 'Home'}}</a></li>
				<li class='active'><a href="">{{session()->get('language')=='bangla' ? "উইশলিস্ট" : 'WishList'}}</a></li>
			</ul>
		</div><!-- /.breadcrumb-inner -->
	</div><!-- /.container -->
</div><!-- /.breadcrumb -->

<div class="body-content">
	<div class="container">
		<div class="my-wishlist-page">
			<div class="row">
				<div class="col-md-12 my-wishlist">
	<div class="table-responsive">
		<table class="table">
			<thead>
				<tr>
					<th colspan="4" class="heading-title">My Wishlist</th>
				</tr>
			</thead>
			<tbody>
                @forelse ($wishlists as $wishlist)
                    
				<tr>
					<td class="col-md-2"><img src="{{asset($wishlist?->product?->product_thumbnail)}}" alt="{{$wishlist?->product?->product_name_en}}"></td>
					<td class="col-md-7">
						<div class="product-name"><a href="{{route('product.detail',['id'=>$wishlist?->product->id,'slug'=>$wishlist?->product->product_slug_en])}}">{{$wishlist?->product->product_name_en}}</a></div>
						
                        @if ($wishlist?->product?->discount==null)
                        <div>
							<span>৳ {{$wishlist?->product?->selling_price}}</span>
						</div> 
                        @else
                        <div class="price">
							৳ {{$wishlist?->product?->discount_price}}
							<span>৳ {{$wishlist?->product?->selling_price}}</span>
						</div> 
                        @endif
						
					</td>
					<td class="col-md-2">
						
						<a type="button" class="btn-upper btn btn-primary" href="{{route('product.detail',['id'=>$wishlist?->product->id,'slug'=>$wishlist?->product->product_slug_en])}}}">View Product</button>
					</td>
					<td class="col-md-1 close-btn">
						<a href="{{route('user.wishlist.delete',$wishlist?->product->id)}}" class="btn btn-danger" id="delete" ><i class="fa fa-times"></i></button>
					</td>
				</tr>
                
                @empty
                    <tr>
                        <td colspan="4">Your WishList is Empty</td>
                    </tr>
                @endforelse
			</tbody>
		</table>
	</div>
</div>			</div><!-- /.row -->
		</div><!-- /.sigin-in-->
<!-- ============================================== BRANDS CAROUSEL ============================================== -->
		@include('frontend.inc.brand-carousel',['brands'=>$brands])
<!-- ======= BRANDS CAROUSEL : END=========== -->	
	</div><!-- /.container -->
</div><!-- /.body-content -->

@endsection
@section('scripts')
    <script type="text/javascript">
        $(document).on('click', '#delete', function(e) {
            e.preventDefault();
            let link = $(this).attr('href');
            Swal.fire({
                title: "Are your sure want to Delete This!",
                text: 'Once deleted, you will not be able to recover',
                icon: 'warning',
                showDenyButton: true,
                showCancelButton: true,
                confirmButtonText: 'Delete',
                denyButtonText: `Don't Delete`,
            }).then((willDelete) => {
                if (willDelete.isConfirmed) {
                    window.location.href = link;
                } else {
                    Swal.fire('Product Not Deleted from wishlist', '', 'info')
                }
            })
        });
        @if (session()->has('success'))
            Swal.fire({
                icon: 'success',
                text: "{{ session('success') }}"
            })
        @endif
        @if (session()->has('error'))
            Swal.fire({
                icon: 'error',
                text: "{{ session('error') }}"
            })
        @endif
        

    </script>
@endsection