@extends('layouts.frontend-layout')
@section('title', 'Checkout Page')
@section('content')

    <div class="breadcrumb">
        <div class="container">
            <div class="breadcrumb-inner">
                <ul class="list-inline list-unstyled">
                    <li><a href="{{ url('/') }}">Home</a></li>
                    <li class='active'>Checkout</li>
                </ul>
            </div><!-- /.breadcrumb-inner -->
        </div><!-- /.container -->
    </div><!-- /.breadcrumb -->

    <div class="body-content">
        <div class="container">
            <div class="checkout-box">
                <form class="register-form" action="{{ route('buy.shipping.store') }}" role="form" method="POST">
                    @csrf
                    <div class="row">
                        <div class="col-md-8">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="shipping-area">
                                        <h4 class="checkout-subtitle">Shipping Area</h4>
                                        @if ($errors->any())
                                            <div class="alert alert-danger">
                                                <ul>
                                                    @foreach ($errors->all() as $error)
                                                        <li>{{ $error }}</li>
                                                    @endforeach
                                                </ul>
                                            </div>
                                        @endif
                                        @if ($shippingAddress)
                                            <div class="row">
                                                @foreach ($shippingAddress as $address)
                                                    <div class="col-md-6 col-sm-6">
                                                        <div>

                                                            <label for="address-{{ $address->id }}" class="address-item">
                                                                <input type="radio" name="address_id"
                                                                    id="address-{{ $address->id }}" class="address-input"
                                                                    value="{{ $address->id }}">
                                                                <span>{{ $address->name }},
                                                                    {{ $address->address_1 }}</span>

                                                            </label>
                                                        </div>
                                                    </div>
                                                @endforeach
                                                <div class="col-md-6 col-sm-6">
                                                    <div class="address-item add-address">

                                                        <h5> <i class="fa fa-plus"></i> Add New Shipping Address</h5>
                                                    </div>
                                                </div>
                                            </div>
                                        @endif
                                        <div class="new-shipping-address {{ $shippingAddress ? 'd-none' : '' }}">
                                            <div class="row">
                                                <div class="col-md-6 col-12">
                                                    <div class="form-group">
                                                        <label class="info-title" for="name">Name
                                                            <span class="text-danger">*</span></label>
                                                        <input type="text"
                                                            class="form-control unicase-form-control text-input"
                                                            name="name" id="name" value="{{old('name')}}"
                                                            placeholder="Enter Your Full Name">
                                                    </div>

                                                </div>
                                                <div class="col-md-6 col-12">
                                                    <div class="form-group">
                                                        <label class="info-title" for="phone">Select Division
                                                            <span class="text-danger">*</span></label>
                                                        <select name="division_id"
                                                            class="form-control select2 select2-show-search unicase-form-control"
                                                            id="division"  value="{{old('division_id')}}">
                                                            <option value="">Choose One Division</option>
                                                        </select>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-md-6 col-12">
                                                    <div class="form-group">
                                                        <label class="info-title" for="email">Email Address
                                                            <span class="text-danger">*</span>
                                                        </label>
                                                        <input type="email" name="email"
                                                            class="form-control unicase-form-control text-input"  value="{{old('email')}}"
                                                            id="email" placeholder="Enter Email Address">
                                                    </div>

                                                </div>
                                                <div class="col-md-6 col-12">

                                                    <div class="form-group">
                                                        <label class="info-title" for="phone">Select District
                                                            <span class="text-danger">*</span></label>
                                                        <select name="district_id"
                                                            class="form-control select2 select2-show-search unicase-form-control"
                                                            id="district"  value="{{old('district_id')}}">
                                                        </select>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-md-6 col-12">
                                                    <div class="form-group">
                                                        <label class="info-title" for="phone">Phone Number
                                                            <span class="text-danger">*</span>
                                                        </label>
                                                        <input type="text" name="phone" value="{{old('phone')}}"
                                                            class="form-control unicase-form-control text-input"
                                                            id="phone" placeholder="Enter Your Phone Number">
                                                    </div>

                                                </div>

                                                <div class="col-md-6 col-12">
                                                    <div class="form-group">
                                                        <label class="info-title" for="phone">Select Thana
                                                            <span class="text-danger">*</span></label>
                                                        <select name="state_id"  value="{{old('state_id')}}"
                                                            class="form-control select2 select2-show-search unicase-form-control"
                                                            id="state">
                                                        </select>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-md-6 col-12">
                                                    <div class="form-group">
                                                        <label class="info-title" for="address1">Address 1
                                                            (House/Road/Holding)
                                                            <span class="text-danger">*</span></label>
                                                        <input type="text"  value="{{old('address1')}}"
                                                            class="form-control unicase-form-control text-input"
                                                            name="address1" id="address1"
                                                            placeholder="Enter Your Address 1">
                                                    </div>

                                                </div>
                                                <div class="col-md-6 col-12">
                                                    <div class="form-group">
                                                        <label class="info-title" for="post-code">Post Code
                                                           
                                                        </label>
                                                        <input type="text" value="{{old('post_code')}}"
                                                            class="form-control unicase-form-control text-input"
                                                            name="post_code" id="post-code"
                                                            placeholder="Enter Your Post Code">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-md-6 col-12">
                                                    <div class="form-group">
                                                        <label class="info-title" for="address2">Address 2
                                                            (House/Road/Holding)
                                                        </label>
                                                        <input type="text" value="{{old('address2')}}"
                                                            class="form-control unicase-form-control text-input"
                                                            name="address2" id="address2"
                                                            placeholder="Enter Your Address 2">
                                                    </div>
                                                </div>
                                                <div class="col-md-6 col-12">

                                                    <!--<div class="form-group">-->
                                                    <!--    <label class="info-title" for="phone">Shipping Cost-->
                                                    <!--        <span class="text-danger">*</span></label>-->
                                                    <!--    <select name="shipping_cost"-->
                                                    <!--        class="form-control unicase-form-control" id="shipping-cost">-->
                                                    <!--        <option value="">Select Shipping Cost</option>-->
                                                    <!--        @foreach ($costs as $cost)-->
                                                    <!--            <option value="{{ $cost->cost }}">-->
                                                    <!--                {{ $cost->area_name }}-{{ $cost->cost }}</option>-->
                                                    <!--        @endforeach-->

                                                    <!--    </select>-->
                                                    <!--</div>-->
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-md-12">
                                                    <div class="form-group">
                                                        <label for="phone">Notes </label>
                                                        <textarea name="notes" id="phone" class="form-control unicase-form-control"></textarea>
                                                    </div>
                                                    <div class="form-group">
                                                        <label for="save-address">
                                                            <input type="checkbox" name="save_address" id="save-address" value="{{old('save_address')}}">
                                                            Save This Address
                                                        </label>
                                                    </div>


                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-12" style="margin-top:40px">
                                                <div class="shopping-cart-table ">
                                                    <div class="table-responsive">
                                                        <table class="table">
                                                            <thead>
                                                                <tr>
                                                                    <th class="cart-product-name item">Product Name</th>
                                                                    <th class="cart-description item text-center" >Image</th>
                                                                    <th class="cart-qty item text-center">Quantity</th>
                                                                    <th class="cart-sub-total item text-center">Price</th>
                                                                    <th class="cart-total last-item text-center">Subtotal</th>
                                                                </tr>
                                                            </thead><!-- /thead -->
                                                            
                                                            <tbody class="buy-item">
                                                                <tr>
                                                                    <td class="cart-product-name-info">
                                                                        <h4 class="cart-product-description"><a
                                                                                href="detail.html">{{ $product->product_name_en }}</a></h4>
                                                                        <div class="cart-product-info">
                                                                            <span class="product-color">COLOR:
                                                                                <span style="text-transform:capitalize">{{ $color }}
                                                                                </span>
                                                                            </span>
                                                                        </div>
                                                                    </td>
                                                                    <td class="cart-image">
                                                                        <a class="entry-thumbnail" href="">
                                                                            <img src="{{ asset($product->product_thumbnail) }}" style="width: 100px" alt="{{ $product->product_name_en }}">
                                                                        </a>
                                                                    </td>
                            
                                                                    <td class="cart-product-quantity">
                                                                        <div stye="display:flex;">
                                                                            {{ $qty }}
                                                                        </div>
                                                                    </td>
                                                                    <td class="cart-product-sub-total"><span class="cart-sub-total-price">৳
                                                                            {{ $price }}</span>
                                                                    </td>
                                                                    <td class="cart-product-grand-total">
                                                                        <span class="cart-grand-total-price">
                                                                            ৳{{ $price * $qty }}</span>
                                                                    </td>
                                                                </tr>
                                                            </tbody><!-- /tbody -->
                                                        </table><!-- /table -->
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-12">
                                                <div class="form-group" style="padding: 0 15px;">
                                                    <button type="submit" class="btn btn-success">Proceed To
                                                        Checkout</button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="row">

                                <div class="col-md-12">
                                    <!-- checkout-progress-sidebar -->
                                    <div class="checkout-progress-sidebar ">
                                        <div class="panel-group">
                                            <div class="panel panel-default">
                                                <div class="panel-heading">
                                                    <h4 class="unicase-checkout-title">Choose Your Payment Method</h4>
                                                </div>
                                                <div class="payment-methods">
                                                    <ul>
                                                        <li>
                                                            <input type="radio" name="payment_method" id="stripe" value="stripe" disabled>
                                                            <label for="stripe"><img src="{{asset('assets/frontend/images/checkout/stripe.png')}}" class="img-100" /></label>
                                                        </li>

                                                        <li>
                                                            <input type="radio" name="payment_method" id="amaarpay-image" value="amaarpay" class="" disabled>
                                                            <label for="amaarpay-image"><img src="{{asset('assets/frontend/images/checkout/bkash-rocket-nagad.jpeg')}}" class="img-100" /></label>
                                                        </li>
                                                        <li>
                                                            <input type="radio" name="payment_method" id="sslcommerz-hosted" value="amaarpay" disabled>
                                                            <label for="sslcommerz-hosted"><img src="{{asset('assets/frontend/images/checkout/visa-mastercard.jpeg')}}" class="img-100" /></label>
                                                        </li>
                                                        <li>
                                                            <input type="radio" name="payment_method" id="cod" checked value="cod">
                                                            <label for="cod"><img src="{{asset('assets/frontend/images/checkout/cash-on-delivery.jpeg')}}" class="img-100" /></label>
                                                        </li>
                                                    </ul>
                                                </div>
                                            </div>
                                        </div>
                                    </div><!-- checkout-progress-sidebar -->
                                </div>
                                <div class="col-md-12">
                                    <!-- checkout-progress-sidebar -->
                                    <div class="checkout-progress-sidebar ">
                                        <div class="panel-group">
                                            <div class="panel panel-default">
                                                <div class="panel-heading">
                                                    <h4 class="unicase-checkout-title">Your Checkout Progress</h4>
                                                </div>
                                                
                                                <div class="">
                                                    @if (session()->has('coupon'))
                                                        <div class="cart-sub-total" style="font-size: 18px">
                                                            Subtotal<span
                                                                class="inner-left-md">৳{{ $price * $qty  }}</span>
                                                        </div>
                                                        <div class="cart-grand-total" style="font-size: 20px">
                                                            Total:
                                                            <span class="inner-left-md" style="color:rgb(6, 168, 6);"
                                                                id="grand-total">৳{{ $price * $qty  }}</span>
                                                        </div>
                                                    @else
                                                        <div class="cart-grand-total" style="font-size: 20px">
                                                            Total:<span class="inner-left-md"
                                                                style="color:rgb(6, 168, 6);"
                                                                id="grand-total">৳{{ $price * $qty  }}</span>
                                                        </div>
                                                    @endif


                                                    <input type="hidden" id="total-amount" value="{{ $total }}">
                                                </div>
                                            </div>
                                        </div>
                                    </div><!-- checkout-progress-sidebar -->
                                </div>
                            </div>
                        </div>
                    </div><!-- /.row -->
                </form>
            </div><!-- /.checkout-box -->

        </div><!-- /.container -->
    </div><!-- /.body-content -->

@endsection
@section('scripts')
    <script type="text/javascript">
        $(".add-address").on("click", function() {
            $(".new-shipping-address").slideToggle();
            $(".address-input").removeAttr('checked');
        });
        $(".address-input").on("click", function() {
            $(".new-shipping-address").removeAttr('style');
        });

        function getAllDivision() {
            axios.get("{{ url('/user/checkout/division') }}")
                .then(function(response) {
                    if (response.status === 200) {
                        $.each(response.data.divisions, function(id, division) {
                            $('#division').append(
                                '<option value="' + division.id + '">' + division.name + '</option>'
                            )
                        })
                    }
                })
                .catch(function(error) {
                    console.log(error);
                })
        }
        getAllDivision();
        $('#division').on('change', function() {
            let divisionId = $('#division').val();
            axios.get("{{ url('/user/checkout/district') }}/" + divisionId)
                .then(function(response) {
                    console.log(response.data.districts);
                    if (response.status === 200) {
                        $('#district').empty();
                        $('#district').append(
                            '<option value="">Choose One</option>'
                        )
                        $.each(response.data.districts, function(id, district) {
                            $('#district').append(
                                '<option value="' + district.id + '">' + district.name + '</option>'
                            )
                        })
                    }
                })
                .catch(function(error) {
                    console.log(error);
                })
        })
        $('#district').on('change', function() {
            let districtId = $('#district').val();
            axios.get("{{ url('/user/checkout/state') }}/" + districtId)
                .then(function(response) {
                    if (response.status === 200) {
                        $('#state').empty();
                        $('#state').append(
                            '<option value="">Choose One</option>'
                        )
                        $.each(response.data.states, function(id, state) {
                            $('#state').append(
                                '<option value="' + state.id + '">' + state.name + '</option>'
                            )
                        })
                    }
                })
                .catch(function(error) {
                    console.log(error);
                })
        })
        $('#shipping-cost').on('change', function() {
            if ($('#shipping-cost').val() == '') {
                let totalAmount = $('#total-amount').val();
                $('#grand-total').html("৳ " + totalAmount);
            } else {
                let shippingCost = $('#shipping-cost').val();
                let totalAmount = $('#total-amount').val();
                let grandTotal = parseInt(shippingCost) + parseInt(totalAmount);
                $('#grand-total').html("৳ " + grandTotal);
            }
        });
    </script>
@endsection
